/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.opc.axis.client;

import com.connecterra.i18n.I18N;
import com.connecterra.opc.api.OPC;
import com.connecterra.opc.api.OPCException;
import com.connecterra.opc.api.OPCItemObserver;
import com.connecterra.opc.api.OPCStatus;
import com.connecterra.opc.api.TimeoutException;
import com.connecterra.opc.axis.client.AxisOPCStatus;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.opcfoundation.webservices.xmlda.axis.service.ItemValue;
import org.opcfoundation.webservices.xmlda.axis.service.OPCError;
import org.opcfoundation.webservices.xmlda.axis.service.ReadRequestItem;
import org.opcfoundation.webservices.xmlda.axis.service.ReadRequestItemList;
import org.opcfoundation.webservices.xmlda.axis.service.ReplyBase;
import org.opcfoundation.webservices.xmlda.axis.service.ReplyItemList;
import org.opcfoundation.webservices.xmlda.axis.service.ServerState;
import org.opcfoundation.webservices.xmlda.axis.service.ServerStatus;
import org.opcfoundation.webservices.xmlda.axis.service.Service;
import org.opcfoundation.webservices.xmlda.axis.service.ServiceStub;
import org.opcfoundation.webservices.xmlda.axis.service.SubscribeItemValue;
import org.opcfoundation.webservices.xmlda.axis.service.SubscribePolledRefreshReplyItemList;
import org.opcfoundation.webservices.xmlda.axis.service.SubscribeReplyItemList;
import org.opcfoundation.webservices.xmlda.axis.service.SubscribeRequestItem;
import org.opcfoundation.webservices.xmlda.axis.service.SubscribeRequestItemList;
import org.opcfoundation.webservices.xmlda.axis.service.WriteRequestItemList;
import org.opcfoundation.webservices.xmlda.axis.service.XMLDAServiceLocator;
import org.opcfoundation.webservices.xmlda.axis.service._GetStatus;
import org.opcfoundation.webservices.xmlda.axis.service._GetStatusResponse;
import org.opcfoundation.webservices.xmlda.axis.service._Read;
import org.opcfoundation.webservices.xmlda.axis.service._ReadResponse;
import org.opcfoundation.webservices.xmlda.axis.service._Subscribe;
import org.opcfoundation.webservices.xmlda.axis.service._SubscribeResponse;
import org.opcfoundation.webservices.xmlda.axis.service._SubscriptionCancel;
import org.opcfoundation.webservices.xmlda.axis.service._SubscriptionCancelResponse;
import org.opcfoundation.webservices.xmlda.axis.service._SubscriptionPolledRefresh;
import org.opcfoundation.webservices.xmlda.axis.service._SubscriptionPolledRefreshResponse;
import org.opcfoundation.webservices.xmlda.axis.service._Write;
import org.opcfoundation.webservices.xmlda.axis.service._WriteResponse;

public class AxisOPCClient
implements OPC {
    private static final long d = 60000L;
    private static Logger e = Logger.getLogger("com.connecterra.opc.axis.client.AxisOPCClient");
    private Service c;

    public AxisOPCClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException("Specified OPC Service URL is null");
        }
        e.fine("Instantiating locator");
        XMLDAServiceLocator xMLDAServiceLocator = new XMLDAServiceLocator();
        e.fine("Connecting to XMLDAService at " + uRL + "...");
        try {
            this.c = xMLDAServiceLocator.getXMLDAService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
        e.fine("Connection established to XMLDAService.");
    }

    public void setTimeout(long l) {
        ((ServiceStub)this.c).setTimeout((int)l);
    }

    private static void b(ReplyBase replyBase) throws OPCException {
        if (replyBase == null) {
            return;
        }
        ServerState serverState = replyBase.getServerState();
        if (serverState == null) {
            return;
        }
        if (serverState.equals(ServerState.running) || serverState.equals(ServerState.test) || serverState.equals(ServerState.commFault)) {
            return;
        }
        throw new OPCException(I18N.get("server state is {0}", serverState));
    }

    private static ItemValue b(String string, ReplyItemList replyItemList, OPCError[] oPCErrorArray) throws OPCException {
        if (replyItemList == null || replyItemList.getItems() == null || replyItemList.getItems(0) == null) {
            throw new OPCException(I18N.get("no Items in returned ReplyItemList"));
        }
        ItemValue itemValue = replyItemList.getItems(0);
        AxisOPCClient.b(string, itemValue, oPCErrorArray);
        return itemValue;
    }

    private static ItemValue[] b(String[] stringArray, SubscribeReplyItemList subscribeReplyItemList, OPCError[] oPCErrorArray) throws OPCException {
        if (subscribeReplyItemList == null || subscribeReplyItemList.getItems() == null) {
            throw new OPCException(I18N.get("no Items in returned ReplyItemList"));
        }
        SubscribeItemValue[] subscribeItemValueArray = subscribeReplyItemList.getItems();
        ItemValue[] itemValueArray = new ItemValue[subscribeItemValueArray.length];
        for (int i = 0; i < subscribeItemValueArray.length; ++i) {
            if (subscribeItemValueArray[i] == null) {
                throw new OPCException(I18N.get("malformed ReplyItemList"));
            }
            itemValueArray[i] = subscribeItemValueArray[i].getItemValue();
            if (itemValueArray[i] == null) {
                throw new OPCException(I18N.get("malformed ReplyItemList"));
            }
            AxisOPCClient.b(stringArray[i], itemValueArray[i], oPCErrorArray);
        }
        return itemValueArray;
    }

    private static ItemValue[] b(String[] stringArray, SubscribePolledRefreshReplyItemList[] subscribePolledRefreshReplyItemListArray, OPCError[] oPCErrorArray) throws OPCException {
        if (subscribePolledRefreshReplyItemListArray == null || subscribePolledRefreshReplyItemListArray[0] == null || subscribePolledRefreshReplyItemListArray[0].getItems() == null) {
            throw new OPCException(I18N.get("no Items in returned ReplyItemList"));
        }
        ItemValue[] itemValueArray = subscribePolledRefreshReplyItemListArray[0].getItems();
        for (int i = 0; i < itemValueArray.length; ++i) {
            if (itemValueArray[i] == null) {
                throw new OPCException(I18N.get("malformed ReplyItemList"));
            }
            AxisOPCClient.b(stringArray[i], itemValueArray[i], oPCErrorArray);
        }
        return itemValueArray;
    }

    private static void b(String string, ItemValue itemValue, OPCError[] oPCErrorArray) throws OPCException {
        QName qName = itemValue.getResultID();
        if (qName == null) {
            return;
        }
        OPCError oPCError = null;
        for (int i = 0; i < oPCErrorArray.length; ++i) {
            if (!qName.equals(oPCErrorArray[i].getID())) continue;
            oPCError = oPCErrorArray[i];
            break;
        }
        if (oPCError == null) {
            throw new OPCException(I18N.get("returned item has unknown error id"));
        }
        throw new OPCException(I18N.get("item \"{0}\": {1}", (Object)string, (Object)oPCError.getText()));
    }

    public OPCStatus getStatus() throws RemoteException, OPCException {
        _GetStatus _GetStatus2 = new _GetStatus();
        _GetStatusResponse _GetStatusResponse2 = this.c.getStatus(_GetStatus2);
        ReplyBase replyBase = _GetStatusResponse2.getGetStatusResult();
        ServerStatus serverStatus = _GetStatusResponse2.getStatus();
        return new AxisOPCStatus(replyBase, serverStatus);
    }

    public Object read(String string) throws RemoteException, OPCException {
        _Read _Read2 = new _Read();
        ReadRequestItemList readRequestItemList = new ReadRequestItemList();
        ReadRequestItem readRequestItem = new ReadRequestItem();
        readRequestItem.setItemName(string);
        readRequestItemList.setItems(new ReadRequestItem[]{readRequestItem});
        _Read2.setItemList(readRequestItemList);
        _ReadResponse _ReadResponse2 = this.c.read(_Read2);
        ReplyBase replyBase = _ReadResponse2.getReadResult();
        ReplyItemList replyItemList = _ReadResponse2.getRItemList();
        OPCError[] oPCErrorArray = _ReadResponse2.getErrors();
        AxisOPCClient.b(replyBase);
        ItemValue itemValue = AxisOPCClient.b(string, replyItemList, oPCErrorArray);
        return itemValue.getValue();
    }

    public void write(String string, Object object) throws RemoteException, OPCException {
        _Write _Write2 = new _Write();
        WriteRequestItemList writeRequestItemList = new WriteRequestItemList();
        ItemValue itemValue = new ItemValue();
        itemValue.setItemName(string);
        itemValue.setValue(object);
        writeRequestItemList.setItems(new ItemValue[]{itemValue});
        _Write2.setItemList(writeRequestItemList);
        _WriteResponse _WriteResponse2 = this.c.write(_Write2);
        ReplyBase replyBase = _WriteResponse2.getWriteResult();
        ReplyItemList replyItemList = _WriteResponse2.getRItemList();
        OPCError[] oPCErrorArray = _WriteResponse2.getErrors();
        AxisOPCClient.b(replyBase);
        AxisOPCClient.b(string, replyItemList, oPCErrorArray);
    }

    public Object poll(String string, long l) throws RemoteException, OPCException, TimeoutException {
        Object[] objectArray = this.poll(new String[]{string}, l);
        if (objectArray == null) {
            return null;
        }
        return objectArray[0];
    }

    public Object[] poll(String[] stringArray, long l) throws RemoteException, OPCException, TimeoutException {
        return this.poll(stringArray, null, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] poll(String[] stringArray, Object[] objectArray, long l) throws RemoteException, OPCException, TimeoutException {
        Serializable serializable;
        _Subscribe _Subscribe2 = new _Subscribe();
        SubscribeRequestItemList subscribeRequestItemList = new SubscribeRequestItemList();
        SubscribeRequestItem[] subscribeRequestItemArray = new SubscribeRequestItem[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            serializable = new SubscribeRequestItem();
            serializable.setItemName(stringArray[i]);
            subscribeRequestItemArray[i] = serializable;
        }
        subscribeRequestItemList.setItems(subscribeRequestItemArray);
        _Subscribe2.setItemList(subscribeRequestItemList);
        if (objectArray == null) {
            _Subscribe2.setReturnValuesOnReply(true);
        }
        _SubscribeResponse _SubscribeResponse2 = this.c.subscribe(_Subscribe2);
        serializable = _SubscribeResponse2.getSubscribeResult();
        SubscribeReplyItemList subscribeReplyItemList = _SubscribeResponse2.getRItemList();
        OPCError[] oPCErrorArray = _SubscribeResponse2.getErrors();
        String string = _SubscribeResponse2.getServerSubHandle();
        try {
            int n;
            AxisOPCClient.b((ReplyBase)serializable);
            ItemValue[] itemValueArray = AxisOPCClient.b(stringArray, subscribeReplyItemList, oPCErrorArray);
            if (objectArray == null) {
                objectArray = new Object[itemValueArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    if (itemValueArray[n] == null) continue;
                    objectArray[n] = itemValueArray[n].getValue();
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] != null) continue;
                e.finest("reading initial value of itemValues[" + n + "]");
                objectArray[n] = this.read(stringArray[n]);
            }
            Object[] objectArray2 = this.b(stringArray, objectArray, string, l);
            return objectArray2;
        }
        finally {
            if (string != null) {
                this.b(string);
            }
        }
    }

    private Object[] b(String[] stringArray, Object[] objectArray, String string, long l) throws RemoteException, OPCException, TimeoutException {
        long l2;
        _SubscriptionPolledRefresh _SubscriptionPolledRefresh2 = new _SubscriptionPolledRefresh();
        _SubscriptionPolledRefresh2.setServerSubHandles(new String[]{string});
        _SubscriptionPolledRefresh2.setReturnAllItems(true);
        Object[] objectArray2 = new Object[objectArray.length];
        long l3 = l2 = l == 0L ? 0L : System.currentTimeMillis() + l;
        while (true) {
            long l4;
            if (l2 > 0L) {
                l4 = l2 - System.currentTimeMillis();
                if (l4 <= 0L) {
                    throw new TimeoutException();
                }
            } else {
                l4 = 60000L;
            }
            _SubscriptionPolledRefresh2.setWaitTime((int)l4);
            _SubscriptionPolledRefreshResponse _SubscriptionPolledRefreshResponse2 = this.c.subscriptionPolledRefresh(_SubscriptionPolledRefresh2);
            ReplyBase replyBase = _SubscriptionPolledRefreshResponse2.getSubscriptionPolledRefreshResult();
            SubscribePolledRefreshReplyItemList[] subscribePolledRefreshReplyItemListArray = _SubscriptionPolledRefreshResponse2.getRItemList();
            OPCError[] oPCErrorArray = _SubscriptionPolledRefreshResponse2.getErrors();
            AxisOPCClient.b(replyBase);
            if (subscribePolledRefreshReplyItemListArray == null || subscribePolledRefreshReplyItemListArray.length == 0) continue;
            ItemValue[] itemValueArray = AxisOPCClient.b(stringArray, subscribePolledRefreshReplyItemListArray, oPCErrorArray);
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    e.finer("value " + i + " changed from null to " + itemValueArray[i].getValue());
                } else {
                    if (itemValueArray[i] == null || itemValueArray[i].getValue() == null) {
                        e.finer("value " + i + " changed from " + objectArray[i] + " to null");
                        continue;
                    }
                    if (objectArray[i].equals(itemValueArray[i].getValue())) continue;
                    e.finer("value " + i + " changed from " + objectArray[i] + " to " + itemValueArray[i].getValue());
                }
                objectArray2[i] = itemValueArray[i].getValue();
                bl = true;
            }
            if (bl) break;
        }
        return objectArray2;
    }

    private void b(String string) throws RemoteException, OPCException {
        _SubscriptionCancel _SubscriptionCancel2 = new _SubscriptionCancel();
        _SubscriptionCancel2.setServerSubHandle(string);
        _SubscriptionCancelResponse _SubscriptionCancelResponse2 = this.c.subscriptionCancel(_SubscriptionCancel2);
    }

    public void subscribe(String string, OPCItemObserver oPCItemObserver, long l) throws RemoteException, OPCException {
        throw new UnsupportedOperationException("AxisOPCClient.subscribe is not yet implemented");
    }

    public void unsubscribe(String string, OPCItemObserver oPCItemObserver) throws RemoteException, OPCException {
        throw new UnsupportedOperationException("AxisOPCClient.unsubscribe is not yet implemented");
    }

    public void unsubscribeItem(String string) throws RemoteException, OPCException {
        throw new UnsupportedOperationException("AxisOPCClient.unsubscribeItem is not yet implemented");
    }

    public void unsubscribeAll() throws RemoteException, OPCException {
        throw new UnsupportedOperationException("AxisOPCClient.unsubscribeAll is not yet implemented");
    }
}

