/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.modbus.client.MODBUSClient;
import com.connecterra.modbus.client.ModbusException;
import com.connecterra.modbus.client.TooManyTransactionsException;
import com.connecterra.modbus.protocol.MODBUSPDU;
import com.connecterra.modbus.protocol.ReadDiscreteInputsRequestPDU;
import com.connecterra.modbus.protocol.ReadDiscreteInputsResponsePDU;
import com.connecterra.modbus.protocol.WriteSingleCoilRequestPDU;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plctypes.PLCPollTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModBusTransport
extends PLCPollTransport {
    private static Logger ab = Logger.getLogger(ModBusTransport.class.getName());
    private static final String v = "hostname";
    private static final String w = "port";
    private static final String db = "socketTimeout";
    private static final String cb = "minimumDelay";
    private static final String t = "unitid";
    private static final String z = "502";
    private static final String ib = "15000";
    private static final String hb = "1";
    private static final String bb = "0";
    private MODBUSClient x;
    private String u = null;
    private String s;
    private int y;
    private int fb;
    private int gb;
    private long eb;

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        super.initialize(pLCFactory, "ModBusTransport " + string, rawConfig);
        this.u = string;
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem(v);
        validatedConfig.addIntegerItem(w, 1, 65535, z);
        validatedConfig.addIntegerItem(db, 0, ib);
        validatedConfig.addIntegerItem(t, 0, hb);
        validatedConfig.addLongItem(cb, 0L, bb);
        validatedConfig.readFrom(rawConfig);
        this.s = validatedConfig.getStringValue(v);
        this.y = validatedConfig.getIntegerValue(w);
        this.fb = validatedConfig.getIntegerValue(db);
        this.gb = validatedConfig.getIntegerValue(t);
        this.eb = validatedConfig.getLongValue(cb);
    }

    protected synchronized void connect() throws IOException {
        if (this.x != null) {
            return;
        }
        ab.fine("Initializing ModBus connection with host: " + this.s + " port:" + this.y);
        this.x = new MODBUSClient(this.s, this.y, this.fb, this.gb, -1, this.eb);
    }

    public List read(List list) throws IOException, PLCException {
        this.connect();
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.d((String)list.get(i)));
        }
        return arrayList;
    }

    private Object d(String string) throws IOException, PLCException {
        ab.fine("Reading request: " + string);
        MODBUSPDU mODBUSPDU = null;
        Boolean bl = null;
        try {
            MBNamingParser mBNamingParser = new MBNamingParser(string);
            switch (mBNamingParser.getRequestType()) {
                case 'D': 
                case 'd': {
                    mODBUSPDU = this.x.send(new ReadDiscreteInputsRequestPDU(mBNamingParser.getAddress(), 1));
                    bl = new Boolean(((ReadDiscreteInputsResponsePDU)mODBUSPDU).getValue(0));
                    break;
                }
                case 'C': 
                case 'c': {
                    throw new PLCException("Type Coil is not supported for reading");
                }
                case 'H': 
                case 'h': {
                    throw new PLCException("Type Holding register not supported for reading");
                }
                case 'R': 
                case 'r': {
                    throw new PLCException("Type Register not supported for reading");
                }
                default: {
                    throw new PLCException("Request name {0} has unrecognized type.");
                }
            }
        }
        catch (TooManyTransactionsException tooManyTransactionsException) {
            throw new PLCException(tooManyTransactionsException.getMessage(), tooManyTransactionsException);
        }
        catch (ModbusException modbusException) {
            throw new PLCException(modbusException.getMessage(), modbusException);
        }
        catch (IOException iOException) {
            this.e();
            throw iOException;
        }
        ab.fine("Returned value: " + bl);
        return bl;
    }

    public void write(List list, List list2) throws IOException, PLCException {
        this.connect();
        ab.fine("itemNames = " + list);
        ab.fine("values = " + list2);
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("itemNames and values must have same size");
        }
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object e = iterator2.next();
            if (e == null) continue;
            this.c(string, e);
        }
    }

    private void c(String string, Object object) throws IOException, PLCException {
        MODBUSPDU mODBUSPDU = null;
        try {
            MBNamingParser mBNamingParser = new MBNamingParser(string);
            switch (mBNamingParser.d) {
                case 'C': 
                case 'c': {
                    boolean bl;
                    if (object instanceof Boolean) {
                        bl = (Boolean)object;
                    } else if (object instanceof Number) {
                        bl = ((Number)object).intValue() != 0;
                    } else {
                        throw new PLCException("Coil values must be type Boolean or Number");
                    }
                    ab.fine("Writing Request: " + string + ", " + object);
                    mODBUSPDU = this.x.send(new WriteSingleCoilRequestPDU(mBNamingParser.getAddress(), bl));
                    break;
                }
                case 'Z': 
                case 'z': {
                    ab.finest("Write not performed for dummy register " + mBNamingParser.getRequestType() + mBNamingParser.getAddress());
                    break;
                }
                case 'H': 
                case 'h': {
                    throw new PLCException("Type Holding register is not supported for writing");
                }
                case 'R': 
                case 'r': {
                    throw new PLCException("Type Registers are not supported for writing");
                }
                case 'D': 
                case 'd': {
                    throw new PLCException("Type Discrete input is not supported for writing");
                }
                default: {
                    throw new PLCException("Request name {0} has unrecognized type.");
                }
            }
        }
        catch (TooManyTransactionsException tooManyTransactionsException) {
            throw new PLCException(tooManyTransactionsException.getMessage(), tooManyTransactionsException);
        }
        catch (ModbusException modbusException) {
            throw new PLCException(modbusException.getMessage(), modbusException);
        }
        catch (IOException iOException) {
            this.e();
            throw iOException;
        }
    }

    private synchronized void e() {
        ab.log(Level.FINE, "ModBus connection to " + this.s + ":" + this.y + " failed, creating new client");
        this.x = null;
        try {
            this.connect();
        }
        catch (IOException iOException) {
            ab.log(Level.FINE, "initial reconnect attempt failed: " + iOException.getMessage(), iOException);
        }
    }

    public synchronized boolean isAlive() {
        return this.x != null;
    }

    private class MBNamingParser {
        private int c;
        private char d;

        MBNamingParser(String string) throws PLCException {
            this.b(string);
        }

        void b(String string) throws PLCException {
            if (string == null | string.length() == 0) {
                throw new PLCException("Null request name");
            }
            this.d = string.charAt(0);
            String string2 = string.substring(1);
            try {
                this.c = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new PLCException("address not a number, use format like D1234");
            }
        }

        public char getRequestType() {
            return this.d;
        }

        public int getAddress() {
            return this.c;
        }
    }
}

