/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.connectionPool.Connection;
import com.connecterra.connectionPool.ConnectionCreateException;
import com.connecterra.connectionPool.ConnectionPool;
import com.connecterra.connectionPool.FactoryConnectionPool;
import com.connecterra.opc.api.OPCException;
import com.connecterra.opc.axis.client.AxisOPCConnectionFactory;
import com.connecterra.opc.connectionPool.OPCConnection;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.ListOfOne;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class OPCXMLTransport
implements PLCTransport {
    private static Logger jb = Logger.getLogger(OPCXMLTransport.class.getName());
    private ConnectionPool lb;
    private String kb = null;
    private URL mb;

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        this.kb = string;
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addURLItem("url");
        validatedConfig.readFrom(rawConfig);
        this.mb = validatedConfig.getURLValue("url");
        jb.fine("Initializing OPC connection pool with URL: " + this.mb.toString());
        this.lb = new FactoryConnectionPool("OPC XMLDA " + this.mb, new AxisOPCConnectionFactory(this.mb));
    }

    public List read(List list) throws IOException, PLCException {
        if (list.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (list.size() > 1) {
            throw new PLCException("only one item at a time may be read");
        }
        return new ListOfOne(this.e((String)list.get(0)));
    }

    private Object e(String string) throws IOException, PLCException {
        Connection connection = null;
        try {
            connection = this.lb.checkout();
            Object object = ((OPCConnection)connection).getOPC().read(string);
            return object;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        catch (ConnectionCreateException connectionCreateException) {
            IOException iOException = new IOException(connectionCreateException.getMessage());
            iOException.initCause(connectionCreateException);
            throw iOException;
        }
        catch (OPCException oPCException) {
            throw new PLCException(oPCException.getMessage(), oPCException);
        }
        finally {
            if (connection != null) {
                this.lb.checkin(connection);
            }
        }
    }

    public void write(List list, List list2) throws IOException, PLCException {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("itemNames and values must have same size");
        }
        if (list.size() == 0) {
            return;
        }
        if (list.size() > 1) {
            throw new PLCException("only one item at a time may be written");
        }
        if (list2.get(0) != null) {
            this.d((String)list.get(0), list2.get(0));
        }
    }

    private void d(String string, Object object) throws IOException, PLCException {
        Connection connection = null;
        jb.fine("Writing to OPC_XML: " + string + ", " + object);
        try {
            connection = this.lb.checkout();
            ((OPCConnection)connection).getOPC().write(string, object);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        catch (ConnectionCreateException connectionCreateException) {
            IOException iOException = new IOException(connectionCreateException.getMessage());
            iOException.initCause(connectionCreateException);
            throw iOException;
        }
        catch (OPCException oPCException) {
            throw new PLCException(oPCException.getMessage(), oPCException);
        }
        finally {
            if (connection != null) {
                this.lb.checkin(connection);
            }
        }
    }

    public void addListener(String string, PLCListener pLCListener, Object object) throws IOException, PLCException {
        throw new PLCException("not supported yet");
    }

    public void removeListener(String string, PLCListener pLCListener) throws IOException, PLCException {
    }

    public void removeAllListeners(String string) {
    }

    public boolean isAlive() {
        return true;
    }
}

