/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.event.Event;
import com.connecterra.util.event.EventReceiver;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ReaderTransport
implements PLCTransport {
    private PLCFactory b;
    private String e;
    private RawConfig c;
    private Set g = Collections.synchronizedSet(new HashSet());
    private volatile PLCTransport d;
    private volatile EventReceiver f;

    public static void registerPLCTransport(PLCFactory pLCFactory, String string, PLCTransport pLCTransport, EventReceiver eventReceiver) throws PLCException, ConfigValidationException {
        PLCTransport pLCTransport2 = pLCFactory.getTransport(string);
        if (!(pLCTransport2 instanceof ReaderTransport)) {
            throw new PLCException(I18N.get("PLCTransport {0} is not a ReaderTransport", string));
        }
        ((ReaderTransport)pLCTransport2).registerPLCTransport(pLCTransport, eventReceiver);
    }

    public static void unregisterPLCTransport(PLCFactory pLCFactory, String string, PLCTransport pLCTransport) throws PLCException {
        PLCTransport pLCTransport2 = pLCFactory.getTransport(string);
        if (!(pLCTransport2 instanceof ReaderTransport)) {
            throw new PLCException(I18N.get("PLCTransport {0} is not a ReaderTransport", string));
        }
        ((ReaderTransport)pLCTransport2).unregisterPLCTransport(pLCTransport);
    }

    private void b() throws PLCException {
        if (this.d == null || this.f == null) {
            throw new PLCException(I18N.get("Reader-based PLC transport {0} not yet initialized, will retry", this.e));
        }
    }

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        this.b = pLCFactory;
        this.e = string;
        this.c = rawConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPLCTransport(PLCTransport pLCTransport, EventReceiver eventReceiver) throws ConfigValidationException, PLCException {
        if (this.d != null || this.f != null) {
            this.unregisterPLCTransport(this.d);
        }
        this.d = pLCTransport;
        this.f = eventReceiver;
        this.d.initialize(this.b, this.e, this.c);
        try {
            Set set = this.g;
            synchronized (set) {
                Iterator iterator = this.g.iterator();
                while (iterator.hasNext()) {
                    ((CachedListener)iterator.next()).addToTransport(this.d);
                }
            }
        }
        catch (IOException iOException) {
            throw new PLCException(iOException.getMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPLCTransport(PLCTransport pLCTransport) throws PLCException {
        if (this.d == null || this.f == null) {
            return;
        }
        try {
            Set set = this.g;
            synchronized (set) {
                Iterator iterator = this.g.iterator();
                while (iterator.hasNext()) {
                    ((CachedListener)iterator.next()).removeFromTransport(pLCTransport);
                }
            }
        }
        catch (IOException iOException) {
            throw new PLCException(iOException.getMessage(), iOException);
        }
        if (this.d == pLCTransport) {
            this.d = null;
            this.f = null;
        }
    }

    public List read(final List list) throws IOException, PLCException {
        this.b();
        PLCEvent pLCEvent = new PLCEvent(){

            protected List plcOperation() throws PLCException, IOException {
                return ReaderTransport.this.d.read(list);
            }
        };
        this.f.receiveEvent(pLCEvent);
        return pLCEvent.get();
    }

    public void write(final List list, final List list2) throws IOException, PLCException {
        this.b();
        PLCEvent pLCEvent = new PLCEvent(){

            protected List plcOperation() throws PLCException, IOException {
                ReaderTransport.this.d.write(list, list2);
                return null;
            }
        };
        this.f.receiveEvent(pLCEvent);
        pLCEvent.get();
    }

    public void addListener(String string, PLCListener pLCListener, Object object) throws IOException, PLCException {
        this.g.add(new CachedListener(string, pLCListener, object));
        if (this.d != null) {
            this.d.addListener(string, pLCListener, object);
        }
    }

    public void removeListener(String string, PLCListener pLCListener) throws IOException, PLCException {
        this.g.remove(new CachedListener(string, pLCListener, null));
        if (this.d != null) {
            this.d.removeListener(string, pLCListener);
        }
    }

    public void removeAllListeners(String string) throws IOException, PLCException {
        this.g.clear();
        if (this.d != null) {
            this.d.removeAllListeners(string);
        }
    }

    public boolean isAlive() {
        try {
            this.b();
        }
        catch (PLCException pLCException) {
            return false;
        }
        return this.d.isAlive();
    }

    private static abstract class PLCEvent
    implements Event {
        private List e;
        private PLCException d;
        private IOException c;
        private boolean b;

        private PLCEvent() {
        }

        protected abstract List plcOperation() throws PLCException, IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle() {
            try {
                PLCEvent pLCEvent = this;
                synchronized (pLCEvent) {
                    this.e = this.plcOperation();
                    this.b = true;
                    this.notify();
                }
            }
            catch (PLCException pLCException) {
                this.d = pLCException;
            }
            catch (IOException iOException) {
                this.c = iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List get() throws PLCException, IOException {
            PLCEvent pLCEvent = this;
            synchronized (pLCEvent) {
                while (!this.b) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (this.d != null) {
                throw this.d;
            }
            if (this.c != null) {
                throw this.c;
            }
            return this.e;
        }
    }

    private static class CachedListener {
        private String d;
        private PLCListener c;
        private Object b;

        public CachedListener(String string, PLCListener pLCListener, Object object) {
            this.d = string;
            this.c = pLCListener;
            this.b = object;
        }

        public void addToTransport(PLCTransport pLCTransport) throws IOException, PLCException {
            pLCTransport.addListener(this.d, this.c, this.b);
        }

        public void removeFromTransport(PLCTransport pLCTransport) throws IOException, PLCException {
            pLCTransport.removeListener(this.d, this.c);
        }

        public int hashCode() {
            return this.d.hashCode() + System.identityHashCode(this.c);
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedListener)) {
                return false;
            }
            CachedListener cachedListener = (CachedListener)object;
            return this.d.equals(cachedListener.d) && this.c == cachedListener.c;
        }
    }
}

