/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCInboundMessageListener;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCMessageConvention;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigItemException;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.ListOfOne;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SimpleMessageConvention
implements PLCMessageConvention {
    private String c = null;
    private PLCTransport d = null;
    private static Logger b = Logger.getLogger(SimpleMessageConvention.class.getName());

    public void initialize(String string, PLCTransport pLCTransport, RawConfig rawConfig) throws ConfigValidationException {
        this.c = string;
        this.d = pLCTransport;
    }

    public PLCTransport getTransport() {
        return this.d;
    }

    public PLCOutboundMessage createOutboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("sendItem");
        validatedConfig.addStringItem("sendValue");
        validatedConfig.readFrom(rawConfig);
        return new OutboundMessage(validatedConfig.getStringValue("sendItem"), Short.valueOf(validatedConfig.getStringValue("sendValue")));
    }

    public PLCInboundMessage createInboundMessage(String string, RawConfig rawConfig) throws ConfigValidationException {
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("receiveItem");
        validatedConfig.addStringItem("initialValue", null);
        validatedConfig.addListItem("matchValues", null);
        validatedConfig.addListItem("noMatchValues", null);
        validatedConfig.readFrom(rawConfig);
        if (validatedConfig.isValid("matchValues") && validatedConfig.isValid("noMatchValues")) {
            ConfigValidationException configValidationException = new ConfigValidationException();
            configValidationException.add(new ConfigItemException(I18N.get("Only one of matchValues and noMatchValues can be specified.")));
            throw configValidationException;
        }
        return new InboundMessage(string, validatedConfig.getStringValue("receiveItem"), validatedConfig.isValid("initialValue") ? Short.valueOf(validatedConfig.getStringValue("sendValue")) : null, validatedConfig.isValid("matchValues") ? validatedConfig.getListValue("matchValues") : null, validatedConfig.isValid("noMatchValues") ? validatedConfig.getListValue("noMatchValues") : null);
    }

    public boolean isAlive() {
        return this.getTransport().isAlive();
    }

    private class InboundMessage
    implements PLCInboundMessage,
    PLCListener {
        private String eb = null;
        private String hb = null;
        private Short db = null;
        private String[] gb = null;
        private String[] ib = null;
        private Set fb = Collections.synchronizedSet(new HashSet());

        public InboundMessage(String string, String string2, Short s, String[] stringArray, String[] stringArray2) {
            this.eb = string;
            this.hb = string2;
            this.db = s;
            this.gb = stringArray;
            this.ib = stringArray2;
        }

        public PLCMessageConvention getMessageConvention() {
            return SimpleMessageConvention.this;
        }

        public synchronized void addListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            boolean bl = this.fb.isEmpty();
            this.fb.add(pLCInboundMessageListener);
            if (bl) {
                SimpleMessageConvention.this.d.addListener(this.hb, this, this.db);
            }
        }

        public synchronized void removeListener(PLCInboundMessageListener pLCInboundMessageListener) throws PLCException, IOException {
            this.fb.remove(pLCInboundMessageListener);
            if (this.fb.isEmpty()) {
                SimpleMessageConvention.this.d.removeListener(this.hb, this);
            }
        }

        public void removeAllListeners() throws PLCException, IOException {
            this.fb.clear();
            SimpleMessageConvention.this.d.removeListener(this.hb, this);
        }

        public List getExtraItems() {
            return null;
        }

        public void itemChanged(String string, Object object, List list) {
            if (this.c(object)) {
                Iterator iterator = this.fb.iterator();
                while (iterator.hasNext()) {
                    ((PLCInboundMessageListener)iterator.next()).receiveMessage(this.eb, new ListOfOne(object));
                }
            }
        }

        private boolean c(Object object) {
            boolean bl;
            block2: {
                String string;
                block3: {
                    bl = true;
                    string = object.toString();
                    if (this.gb == null) break block3;
                    bl = false;
                    for (int i = 0; i < this.gb.length; ++i) {
                        if (!this.gb[i].equals(string)) continue;
                        bl = true;
                        break block2;
                    }
                    break block2;
                }
                if (this.ib == null) break block2;
                for (int i = 0; i < this.ib.length; ++i) {
                    if (!this.ib[i].equals(string)) continue;
                    bl = false;
                    break;
                }
            }
            return bl;
        }
    }

    private class OutboundMessage
    implements PLCOutboundMessage {
        private String d = null;
        private Short c = null;

        public OutboundMessage(String string, Short s) {
            this.d = string;
            this.c = s;
        }

        public PLCMessageConvention getMessageConvention() {
            return SimpleMessageConvention.this;
        }

        public void invoke(List list) throws PLCException, IOException {
            SimpleMessageConvention.this.d.write(new ListOfOne(this.d), new ListOfOne(this.c));
        }
    }
}

