/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util.event;

import com.connecterra.i18n.I18N;
import com.connecterra.util.CircularArrayList;
import com.connecterra.util.Queue;
import com.connecterra.util.event.EventProcessor;
import com.connecterra.util.event.QueueFullException;
import com.connecterra.util.event.Scheduler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EventReceiver {
    private static final String j = "com.connecterra.resources.EventReceiver";
    private static Logger k = Logger.getLogger("com.connecterra.resources.EventReceiver");
    private Queue i = new CircularArrayList();
    private DeliveryTask c = new DeliveryTask();
    private String e;
    private EventProcessor b;
    private Scheduler d;
    private int g;
    private boolean f;
    private int h;
    public static final int ALWAYS_QUEUE = 1;
    public static final int DROP = 2;
    public static final int THROW = 3;
    public static final int BLOCK = 4;

    public EventReceiver(String string, EventProcessor eventProcessor, Scheduler scheduler, int n) {
        if (scheduler == null) {
            throw new IllegalArgumentException(I18N.get("scheduler must be non-null"));
        }
        if (n < -1) {
            throw new IllegalArgumentException(I18N.get("eventLimit must be greater than or equal to -1"));
        }
        this.g = n == 0 ? -1 : n;
        this.e = string;
        this.b = eventProcessor;
        this.d = scheduler;
        this.f = true;
        if (this.g < 0) {
            k.fine("No limit specified for " + this);
        }
        this.h = this.g * 9 / 10;
        if (this.h > this.g - 2) {
            this.h = this.g > 2 ? this.g - 2 : 0;
        }
    }

    public EventProcessor getEventProcessor() {
        return this.b;
    }

    public void receiveEvent(Object object) {
        try {
            this.b(object, 1);
        }
        catch (QueueFullException queueFullException) {
            throw new RuntimeException(queueFullException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public boolean receiveEventOrDrop(Object object) {
        try {
            return this.b(object, 2);
        }
        catch (QueueFullException queueFullException) {
            throw new RuntimeException(queueFullException);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void receiveEventOrThrow(Object object) throws QueueFullException {
        try {
            this.b(object, 3);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public void receiveEventOrBlock(Object object) throws InterruptedException {
        try {
            this.b(object, 4);
        }
        catch (QueueFullException queueFullException) {
            throw new RuntimeException(queueFullException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean b(Object object, int n) throws QueueFullException, InterruptedException {
        boolean bl;
        Queue queue = this.i;
        synchronized (queue) {
            bl = this.i.isEmpty();
            if (this.g > 0 && this.i.size() >= this.g) {
                if (this.f) {
                    k.warning(I18N.get("system is too busy to process {0}; performance will be degraded", this.e));
                    this.f = false;
                }
                if (n != 1) {
                    if (n == 2) {
                        return false;
                    }
                    if (n == 3) {
                        throw new QueueFullException(I18N.get("resource limit reached trying to insert new event"));
                    }
                    if (n == 4) {
                        if (k.isLoggable(Level.FINE)) {
                            k.fine("Waiting for space in " + this);
                        }
                        while (this.i.size() >= this.g) {
                            this.i.wait();
                        }
                    } else {
                        throw new IllegalArgumentException(I18N.get("invalid limitPolicy argument"));
                    }
                }
            }
            this.i.addLast(object);
        }
        if (k.isLoggable(Level.FINEST)) {
            k.finest("Event receiver " + this + " received " + object);
        }
        if (k.isLoggable(Level.FINE)) {
            this.c();
        }
        if (bl) {
            this.d.addOneShot(this.c);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        String string;
        int n;
        int n2;
        Queue queue = this.i;
        synchronized (queue) {
            n2 = this.i.size();
        }
        if (this.g > 0) {
            n = this.g;
            if (n == 0) {
                n = 1;
            }
            string = "% capacity of maximum queue size " + n;
        } else {
            n = 100;
            string = " events, no maximum";
        }
        k.finest(this + " queue size is " + n2);
        if (n2 == n / 10) {
            k.fine(this + " at 10" + string);
        } else if (n2 == n / 5) {
            k.fine(this + " at 20" + string);
        } else if (n2 == n / 2) {
            k.fine(this + " at 50" + string);
        } else if (n2 > 0 && n2 % n == 0) {
            int n3 = n2 / n;
            k.fine(this + " at " + n3 + "00" + string);
        }
    }

    public String toString() {
        return "EventReceiver:" + this.e;
    }

    private class DeliveryTask
    implements Runnable {
        private DeliveryTask() {
        }

        public void run() {
            if (k.isLoggable(Level.FINEST)) {
                k.finest("Event receiver " + EventReceiver.this + " starting delivery");
            }
            Object object = this.b();
            while (object != null) {
                if (k.isLoggable(Level.FINEST)) {
                    k.finest("Event receiver " + EventReceiver.this + " delivering " + object);
                }
                try {
                    EventReceiver.this.b.handleEvent(object);
                }
                catch (Throwable throwable) {
                    k.log(Level.WARNING, I18N.get("An unexpected error condition occurred: {0}", throwable.getLocalizedMessage()), throwable);
                }
                object = this.c();
                if (!Thread.interrupted()) continue;
                if (object == null) break;
                EventReceiver.this.d.addOneShot(EventReceiver.this.c);
                break;
            }
            if (k.isLoggable(Level.FINEST)) {
                k.finer("Event receiver " + EventReceiver.this + " finished delivery");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object b() {
            Queue queue = EventReceiver.this.i;
            synchronized (queue) {
                if (EventReceiver.this.i.isEmpty()) {
                    return null;
                }
                return EventReceiver.this.i.getFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object c() {
            Queue queue = EventReceiver.this.i;
            synchronized (queue) {
                EventReceiver.this.i.removeFirst();
                if (EventReceiver.this.i.size() < EventReceiver.this.g) {
                    if (k.isLoggable(Level.FINE)) {
                        EventReceiver.this.c();
                    }
                    if (!EventReceiver.this.f && EventReceiver.this.i.size() <= EventReceiver.this.h) {
                        EventReceiver.this.f = true;
                        k.warning(I18N.get("performance is no longer degraded for {0}", EventReceiver.this.e));
                    }
                    EventReceiver.this.i.notify();
                }
                return this.b();
            }
        }
    }
}

