/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util.event;

import com.connecterra.i18n.I18N;
import com.connecterra.util.CircularArrayList;
import com.connecterra.util.Controllable;
import com.connecterra.util.Queue;
import com.connecterra.util.event.Scheduler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreadPoolScheduler
implements Scheduler,
Controllable {
    private static final String g = "com.connecterra.resources.ThreadPoolScheduler";
    private static Logger j = Logger.getLogger("com.connecterra.resources.ThreadPoolScheduler");
    private String c;
    private Queue h = new CircularArrayList();
    private int b = 0;
    private volatile ActiveCounter d = null;
    private Set k = new HashSet();
    private int e = -1;
    private int f = 0;
    private List i = new ArrayList();
    private long l = 60000L;

    public ThreadPoolScheduler(int n, String string) {
        this(string);
        this.setThreadCount(n);
    }

    public ThreadPoolScheduler(String string) {
        this.c = string != null ? string : super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThreadCount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(I18N.get("Thread count must be positive."));
        }
        Queue queue = this.h;
        synchronized (queue) {
            this.e = n;
        }
    }

    private void c() {
        String string = this.c + "-" + this.f;
        ++this.f;
        ThreadPoolThread threadPoolThread = new ThreadPoolThread(string);
        this.i.add(threadPoolThread);
        threadPoolThread.start();
        j.log(Level.FINE, "New thread " + threadPoolThread + " started");
    }

    public void addOneShot(Runnable runnable) {
        this.b(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecurring(Runnable runnable) {
        Set set = this.k;
        synchronized (set) {
            this.k.add(runnable);
        }
        this.b(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecurring(Runnable runnable) {
        Set set = this.k;
        synchronized (set) {
            this.k.remove(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(Runnable runnable) {
        Queue queue = this.h;
        synchronized (queue) {
            if (this.e < 0) {
                throw new IllegalStateException("Event queued on " + this + " before count set");
            }
            this.h.addLast(runnable);
            if (this.b >= this.i.size() && (this.e == 0 || this.i.size() < this.e)) {
                this.c();
            }
            this.h.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Queue queue = this.h;
        synchronized (queue) {
            this.k.clear();
            this.h.clear();
        }
    }

    public void shutdown() {
    }

    public void waitForShutdown(long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Queue queue = this.h;
        synchronized (queue) {
            Iterator iterator = this.i.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTermination(long l) throws InterruptedException {
        ArrayList arrayList;
        Queue queue = this.h;
        synchronized (queue) {
            arrayList = new ArrayList(this.i);
        }
        long l2 = System.currentTimeMillis() + l;
        long l3 = l2 - System.currentTimeMillis();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && l3 > 0L) {
            ((Thread)iterator.next()).join(l3);
            l3 = l2 - System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveCounter(ActiveCounter activeCounter) {
        this.d = activeCounter;
        Queue queue = this.h;
        synchronized (queue) {
            if (this.b > 0) {
                this.d.increment();
            }
            j.log(Level.FINER, "Setting ActiveCounter on " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActiveCounter() {
        Queue queue = this.h;
        synchronized (queue) {
            if (this.b > 0) {
                this.d.decrement();
            }
        }
        this.d = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForAllIdle(ThreadPoolScheduler[] threadPoolSchedulerArray, long l) throws InterruptedException {
        int n;
        ActiveCounter activeCounter = new ActiveCounter();
        for (n = 0; n < threadPoolSchedulerArray.length; ++n) {
            if (threadPoolSchedulerArray[n] == null) continue;
            threadPoolSchedulerArray[n].setActiveCounter(activeCounter);
        }
        try {
            activeCounter.waitForAllIdle(l);
        }
        finally {
            for (n = 0; n < threadPoolSchedulerArray.length; ++n) {
                if (threadPoolSchedulerArray[n] == null) continue;
                threadPoolSchedulerArray[n].clearActiveCounter();
            }
        }
    }

    public String toString() {
        return this.c + "(busyThreads=" + this.b + ")";
    }

    private class ThreadPoolThread
    extends Thread {
        private boolean c;

        public ThreadPoolThread(String string) {
            super(Thread.currentThread().getThreadGroup(), string);
            this.c = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.b();
            }
            finally {
                Queue queue = ThreadPoolScheduler.this.h;
                synchronized (queue) {
                    ThreadPoolScheduler.this.i.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void b() {
            Object object = ThreadPoolScheduler.this.h;
            synchronized (object) {
                if (ThreadPoolScheduler.this.d != null) {
                    ThreadPoolScheduler.this.d.increment();
                }
                ThreadPoolScheduler.this.b++;
            }
            while (true) {
                boolean bl;
                Queue queue = ThreadPoolScheduler.this.h;
                synchronized (queue) {
                    if (ThreadPoolScheduler.this.h.isEmpty()) {
                        ThreadPoolScheduler.this.b--;
                        if (ThreadPoolScheduler.this.b == 0 && ThreadPoolScheduler.this.d != null) {
                            ThreadPoolScheduler.this.d.decrement();
                        }
                        long l = System.currentTimeMillis() + ThreadPoolScheduler.this.l;
                        while (ThreadPoolScheduler.this.h.isEmpty()) {
                            try {
                                long l2 = l - System.currentTimeMillis();
                                if (l2 <= 0L) {
                                    j.log(Level.FINE, "Thread " + this + " is idle, exiting");
                                    return;
                                }
                                ThreadPoolScheduler.this.h.wait(l2);
                            }
                            catch (InterruptedException interruptedException) {
                                return;
                            }
                        }
                        object = (Runnable)ThreadPoolScheduler.this.h.removeFirst();
                        if (ThreadPoolScheduler.this.b == 0 && ThreadPoolScheduler.this.d != null) {
                            ThreadPoolScheduler.this.d.increment();
                        }
                        ThreadPoolScheduler.this.b++;
                    } else {
                        object = (Runnable)ThreadPoolScheduler.this.h.removeFirst();
                    }
                }
                try {
                    object.run();
                }
                catch (Throwable throwable) {
                    j.log(Level.WARNING, I18N.get("An unexpected error condition occurred: {0}", throwable.getLocalizedMessage()), throwable);
                }
                if (this.c) {
                    return;
                }
                Set set = ThreadPoolScheduler.this.k;
                synchronized (set) {
                    bl = ThreadPoolScheduler.this.k.contains(object);
                }
                if (!bl) continue;
                ThreadPoolScheduler.this.b((Runnable)object);
            }
        }
    }

    private static class ActiveCounter {
        private volatile int b = 0;

        public void increment() {
            ++this.b;
            j.log(Level.FINER, "++ActiveCounter == " + this.b);
        }

        public synchronized void decrement() {
            --this.b;
            j.log(Level.FINER, "--ActiveCounter == " + this.b);
            if (this.b == 0) {
                this.notifyAll();
            }
        }

        public synchronized void waitForAllIdle(long l) throws InterruptedException {
            long l2 = System.currentTimeMillis() + l;
            long l3 = l2 - System.currentTimeMillis();
            while (this.b > 0 && l3 > 0L) {
                this.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
        }
    }
}

