/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util.plugin;

import com.connecterra.util.ConfigItem;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.StringConfigItem;
import com.connecterra.util.ValidatedConfig;
import com.connecterra.util.plugin.Plugin;
import com.connecterra.util.plugin.PluginInitializationException;
import com.connecterra.util.plugin.PluginLoadException;

public abstract class PluginLoader {
    public void load(RawConfig rawConfig, String string, Class clazz) {
        ValidatedConfig validatedConfig = new ValidatedConfig();
        StringConfigItem stringConfigItem = new StringConfigItem();
        validatedConfig.addItem("class", (ConfigItem)stringConfigItem, null);
        boolean bl = false;
        for (String string2 : rawConfig.getInstanceNames(string)) {
            RawConfig rawConfig2 = rawConfig.getInstance(string, string2);
            validatedConfig.reset();
            try {
                validatedConfig.readFrom(rawConfig2);
            }
            catch (ConfigValidationException configValidationException) {
                this.pluginFailed(string2, "instance configuration was invalid", configValidationException);
                continue;
            }
            if (!stringConfigItem.isValid()) continue;
            try {
                Plugin plugin = this.loadSingle(string2, rawConfig2, stringConfigItem.stringValue(), clazz);
                this.pluginSucceeded(string2, plugin);
            }
            catch (PluginLoadException pluginLoadException) {
                this.pluginFailed(string2, pluginLoadException.getMessage(), pluginLoadException);
            }
            catch (ConfigValidationException configValidationException) {
                this.pluginFailed(string2, configValidationException.getMessage(), configValidationException);
            }
            catch (PluginInitializationException pluginInitializationException) {
                this.pluginFailed(string2, pluginInitializationException.getMessage(), pluginInitializationException);
            }
        }
    }

    public Plugin loadSingle(String string, RawConfig rawConfig, String string2, Class clazz) throws PluginLoadException, ConfigValidationException, PluginInitializationException {
        if (!Plugin.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " does not implement Plugin");
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PluginLoadException(string2 + " could not be found", classNotFoundException);
        }
        catch (LinkageError linkageError) {
            throw new PluginLoadException(string2 + " could not be loaded or initialized", linkageError);
        }
        if (!clazz.isAssignableFrom(clazz2)) {
            throw new PluginLoadException("Class " + string2 + " is not assignable to " + clazz.getName(), new ClassCastException(""));
        }
        Object var6_8 = null;
        try {
            var6_8 = clazz2.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PluginLoadException(string2 + " is not accessible", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new PluginLoadException(string2 + " could not be instantiated", instantiationException);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throw new PluginLoadException(string2 + " caused initializer failure", exceptionInInitializerError);
        }
        catch (SecurityException securityException) {
            throw new PluginLoadException("Permission denied instantiating " + string2, securityException);
        }
        catch (RuntimeException runtimeException) {
            throw new PluginLoadException("Internal error instantiating " + string2, runtimeException);
        }
        try {
            Plugin plugin = var6_8;
            plugin.initialize(this, string, rawConfig);
            return plugin;
        }
        catch (RuntimeException runtimeException) {
            throw new PluginLoadException(string2 + " internal error: " + runtimeException.getLocalizedMessage(), runtimeException);
        }
    }

    protected abstract void pluginSucceeded(String var1, Plugin var2);

    protected abstract void pluginFailed(String var1, String var2, Throwable var3);
}

