/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.client;

import com.connecterra.ale.api.ALE;
import com.connecterra.ale.api.ALEFactory;
import com.connecterra.ale.api.DuplicateNameException;
import com.connecterra.ale.api.ECReports;
import com.connecterra.ale.api.ECSpec;
import com.connecterra.ale.api.ECSpecInfo;
import com.connecterra.ale.api.ECSpecValidationException;
import com.connecterra.ale.api.ECSubscriptionControls;
import com.connecterra.ale.api.ECSubscriptionInfo;
import com.connecterra.ale.api.EngineException;
import com.connecterra.ale.api.NoSuchSubscriberException;
import com.connecterra.ale.axis.AxisALEFactory;
import com.connecterra.ale.axis.adapters.ECReportsAdapter;
import com.connecterra.ale.axis.adapters.ECSpecAdapter;
import com.connecterra.ale.axis.adapters.ECSpecInfoAdapter;
import com.connecterra.ale.axis.adapters.ECSubscriptionControlsAdapter;
import com.connecterra.ale.axis.adapters.ECSubscriptionInfoAdapter;
import com.connecterra.ale.axis.schema.EventCycleReports;
import com.connecterra.ale.axis.schema.EventCycleSpec;
import com.connecterra.ale.axis.schema.EventCycleSpecInfo;
import com.connecterra.ale.axis.schema.EventCycleSubscriptionInfo;
import com.connecterra.ale.axis.service.ALEServiceBindingStub;
import com.connecterra.ale.axis.service.ALEServiceLocator;
import com.connecterra.ale.axis.service.ALEServicePortType;
import com.connecterra.ale.axis.service.ArrayOfString;
import com.connecterra.ale.axis.service.Define;
import com.connecterra.ale.axis.service.EmptyParms;
import com.connecterra.ale.axis.service.Get;
import com.connecterra.ale.axis.service.GetECSpecInfo;
import com.connecterra.ale.axis.service.GetECSubscriptionInfo;
import com.connecterra.ale.axis.service.Immediate;
import com.connecterra.ale.axis.service.InvalidURIException;
import com.connecterra.ale.axis.service.ListSubscribers;
import com.connecterra.ale.axis.service.NoSuchNameException;
import com.connecterra.ale.axis.service.Poll;
import com.connecterra.ale.axis.service.Redefine;
import com.connecterra.ale.axis.service.Subscribe;
import com.connecterra.ale.axis.service.SubscribeWithControls;
import com.connecterra.ale.axis.service.Suspend;
import com.connecterra.ale.axis.service.Undefine;
import com.connecterra.ale.axis.service.Unsubscribe;
import com.connecterra.ale.axis.service.Unsuspend;
import com.connecterra.i18n.I18N;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.rpc.ServiceException;

public class AxisALEClient
implements ALE {
    private static Logger c = Logger.getLogger("com.connecterra.ale.client.AxisALEClient");
    private ALEServicePortType b;

    public AxisALEClient(URL uRL) throws RemoteException {
        if (uRL == null) {
            throw new IllegalArgumentException(I18N.get("Specified ALE Service URL is null"));
        }
        Logger logger = Logger.getLogger("org.apache.axis");
        logger.setLevel(Level.OFF);
        c.fine("Instantiating locator");
        ALEServiceLocator aLEServiceLocator = new ALEServiceLocator();
        c.fine("Connecting to ALEService at " + uRL + "...");
        try {
            this.b = aLEServiceLocator.getALEService(uRL);
        }
        catch (ServiceException serviceException) {
            throw new RemoteException(serviceException.getMessage(), serviceException);
        }
        this.setTimeout(600000L);
        c.fine("Connection established to ALEService.");
    }

    public void setTimeout(long l) {
        ((ALEServiceBindingStub)this.b).setTimeout((int)l);
    }

    public long getTimeout() {
        return ((ALEServiceBindingStub)this.b).getTimeout();
    }

    public static ALEFactory staticGetALEFactory() {
        return AxisALEFactory.getInstance();
    }

    public ALEFactory getALEFactory() {
        return AxisALEClient.staticGetALEFactory();
    }

    public String getALEID() throws RemoteException, EngineException {
        try {
            c.fine("Invoking ALEService.getALEID...");
            return this.b.getALEID(new EmptyParms()).getALEID();
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void define(String string, ECSpec eCSpec) throws DuplicateNameException, ECSpecValidationException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Define define = new Define();
        define.setSpecName(string);
        define.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        try {
            c.fine("Invoking ALEService.define...");
            this.b.define(define);
            c.fine("Returned from ALEService.define.");
        }
        catch (com.connecterra.ale.axis.service.DuplicateNameException duplicateNameException) {
            throw new DuplicateNameException(duplicateNameException.getReason(), duplicateNameException);
        }
        catch (com.connecterra.ale.axis.service.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void redefine(String string, ECSpec eCSpec) throws com.connecterra.ale.api.NoSuchNameException, ECSpecValidationException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Redefine redefine = new Redefine();
        redefine.setSpecName(string);
        redefine.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        try {
            c.fine("Invoking ALEService.redefine...");
            this.b.redefine(redefine);
            c.fine("Returned from ALEService.redefine.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void suspend(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Suspend suspend = new Suspend();
        suspend.setSpecName(string);
        try {
            c.fine("Invoking ALEService.suspend...");
            this.b.suspend(suspend);
            c.fine("Returned from ALEService.suspend.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void unsuspend(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Unsuspend unsuspend = new Unsuspend();
        unsuspend.setSpecName(string);
        try {
            c.fine("Invoking ALEService.unsuspend...");
            this.b.unsuspend(unsuspend);
            c.fine("Returned from ALEService.unsuspend.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void undefine(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Undefine undefine = new Undefine();
        undefine.setSpecName(string);
        try {
            c.fine("Invoking ALEService.undefine...");
            this.b.undefine(undefine);
            c.fine("Returned from ALEService.undefine.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public ECSpec getECSpec(String string) throws RemoteException, EngineException {
        return this.get(string);
    }

    public ECSpec get(String string) throws RemoteException, EngineException {
        EventCycleSpec eventCycleSpec;
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Get get = new Get();
        get.setSpecName(string);
        try {
            c.fine("Invoking ALEService.get...");
            eventCycleSpec = this.b.get(get);
            c.fine("Returned from ALEService.get.");
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (eventCycleSpec == null) {
            return null;
        }
        try {
            return new ECSpecAdapter(eventCycleSpec);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public List getECSpecNames() throws RemoteException, EngineException {
        return this.listECSpecNames();
    }

    public List listECSpecNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            c.fine("Calling ALEService.listECSpecNames...");
            arrayOfString = this.b.listECSpecNames(new EmptyParms());
            c.fine("Returned from ALEService.listECSpecNames.");
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return AxisALEClient.c(arrayOfString);
    }

    public void subscribe(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Subscribe subscribe = new Subscribe();
        subscribe.setSpecName(string);
        subscribe.setNotificationURI(uRI.toString());
        try {
            c.fine("Invoking ALEService.subscribe...");
            this.b.subscribe(subscribe);
            c.fine("Returned from ALEService.subscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void subscribe(String string, URI uRI, ECSubscriptionControls eCSubscriptionControls) throws com.connecterra.ale.api.NoSuchNameException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        if (eCSubscriptionControls == null) {
            throw new IllegalArgumentException(I18N.get("Specified controls are null."));
        }
        SubscribeWithControls subscribeWithControls = new SubscribeWithControls();
        subscribeWithControls.setSpecName(string);
        subscribeWithControls.setNotificationURI(uRI.toString());
        subscribeWithControls.setControls(ECSubscriptionControlsAdapter.aleToAxis(eCSubscriptionControls));
        try {
            c.fine("Invoking ALEService.subscribe...");
            this.b.subscribeWithControls(subscribeWithControls);
            c.fine("Returned from ALEService.subscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public void unsubscribe(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, NoSuchSubscriberException, com.connecterra.ale.api.InvalidURIException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified URI is null."));
        }
        Unsubscribe unsubscribe = new Unsubscribe();
        unsubscribe.setSpecName(string);
        unsubscribe.setNotificationURI(uRI.toString());
        try {
            c.fine("Invoking ALEService.unsubscribe...");
            this.b.unsubscribe(unsubscribe);
            c.fine("Returned from ALEService.unsubscribe.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
    }

    public List getSubscribers(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        return this.listSubscribers(string);
    }

    public List listSubscribers(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        ListSubscribers listSubscribers = new ListSubscribers();
        listSubscribers.setSpecName(string);
        ArrayOfString arrayOfString = null;
        try {
            c.fine("Calling ALEService.listSubscribers...");
            arrayOfString = this.b.listSubscribers(listSubscribers);
            c.fine("Returned from ALEService.listSubscribers.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        try {
            return AxisALEClient.b(arrayOfString);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public ECSpecInfo getECSpecInfo(String string) throws com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        GetECSpecInfo getECSpecInfo = new GetECSpecInfo();
        getECSpecInfo.setSpecName(string);
        EventCycleSpecInfo eventCycleSpecInfo = null;
        try {
            c.fine("Invoking ALEService.getECSpecInfo...");
            eventCycleSpecInfo = this.b.getECSpecInfo(getECSpecInfo);
            c.fine("Returned from ALEService.getECSpecInfo.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (eventCycleSpecInfo == null) {
            return null;
        }
        return new ECSpecInfoAdapter(eventCycleSpecInfo);
    }

    public ECSubscriptionInfo getECSubscriptionInfo(String string, URI uRI) throws com.connecterra.ale.api.NoSuchNameException, NoSuchSubscriberException, RemoteException, com.connecterra.ale.api.InvalidURIException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        if (uRI == null) {
            throw new IllegalArgumentException(I18N.get("Specified subscriber URI is null."));
        }
        GetECSubscriptionInfo getECSubscriptionInfo = new GetECSubscriptionInfo();
        getECSubscriptionInfo.setSpecName(string);
        getECSubscriptionInfo.setSubscriber(uRI.toString());
        EventCycleSubscriptionInfo eventCycleSubscriptionInfo = null;
        try {
            c.fine("Invoking ALEService.getECSubscriptionInfo...");
            eventCycleSubscriptionInfo = this.b.getECSubscriptionInfo(getECSubscriptionInfo);
            c.fine("Returned from ALEService.getECSubscriptionInfo.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.NoSuchSubscriberException noSuchSubscriberException) {
            throw new NoSuchSubscriberException(noSuchSubscriberException.getReason(), noSuchSubscriberException);
        }
        catch (InvalidURIException invalidURIException) {
            throw new com.connecterra.ale.api.InvalidURIException(invalidURIException.getReason(), invalidURIException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (eventCycleSubscriptionInfo == null) {
            return null;
        }
        return new ECSubscriptionInfoAdapter(eventCycleSubscriptionInfo);
    }

    public ECReports poll(String string) throws InterruptedException, com.connecterra.ale.api.NoSuchNameException, RemoteException, EngineException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec name is null."));
        }
        Poll poll = new Poll();
        poll.setSpecName(string);
        EventCycleReports eventCycleReports = null;
        try {
            c.fine("Invoking ALEService.poll...");
            eventCycleReports = this.b.poll(poll);
            c.fine("Returned from ALEService.poll.");
        }
        catch (NoSuchNameException noSuchNameException) {
            throw new com.connecterra.ale.api.NoSuchNameException(noSuchNameException.getReason(), noSuchNameException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (eventCycleReports == null) {
            return null;
        }
        try {
            return new ECReportsAdapter(eventCycleReports);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public ECReports immediate(ECSpec eCSpec) throws InterruptedException, ECSpecValidationException, RemoteException, EngineException {
        if (eCSpec == null) {
            throw new IllegalArgumentException(I18N.get("Specified ECSpec is null."));
        }
        Immediate immediate = new Immediate();
        immediate.setSpec(ECSpecAdapter.aleToAxis(eCSpec));
        EventCycleReports eventCycleReports = null;
        try {
            c.fine("Invoking ALEService.immediate...");
            eventCycleReports = this.b.immediate(immediate);
            c.fine("Returned from ALEService.immediate.");
        }
        catch (com.connecterra.ale.axis.service.ECSpecValidationException eCSpecValidationException) {
            throw new ECSpecValidationException(eCSpecValidationException.getReason(), eCSpecValidationException);
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        if (eventCycleReports == null) {
            return null;
        }
        try {
            return new ECReportsAdapter(eventCycleReports);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RemoteException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public List listLogicalReaderNames() throws RemoteException, EngineException {
        ArrayOfString arrayOfString;
        try {
            c.fine("Calling ALEService.listLogicalReaderNames...");
            arrayOfString = this.b.listLogicalReaderNames(new EmptyParms());
            c.fine("Returned from ALEService.listLogicalReaderNames.");
        }
        catch (com.connecterra.ale.axis.service.EngineException engineException) {
            throw new EngineException(engineException.getReason(), engineException);
        }
        return AxisALEClient.c(arrayOfString);
    }

    private static List c(ArrayOfString arrayOfString) {
        if (arrayOfString == null) {
            return Collections.EMPTY_LIST;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(stringArray);
    }

    private static List b(ArrayOfString arrayOfString) throws URISyntaxException {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (arrayOfString == null) {
            return arrayList;
        }
        String[] stringArray = arrayOfString.getString();
        if (stringArray == null) {
            return arrayList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            arrayList.add(new URI(string));
        }
        return arrayList;
    }

    public String getStandardVersion() {
        throw new UnsupportedOperationException();
    }

    public String getVendorVersion() {
        throw new UnsupportedOperationException();
    }
}

