/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.dynamicconfig.bean;

import com.connecterra.ale.dynamicconfig.api.PluginConfigParameter;
import com.connecterra.ale.dynamicconfig.bean.PluginParameterConstraint;
import com.connecterra.i18n.I18N;

public class PluginParameterConstraintRangeNumeric
extends PluginParameterConstraint
implements com.connecterra.ale.dynamicconfig.api.PluginParameterConstraintRangeNumeric {
    private long c = Long.MIN_VALUE;
    private long d = Long.MAX_VALUE;

    public long getMaxValue() {
        return this.d;
    }

    public void setMaxValue(long l) {
        this.d = l;
    }

    public long getMinValue() {
        return this.c;
    }

    public void setMinValue(long l) {
        this.c = l;
    }

    public void validate(StringBuffer stringBuffer, PluginConfigParameter pluginConfigParameter) {
        String string = pluginConfigParameter.getValue();
        if (string == null) {
            stringBuffer.append(I18N.get("Null value specified for parameter \"{0}\" \n.", pluginConfigParameter.getKeyName()));
        } else {
            try {
                long l = Long.parseLong(string);
                if (l > this.getMaxValue()) {
                    stringBuffer.append(I18N.get("Parameter \"{0}\" with value {1} is greater than maximum allowed value of {2}. \n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue(), (Object)String.valueOf(this.getMaxValue())));
                } else if (l < this.getMinValue()) {
                    stringBuffer.append(I18N.get("Parameter \"{0}\" with value {1} is less than minimum allowed value of {2}. \n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue(), (Object)String.valueOf(this.getMinValue())));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (pluginConfigParameter.getValue().indexOf(".") >= 0) {
                    stringBuffer.append(I18N.get("Parameter \"{0}\" is not a whole number: {1}\n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue()));
                }
                stringBuffer.append(I18N.get("Parameter \"{0}\" has invalid value: {1}\n", (Object)pluginConfigParameter.getKeyName(), (Object)pluginConfigParameter.getValue()));
            }
        }
    }

    protected void dump(StringBuffer stringBuffer, String string) {
        super.dump(stringBuffer, string);
        stringBuffer.append(string + "min value: " + this.getMinValue() + "\n");
        stringBuffer.append(string + "max value: " + this.getMaxValue() + "\n");
    }
}

