/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.dynamicconfig.bean;

import com.connecterra.ale.dynamicconfig.bean.PluginConfigParameter;
import com.connecterra.ale.dynamicconfig.bean.PluginParameterMeta;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class PluginParameterMetaListManager {
    private final List b = new ArrayList();

    PluginParameterMetaListManager() {
    }

    public List getParameterMetaList() {
        return Collections.unmodifiableList(this.b);
    }

    public void setParameterMetaList(List list) {
        PluginParameterMetaListManager.validateList(list, PluginParameterMeta.class, false);
        this.b.clear();
        if (list != null) {
            this.b.addAll(list);
        }
    }

    public void addParameterMeta(com.connecterra.ale.dynamicconfig.api.PluginParameterMeta pluginParameterMeta) {
        if (pluginParameterMeta != null) {
            if (!(pluginParameterMeta instanceof PluginParameterMeta)) {
                throw new IllegalArgumentException(I18N.get("Invalid child Parameter, expecting \"{0}\" but found \"{1}\".", PluginParameterMeta.class, pluginParameterMeta.getClass()));
            }
            this.b.add(pluginParameterMeta);
        }
    }

    public com.connecterra.ale.dynamicconfig.api.PluginParameterMeta getParameterMeta(String string) {
        PluginParameterMeta pluginParameterMeta = null;
        Iterator iterator = this.getParameterMetaList().iterator();
        while (pluginParameterMeta == null && iterator.hasNext()) {
            pluginParameterMeta = (PluginParameterMeta)iterator.next();
            if (pluginParameterMeta.getName().equals(string)) continue;
            boolean bl = false;
            Iterator iterator2 = pluginParameterMeta.getAliasNameList().iterator();
            while (!bl && iterator.hasNext()) {
                bl = ((String)iterator2.next()).equals(string);
            }
            if (bl) continue;
            pluginParameterMeta = null;
        }
        return pluginParameterMeta;
    }

    protected static void validateList(List list, Class clazz, boolean bl) {
        if (list == null) {
            if (bl) {
                throw new IllegalArgumentException(I18N.get("null parameter list"));
            }
        } else {
            for (Object e : list) {
                if (clazz.isInstance(e)) continue;
                throw new IllegalArgumentException(I18N.get("invalid type in list, expecting {0} but found {1}", clazz.getClass(), e.getClass()));
            }
        }
    }

    protected void validateChildParameters(StringBuffer stringBuffer, List list) {
        if (list != null) {
            ArrayList arrayList = new ArrayList(list);
            for (Object object : this.getParameterMetaList()) {
                String string = ((PluginParameterMeta)object).getKeyName();
                String string2 = ((PluginParameterMeta)object).getName();
                PluginConfigParameter pluginConfigParameter = this.extractFromList(string, ((PluginParameterMeta)object).getAliasNameList(), arrayList);
                if (pluginConfigParameter == null) {
                    if (!((PluginParameterMeta)object).isRequired()) continue;
                    stringBuffer.append(I18N.get("Missing required parameter \"{0}\".\n", string2));
                    continue;
                }
                ((PluginParameterMeta)object).validate(stringBuffer, pluginConfigParameter);
            }
            for (Object object : arrayList) {
                stringBuffer.append(I18N.get("Unrecognized parameter \"{0}\" with value \"{1}\".\n", (Object)((PluginConfigParameter)object).getKeyName(), (Object)((PluginConfigParameter)object).getValue()));
            }
        }
    }

    protected PluginConfigParameter extractFromList(String string, List list, List list2) {
        PluginConfigParameter pluginConfigParameter = null;
        for (int i = 0; i < list2.size() && pluginConfigParameter == null; ++i) {
            String string2 = ((PluginConfigParameter)list2.get(i)).getKeyName();
            if (string.equals(string2)) {
                pluginConfigParameter = (PluginConfigParameter)list2.get(i);
                list2.remove(i);
                continue;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && pluginConfigParameter == null) {
                String string3 = (String)iterator.next();
                if (!string3.equals(string2)) continue;
                pluginConfigParameter = (PluginConfigParameter)list2.get(i);
                list2.remove(i);
            }
        }
        return pluginConfigParameter;
    }

    protected void dump(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string + "  child parameter meta list size: " + this.getParameterMetaList().size() + "\n");
        for (Object e : this.getParameterMetaList()) {
            try {
                ((PluginParameterMeta)e).dump(stringBuffer, string + "    ");
            }
            catch (ClassCastException classCastException) {
                stringBuffer.append(string + "invalid element found in plugin parameter meta list: " + e + "\n");
            }
        }
    }
}

