/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.i18n.I18N;
import java.util.List;

public class EPCBinaryEncoder {
    private final Scheme d;
    private final int c;
    private final List b;

    public EPCBinaryEncoder(Scheme scheme, int n, List list) {
        this.c = n;
        this.d = scheme;
        this.b = list;
    }

    public int getHeader() {
        return this.c;
    }

    public Scheme getScheme() {
        return this.d;
    }

    public EPC decode(long[] lArray) throws EPCException {
        EPC ePC = null;
        if (lArray == null || lArray.length != 2) {
            throw new EPCException(I18N.get("Invalid long array"));
        }
        EPCImpl ePCImpl = new EPCImpl(this.d);
        for (EPCBinaryFieldEncoder ePCBinaryFieldEncoder : this.b) {
            ePCBinaryFieldEncoder.decode(ePCImpl, lArray);
        }
        ePC = this.d.createEPC(ePCImpl);
        ePC.setLongArray(lArray);
        return ePC;
    }

    public long[] encode(EPC ePC) throws EPCException {
        long[] lArray = new long[]{0L, 0L};
        EPCImpl ePCImpl = ePC.getEPCImpl();
        for (EPCBinaryFieldEncoder ePCBinaryFieldEncoder : this.b) {
            ePCBinaryFieldEncoder.encode(ePCImpl, lArray);
        }
        return lArray;
    }
}

