/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.GS1Scheme;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.i18n.I18N;

public class EPCFieldEncoder96bitCompanyPrefixCompliment
extends EPCFieldEncoderNumeric {
    private final GS1Scheme k;
    private final int j;
    private final PartitionTable l;

    public EPCFieldEncoder96bitCompanyPrefixCompliment(GS1Scheme gS1Scheme, int n, int n2, int n3, PartitionTable partitionTable) {
        super(n, n3, 10);
        this.k = gS1Scheme;
        this.j = n2;
        this.l = partitionTable;
    }

    public void setComplimentSize(EPCImpl ePCImpl, EPCFieldNumeric ePCFieldNumeric) throws EPCException {
        int n;
        EPCField ePCField = ePCImpl.getField(this.j);
        String string = ((EPCFieldString)ePCField).getValue();
        if (string == null) {
            String string2 = I18N.get("{0} must be set to a wild card if Company Prefix is a wild card", this.getFieldName(ePCImpl));
            throw new EPCException(string2);
        }
        int n2 = string.length();
        int n3 = -1;
        for (n = 0; n3 < 0 && n < this.l.getRows(); ++n) {
            if (this.l.getCompanyPrefixDigits(n) != n2) continue;
            n3 = n;
        }
        if (n3 < 0) {
            throw new EPCException(I18N.get("Company Prefix {0} has a non valid length of {1}", (Object)this.getFieldName(ePCImpl), n2));
        }
        n = this.l.getComplimentDigits(n3);
        ePCFieldNumeric.setSize(n);
    }

    public String encode(EPCImpl ePCImpl, EPCField ePCField) throws EPCFieldEncodingException, EPCException {
        this.setComplimentSize(ePCImpl, (EPCFieldNumeric)ePCField);
        return super.encode(ePCImpl, ePCField);
    }

    public void decode(EPCImpl ePCImpl, EPCField ePCField, String string) throws EPCFieldDecodingException, EPCException {
        this.setComplimentSize(ePCImpl, (EPCFieldNumeric)ePCField);
        super.decode(ePCImpl, ePCField, string);
    }
}

