/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncodingException;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.i18n.I18N;

public class EPCFieldEncoderString
extends EPCFieldEncoder {
    private int e;
    private int d;

    public EPCFieldEncoderString(int n, int n2, int n3, int n4) {
        super(n, n2);
        this.e = n3;
        this.d = n4;
    }

    private void c(int n) {
        this.e = n;
    }

    public int getMinLength() {
        return this.e;
    }

    private void b(int n) {
        this.d = n;
    }

    public int getMaxLength() {
        return this.d;
    }

    public String encode(EPCImpl ePCImpl, EPCField ePCField) throws EPCFieldEncodingException {
        String string = "";
        if (ePCField instanceof EPCFieldString) {
            string = ((EPCFieldString)ePCField).getValue();
        } else if (ePCField instanceof EPCFieldNumeric) {
            string = Long.toString(((EPCFieldNumeric)ePCField).getValue());
        } else {
            throw new EPCFieldEncodingException(I18N.get("unknown type"));
        }
        if (string.length() < this.getMinLength()) {
            String string2 = I18N.get("Field length of {0} is less than minimum allowed: {1}", string.length(), this.getMinLength());
            throw new EPCFieldEncodingException(string2);
        }
        if (string.length() > this.getMaxLength()) {
            String string3 = I18N.get("Field length of {0} is greater than maximum allowed: {1}", string.length(), this.getMaxLength());
            throw new EPCFieldEncodingException(string3);
        }
        return string;
    }

    public void decode(EPCImpl ePCImpl, EPCField ePCField, String string) throws EPCFieldDecodingException, EPCException {
        if (ePCField instanceof EPCFieldString) {
            ((EPCFieldString)ePCField).setValue(string);
        } else if (ePCField instanceof EPCFieldNumeric) {
            try {
                long l = Long.parseLong(string);
                ((EPCFieldNumeric)ePCField).setValue(l);
            }
            catch (NumberFormatException numberFormatException) {
                throw new EPCFieldDecodingException(I18N.get("unable to convert {0} to a number, {1} ", (Object)string, (Object)numberFormatException.getMessage()));
            }
        } else {
            throw new EPCFieldDecodingException(I18N.get("Non string descriptor field"));
        }
    }
}

