/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCDecodeException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.SGTINIDPattern;
import com.connecterra.ale.epc.SSCCIDPattern;
import com.connecterra.i18n.I18N;
import java.net.URI;

public abstract class EPCIDPattern {
    public static final String URN_ID_PAT = "urn:epc:idpat";
    public static final String SGTIN = "sgtin";
    public static final String SSCC = "sscc";
    public static final String SGLN = "sgln";
    public static final String GRAI = "grai";
    public static final String GIAI = "giai";
    public static final String DOD = "usdod";
    private EPCPattern b;

    protected EPCIDPattern(EPCPattern ePCPattern) {
        this.b = ePCPattern;
    }

    protected EPCPattern getEPCPattern() {
        return this.b;
    }

    public abstract EPCPattern getEPCPattern(int var1, int var2);

    public abstract String getTypeString();

    public boolean isDomainManagerStar() {
        return this.b.isDomainManagerStar();
    }

    public final boolean hasDomainManager() {
        return this.b.hasDomainManager();
    }

    public final boolean hasObjectClass() {
        return this.b.hasObjectClass();
    }

    public boolean isObjectClassStar() {
        return this.b.isObjectClassStar();
    }

    public final boolean hasSerialNumber() {
        return this.b.hasSerialNumber();
    }

    public boolean isSerialNumberStar() {
        return this.b.isSerialNumberStar();
    }

    public final long getDomainManagerMin() {
        return this.b.getDomainManagerMin();
    }

    public final long getDomainManagerMax() {
        return this.b.getDomainManagerMax();
    }

    public final int getDomainManagerLength() {
        return this.b.getDomainManagerLength();
    }

    public final long getObjectClassMin() {
        return this.b.getObjectClassMin();
    }

    public final long getObjectClassMax() {
        return this.b.getObjectClassMax();
    }

    public final int getObjectClassLength() {
        return this.b.getObjectClassLength();
    }

    public final long getSerialNumberMin() {
        return this.b.getSerialNumberMin();
    }

    public final long getSerialNumberMax() {
        return this.b.getSerialNumberMax();
    }

    public final URI getURI() {
        URI uRI = null;
        try {
            uRI = this.b.getPureIdentityPatternURI();
        }
        catch (EPCException ePCException) {
            // empty catch block
        }
        return uRI;
    }

    public static EPCIDPattern createInstance(String string) throws EPCDecodeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.get("Null uri"));
        }
        if (!string.startsWith("urn:epc:idpat:")) {
            throw new EPCDecodeException(I18N.get("{0} non valid {1} syntax (does not start with {2})", (Object)string, (Object)URN_ID_PAT, (Object)URN_ID_PAT));
        }
        String string2 = string.substring(URN_ID_PAT.length() + 1);
        int n = string2.indexOf(":");
        if (n == -1) {
            throw new EPCDecodeException(I18N.get("{0} non valid {1} syntax (no pattern value provided)", (Object)string, (Object)URN_ID_PAT));
        }
        String string3 = string2.substring(0, n);
        string2 = string2.substring(n + 1);
        EPCPattern ePCPattern = EPCPattern.createInstance(string);
        if (string3.equals(SGTIN)) {
            return new SGTINIDPattern(ePCPattern);
        }
        if (string3.equals(SSCC)) {
            return new SSCCIDPattern(ePCPattern);
        }
        throw new EPCDecodeException(I18N.get("Unsupported EPCIDPattern type: {0}", string3));
    }

    public String toString() {
        return "[EPCIDPattern " + this.getURI() + "]";
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof EPCIDPattern) {
            return this.getURI().equals(((EPCIDPattern)object).getURI());
        }
        return false;
    }
}

