/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldConstraint;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.i18n.I18N;

public class EPCPatternFieldNumeric
extends EPCPatternField {
    private final EPCFieldNumeric i;
    private final EPCFieldNumeric j;

    public EPCPatternFieldNumeric(EPCFieldDescriptor ePCFieldDescriptor) throws EPCPatternException {
        super(ePCFieldDescriptor);
        this.i = new EPCFieldNumeric(ePCFieldDescriptor);
        this.j = new EPCFieldNumeric(ePCFieldDescriptor);
        EPCFieldConstraint ePCFieldConstraint = ePCFieldDescriptor.getEPCFieldConstraint();
        long l = 0L;
        long l2 = 0L;
        if (ePCFieldConstraint instanceof EPCFieldConstraintPoint) {
            l = l2 = ((EPCFieldConstraintPoint)ePCFieldConstraint).getPointValue();
        } else if (ePCFieldConstraint instanceof EPCFieldConstraintMinMax) {
            l = ((EPCFieldConstraintMinMax)ePCFieldConstraint).getMinimumValue();
            l2 = ((EPCFieldConstraintMinMax)ePCFieldConstraint).getMaximumValue();
        }
        if (l > l2) {
            String string = Long.toString(l);
            String string2 = Long.toString(l2);
            throw new EPCPatternException(I18N.get("min value {0} must be less than or equal to max value {1} for a range", (Object)string, (Object)string2));
        }
        this.i.setValue(l);
        this.j.setValue(l2);
    }

    public EPCField getEPCField() {
        return this.i;
    }

    protected EPCFieldNumeric getEPCFieldNumericMin() {
        return this.i;
    }

    protected EPCFieldNumeric getEPCFieldNumericMax() {
        return this.j;
    }

    public void setValue(long l) {
        this.i.setValue(l);
        this.j.setValue(l);
        this.setPoint();
    }

    public long getValue() throws EPCPatternException {
        if (!this.isPoint()) {
            throw new EPCPatternException(I18N.get("field does not have a point value"));
        }
        return this.i.getValue();
    }

    public void setRange(long l, long l2) throws EPCPatternException {
        if (l > l2) {
            String string = Long.toString(l);
            String string2 = Long.toString(l2);
            throw new EPCPatternException(I18N.get("min value {0} must be less than or equal to max value {1} for a range", (Object)string, (Object)string2));
        }
        this.i.setValue(l);
        this.j.setValue(l2);
        if (l == l2) {
            this.setPoint();
        } else {
            this.setRange();
        }
    }

    public long getMin() throws EPCPatternException {
        if (!this.isPoint() && !this.isRange()) {
            throw new EPCPatternException(I18N.get("field does not have a point or range value"));
        }
        return this.i.getValue();
    }

    public long getMax() throws EPCPatternException {
        if (!this.isPoint() && !this.isRange()) {
            throw new EPCPatternException(I18N.get("field does not have a point or range value"));
        }
        return this.j.getValue();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EPCPatternFieldNumeric) {
            EPCPatternFieldNumeric ePCPatternFieldNumeric = (EPCPatternFieldNumeric)object;
            try {
                boolean bl2 = bl = this.isPoint() && ePCPatternFieldNumeric.isPoint() || this.isStar() && ePCPatternFieldNumeric.isStar() || this.isRange() && ePCPatternFieldNumeric.isRange() || this.isX() && ePCPatternFieldNumeric.isX();
                if (bl && (this.isPoint() || this.isRange())) {
                    bl = this.getMin() == ePCPatternFieldNumeric.getMin() && this.getMax() == ePCPatternFieldNumeric.getMax();
                }
            }
            catch (EPCPatternException ePCPatternException) {
                bl = false;
            }
        }
        return bl;
    }

    public void assign(EPCField ePCField) throws EPCPatternException {
        try {
            EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCField;
            this.setValue(ePCFieldNumeric.getValue());
        }
        catch (ClassCastException classCastException) {
            throw new EPCPatternException(I18N.get("field type does not match {0}", classCastException.getLocalizedMessage()), classCastException);
        }
    }

    public void assign(EPCPatternField ePCPatternField) throws EPCPatternException {
        EPCPatternFieldNumeric ePCPatternFieldNumeric;
        try {
            ePCPatternFieldNumeric = (EPCPatternFieldNumeric)ePCPatternField;
        }
        catch (ClassCastException classCastException) {
            throw new EPCPatternException(I18N.get("patternField type does not match {0}", classCastException.getMessage()), classCastException);
        }
        if (ePCPatternFieldNumeric.isPoint()) {
            this.setValue(ePCPatternFieldNumeric.getValue());
        } else if (ePCPatternFieldNumeric.isRange()) {
            this.setRange(ePCPatternFieldNumeric.getMin(), ePCPatternFieldNumeric.getMax());
        } else if (ePCPatternFieldNumeric.isStar()) {
            this.setStar();
        } else if (ePCPatternFieldNumeric.isX()) {
            this.setX();
        } else {
            throw new EPCPatternException(I18N.get("EPCPattern field assignment error"));
        }
    }

    public boolean match(EPCField ePCField) throws EPCPatternException {
        boolean bl;
        boolean bl2 = bl = this.isStar() || this.isX();
        if (!bl) {
            if (!(ePCField.getEPCField() instanceof EPCFieldNumeric)) {
                throw new EPCPatternException(I18N.get("Non numeric EPC Pattern field"));
            }
            long l = ((EPCFieldNumeric)ePCField.getEPCField()).getValue();
            bl = l >= this.getMin() && l <= this.getMax();
        }
        return bl;
    }

    public boolean disjoint(EPCPatternField ePCPatternField) throws EPCPatternException {
        boolean bl;
        if (!(ePCPatternField instanceof EPCPatternFieldNumeric)) {
            throw new EPCPatternException(I18N.get("Non numeric EPC Pattern field"));
        }
        EPCPatternFieldNumeric ePCPatternFieldNumeric = (EPCPatternFieldNumeric)ePCPatternField;
        boolean bl2 = bl = !this.isStar() && !ePCPatternFieldNumeric.isStar() && !this.isX() && !ePCPatternFieldNumeric.isX();
        if (bl) {
            long l = this.getMin();
            long l2 = this.getMax();
            long l3 = ePCPatternFieldNumeric.getMin();
            long l4 = ePCPatternFieldNumeric.getMax();
            bl = l2 < l3 || l > l4;
        }
        return bl;
    }

    public long getEPCCount() {
        long l = this.j.getValue() - this.i.getValue() + 1L;
        return l;
    }

    public String toString() {
        String string = null;
        try {
            if (this.isStar()) {
                string = "*";
            } else if (this.isX()) {
                string = "X";
            } else if (this.isPoint()) {
                string = String.valueOf(this.getValue());
            } else if (this.isRange()) {
                string = "[" + this.getMin() + "-" + this.getMax() + "]";
            }
        }
        catch (EPCPatternException ePCPatternException) {
            // empty catch block
        }
        return string;
    }
}

