/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternField;
import com.connecterra.i18n.I18N;

public class EPCPatternFieldString
extends EPCPatternField {
    private final EPCFieldString h;

    public EPCPatternFieldString(EPCFieldDescriptor ePCFieldDescriptor) {
        super(ePCFieldDescriptor);
        this.h = new EPCFieldString(ePCFieldDescriptor);
    }

    protected EPCField getEPCField() {
        return this.h;
    }

    public void setValue(String string) {
        this.h.setValue(string);
        this.setPoint();
    }

    public String getValue() {
        return this.h.getValue();
    }

    public void assign(EPCField ePCField) throws EPCPatternException {
        try {
            EPCFieldString ePCFieldString = (EPCFieldString)ePCField;
            this.setValue(ePCFieldString.getValue());
        }
        catch (ClassCastException classCastException) {
            throw new EPCPatternException(I18N.get("field type does not match {0}", classCastException.getLocalizedMessage()), classCastException);
        }
    }

    public void assign(EPCPatternField ePCPatternField) throws EPCPatternException {
        EPCPatternFieldString ePCPatternFieldString;
        try {
            ePCPatternFieldString = (EPCPatternFieldString)ePCPatternField;
        }
        catch (ClassCastException classCastException) {
            throw new EPCPatternException(I18N.get("patternField type does not match {0}", classCastException.getLocalizedMessage()), classCastException);
        }
        if (ePCPatternFieldString.isPoint()) {
            this.setValue(ePCPatternFieldString.getValue());
        } else {
            if (ePCPatternFieldString.isRange()) {
                throw new EPCPatternException(I18N.get("String type not allowed to have range value"));
            }
            if (ePCPatternFieldString.isStar()) {
                this.setStar();
            } else if (ePCPatternFieldString.isX()) {
                this.setX();
            } else {
                throw new EPCPatternException(I18N.get("EPCPattern field assignment error"));
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof EPCPatternFieldString) {
            EPCPatternFieldString ePCPatternFieldString = (EPCPatternFieldString)object;
            boolean bl2 = bl = this.isPoint() && ePCPatternFieldString.isPoint() || this.isStar() && ePCPatternFieldString.isStar() || this.isRange() && ePCPatternFieldString.isRange() || this.isX() && ePCPatternFieldString.isX();
            if (bl && this.isPoint()) {
                bl = this.getValue().equals(ePCPatternFieldString.getValue());
            }
        }
        return bl;
    }

    public boolean match(EPCField ePCField) throws EPCPatternException {
        boolean bl;
        boolean bl2 = bl = this.isStar() || this.isX();
        if (!bl) {
            if (!(ePCField.getEPCField() instanceof EPCFieldString)) {
                throw new EPCPatternException(I18N.get("Non String EPC Pattern field"));
            }
            String string = ((EPCFieldString)ePCField.getEPCField()).getValue();
            bl = string.equals(this.getValue());
        }
        return bl;
    }

    public boolean disjoint(EPCPatternField ePCPatternField) throws EPCPatternException {
        boolean bl;
        if (!(ePCPatternField instanceof EPCPatternFieldString)) {
            throw new EPCPatternException(I18N.get("Non String EPC Pattern field"));
        }
        EPCPatternFieldString ePCPatternFieldString = (EPCPatternFieldString)ePCPatternField;
        boolean bl2 = bl = !this.isStar() && !ePCPatternFieldString.isStar() && !this.isX() && !ePCPatternFieldString.isX();
        if (bl) {
            bl = !this.equals(ePCPatternFieldString);
        }
        return bl;
    }

    public boolean equals(EPCPatternFieldString ePCPatternFieldString) {
        boolean bl;
        boolean bl2 = bl = this.isStar() && ePCPatternFieldString.isStar();
        if (!bl) {
            boolean bl3 = bl = this.isX() && ePCPatternFieldString.isX();
        }
        if (!bl) {
            String string = this.getValue();
            String string2 = ePCPatternFieldString.getValue();
            bl = string.equals(string2);
        }
        return bl;
    }

    public long getEPCCount() {
        return 1L;
    }

    public String toString() {
        String string = null;
        if (this.isStar()) {
            string = "*";
        } else if (this.isX()) {
            string = "X";
        } else if (this.isPoint()) {
            string = this.getValue();
        }
        return string;
    }
}

