/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.MixedPatternTypeException;
import com.connecterra.ale.epc.NonEnumerablePatternException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class EPCPatternList {
    private LinkedList b = new LinkedList();

    public EPCPatternList() {
    }

    public EPCPatternList(EPCPattern ePCPattern) throws NonEnumerablePatternException {
        if (!ePCPattern.canEnumerateEPCs()) {
            throw new NonEnumerablePatternException(ePCPattern.toString());
        }
        this.b.add((EPCPattern)ePCPattern.clone());
    }

    public EPCPatternList(List list) throws NonEnumerablePatternException, MixedPatternTypeException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addLast((EPCPattern)iterator.next());
        }
    }

    public void clear() {
        this.b.clear();
    }

    public void addFirst(EPCPattern ePCPattern) throws NonEnumerablePatternException, MixedPatternTypeException {
        this.d(ePCPattern);
        this.b.addFirst((EPCPattern)ePCPattern.clone());
        EPCPatternList.b(this.b.listIterator());
    }

    public void addLast(EPCPattern ePCPattern) throws NonEnumerablePatternException, MixedPatternTypeException {
        this.d(ePCPattern);
        this.b.addLast((EPCPattern)ePCPattern.clone());
        EPCPatternList.b(this.b.listIterator(this.b.size() - 1));
    }

    public final void add(EPCPattern ePCPattern) throws NonEnumerablePatternException, MixedPatternTypeException {
        this.addLast(ePCPattern);
    }

    public void addFirst(List list) throws NonEnumerablePatternException, MixedPatternTypeException {
        if (list == null) {
            return;
        }
        this.b(list);
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            this.addFirst((EPCPattern)listIterator.previous());
        }
    }

    public void addLast(List list) throws NonEnumerablePatternException, MixedPatternTypeException {
        if (list == null) {
            return;
        }
        this.b(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addLast((EPCPattern)iterator.next());
        }
    }

    public final void add(List list) throws NonEnumerablePatternException, MixedPatternTypeException {
        this.addLast(list);
    }

    public void addFirst(EPCPatternList ePCPatternList, boolean bl) throws MixedPatternTypeException {
        if (ePCPatternList == null) {
            return;
        }
        List list = ePCPatternList.getPatterns();
        if (list.size() == 0) {
            return;
        }
        this.c((EPCPattern)list.get(0));
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            this.b((EPCPattern)listIterator.previous(), bl);
        }
    }

    public void addFirst(EPC ePC, boolean bl) throws MixedPatternTypeException {
        EPCPattern ePCPattern = EPCPattern.createInstance(ePC);
        this.c(ePCPattern);
        this.b(ePCPattern, bl);
    }

    private void b(EPCPattern ePCPattern, boolean bl) {
        if (!bl) {
            this.b.addFirst(ePCPattern);
            EPCPatternList.b(this.b.listIterator());
        } else {
            ListIterator listIterator = this.b.listIterator();
            while (listIterator.hasNext()) {
                EPCPattern ePCPattern2 = (EPCPattern)listIterator.next();
                if (!EPCPatternList.b(ePCPattern, ePCPattern2) && !EPCPatternList.b(ePCPattern2, ePCPattern)) continue;
                listIterator.previous();
                EPCPatternList.b(listIterator);
                return;
            }
            this.b.addFirst(ePCPattern);
        }
    }

    public void addLast(EPCPatternList ePCPatternList, boolean bl) throws MixedPatternTypeException {
        if (ePCPatternList == null) {
            return;
        }
        List list = ePCPatternList.getPatterns();
        if (list.size() == 0) {
            return;
        }
        this.c((EPCPattern)list.get(0));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.c((EPCPattern)iterator.next(), bl);
        }
    }

    public final void add(EPCPatternList ePCPatternList, boolean bl) throws MixedPatternTypeException {
        this.addLast(ePCPatternList, bl);
    }

    public void addLast(EPC ePC, boolean bl) throws MixedPatternTypeException {
        EPCPattern ePCPattern = EPCPattern.createInstance(ePC);
        this.c(ePCPattern);
        this.c(ePCPattern, bl);
    }

    public final void add(EPC ePC, boolean bl) throws MixedPatternTypeException {
        this.addLast(ePC, bl);
    }

    private void c(EPCPattern ePCPattern, boolean bl) {
        if (!bl) {
            this.b.addLast(ePCPattern);
            EPCPatternList.b(this.b.listIterator(this.b.size() - 1));
        } else {
            ListIterator listIterator = this.b.listIterator(this.b.size());
            while (listIterator.hasPrevious()) {
                EPCPattern ePCPattern2 = (EPCPattern)listIterator.previous();
                if (!EPCPatternList.b(ePCPattern2, ePCPattern) && !EPCPatternList.b(ePCPattern, ePCPattern2)) continue;
                EPCPatternList.b(listIterator);
                return;
            }
            this.b.addLast(ePCPattern);
        }
    }

    public long getEPCCount() {
        long l = 0L;
        for (EPCPattern ePCPattern : this.b) {
            l += ePCPattern.getEPCCount();
        }
        return l;
    }

    public List getPatterns() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.b.size());
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((EPCPattern)iterator.next()).clone());
        }
        return arrayList;
    }

    public EPCPattern[] toArray() {
        EPCPattern[] ePCPatternArray = new EPCPattern[this.b.size()];
        Iterator iterator = this.b.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ePCPatternArray[n++] = (EPCPattern)((EPCPattern)iterator.next()).clone();
        }
        return ePCPatternArray;
    }

    public void remove(EPCPattern ePCPattern) {
        if (!ePCPattern.canEnumerateEPCs() || !this.b(ePCPattern)) {
            return;
        }
        ListIterator listIterator = this.b.listIterator();
        while (listIterator.hasNext()) {
            EPCPatternList.b(ePCPattern, listIterator);
        }
    }

    public void remove(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.remove((EPCPattern)iterator.next());
        }
    }

    public void remove(EPCPatternList ePCPatternList) {
        if (ePCPatternList == this) {
            this.clear();
        } else {
            this.remove(ePCPatternList.b);
        }
    }

    public void remove(EPC ePC) {
        this.remove(EPCPattern.createInstance(ePC));
    }

    public boolean contains(EPC ePC) {
        for (EPCPattern ePCPattern : this.b) {
            try {
                if (!ePCPattern.matches(ePC)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean containsAny(EPCPattern ePCPattern) throws NonEnumerablePatternException {
        for (EPCPattern ePCPattern2 : this.b) {
            if (!ePCPattern2.containsAny(ePCPattern)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(List list) throws NonEnumerablePatternException {
        for (EPCPattern ePCPattern : list) {
            if (!this.containsAny(ePCPattern)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(EPCPatternList ePCPatternList) {
        try {
            return this.containsAny(ePCPatternList.b);
        }
        catch (NonEnumerablePatternException nonEnumerablePatternException) {
            throw new RuntimeException(nonEnumerablePatternException);
        }
    }

    public EPC removeFirst() {
        if (this.b.size() == 0) {
            return null;
        }
        EPCPattern ePCPattern = null;
        EPCPattern ePCPattern2 = (EPCPattern)this.b.removeFirst();
        if (ePCPattern2.getEPCCount() == 1L) {
            ePCPattern = ePCPattern2;
        } else {
            List list = EPCPatternList.b(ePCPattern2, 1L);
            ePCPattern = (EPCPattern)list.get(0);
            for (int i = list.size() - 1; i >= 1; --i) {
                this.b.addFirst(list.get(i));
            }
        }
        if (ePCPattern.getEPCCount() != 1L) {
            throw new RuntimeException("Internal logic failure: " + ePCPattern.getEPCCount());
        }
        try {
            return ePCPattern.getFirstEPC();
        }
        catch (NonEnumerablePatternException nonEnumerablePatternException) {
            throw new RuntimeException(nonEnumerablePatternException);
        }
    }

    public EPC removeLast() {
        if (this.b.size() == 0) {
            return null;
        }
        EPCPattern ePCPattern = null;
        EPCPattern ePCPattern2 = (EPCPattern)this.b.removeLast();
        if (ePCPattern2.getEPCCount() == 1L) {
            ePCPattern = ePCPattern2;
        } else {
            List list = EPCPatternList.b(ePCPattern2, ePCPattern2.getEPCCount() - 1L);
            ePCPattern = (EPCPattern)list.get(list.size() - 1);
            for (int i = 0; i < list.size() - 1; ++i) {
                this.b.addLast(list.get(i));
            }
        }
        if (ePCPattern.getEPCCount() != 1L) {
            throw new RuntimeException("Internal logic failure: " + ePCPattern.getEPCCount());
        }
        try {
            return ePCPattern.getFirstEPC();
        }
        catch (NonEnumerablePatternException nonEnumerablePatternException) {
            throw new RuntimeException(nonEnumerablePatternException);
        }
    }

    public EPCPatternList removeFirst(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative chunkSize.");
        }
        EPCPatternList ePCPatternList = new EPCPatternList();
        if (this.b.size() == 0) {
            return ePCPatternList;
        }
        if (l >= this.getEPCCount()) {
            ePCPatternList.b = this.b;
            this.b = new LinkedList();
            return ePCPatternList;
        }
        while (l > 0L) {
            EPCPattern ePCPattern = (EPCPattern)this.b.removeFirst();
            if (ePCPattern.getEPCCount() <= l) {
                ePCPatternList.b.addLast(ePCPattern);
                l -= ePCPattern.getEPCCount();
                continue;
            }
            List list = EPCPatternList.b(ePCPattern, l);
            for (int i = list.size() - 1; i >= 0; --i) {
                this.b.addFirst(list.get(i));
            }
        }
        return ePCPatternList;
    }

    public EPCPatternList removeLast(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative chunkSize.");
        }
        EPCPatternList ePCPatternList = new EPCPatternList();
        if (this.b.size() == 0) {
            return ePCPatternList;
        }
        if (l >= this.getEPCCount()) {
            ePCPatternList.b = this.b;
            this.b = new LinkedList();
            return ePCPatternList;
        }
        while (l > 0L) {
            EPCPattern ePCPattern = (EPCPattern)this.b.removeLast();
            if (ePCPattern.getEPCCount() <= l) {
                ePCPatternList.b.addFirst(ePCPattern);
                l -= ePCPattern.getEPCCount();
                continue;
            }
            List list = EPCPatternList.b(ePCPattern, ePCPattern.getEPCCount() - l);
            for (int i = 0; i < list.size(); ++i) {
                this.b.addLast(list.get(i));
            }
        }
        return ePCPatternList;
    }

    static boolean b(EPCPattern ePCPattern, EPCPattern ePCPattern2) {
        if (!ePCPattern.getTypeString().equals(ePCPattern2.getTypeString())) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        if (ePCPattern.hasFilter()) {
            l = ePCPattern.getFilterMin();
            l2 = ePCPattern.getFilterMax();
            if (l != ePCPattern2.getFilterMin() || l2 != ePCPattern2.getFilterMax()) {
                if (ePCPattern.getFilterMax() + 1L == ePCPattern2.getFilterMin()) {
                    bl2 = true;
                    l2 = ePCPattern2.getFilterMax();
                } else {
                    return false;
                }
            }
            if (l != l2) {
                bl = true;
            }
        }
        if (ePCPattern.hasDomainManager()) {
            l3 = ePCPattern.getDomainManagerMin();
            l4 = ePCPattern.getDomainManagerMax();
            if (l3 != ePCPattern2.getDomainManagerMin() || l4 != ePCPattern2.getDomainManagerMax()) {
                if (bl2) {
                    return false;
                }
                if (ePCPattern.getDomainManagerMax() + 1L == ePCPattern2.getDomainManagerMin()) {
                    if (bl) {
                        return false;
                    }
                    bl2 = true;
                    l4 = ePCPattern2.getDomainManagerMax();
                } else {
                    return false;
                }
            }
            if (l3 != l4) {
                bl = true;
            }
        }
        if (ePCPattern.hasObjectClass()) {
            l5 = ePCPattern.getObjectClassMin();
            l6 = ePCPattern.getObjectClassMax();
            if (l5 != ePCPattern2.getObjectClassMin() || l6 != ePCPattern2.getObjectClassMax()) {
                if (bl2) {
                    return false;
                }
                if (ePCPattern.getObjectClassMax() + 1L == ePCPattern2.getObjectClassMin()) {
                    if (bl) {
                        return false;
                    }
                    bl2 = true;
                    l6 = ePCPattern2.getObjectClassMax();
                } else {
                    return false;
                }
            }
            if (l5 != l6) {
                bl = true;
            }
        }
        if (ePCPattern.hasSerialNumber()) {
            l7 = ePCPattern.getSerialNumberMin();
            l8 = ePCPattern.getSerialNumberMax();
            if (l7 != ePCPattern2.getSerialNumberMin() || l8 != ePCPattern2.getSerialNumberMax()) {
                if (bl2) {
                    return false;
                }
                if (ePCPattern.getSerialNumberMax() + 1L == ePCPattern2.getSerialNumberMin()) {
                    if (bl) {
                        return false;
                    }
                    bl2 = true;
                    l8 = ePCPattern2.getSerialNumberMax();
                } else {
                    return false;
                }
            }
        }
        if (!bl2) {
            return false;
        }
        if (ePCPattern.hasFilter()) {
            ePCPattern.setFilterRange(l, l2);
            ePCPattern2.setFilterRange(l, l2);
        }
        if (ePCPattern.hasDomainManager()) {
            ePCPattern.setDomainManagerRange(l3, l4);
            ePCPattern2.setDomainManagerRange(l3, l4);
        }
        if (ePCPattern.hasObjectClass()) {
            ePCPattern.setObjectClassRange(l5, l6);
            ePCPattern2.setObjectClassRange(l5, l6);
        }
        if (ePCPattern.hasSerialNumber()) {
            ePCPattern.setSerialNumberRange(l7, l8);
            ePCPattern2.setSerialNumberRange(l7, l8);
        }
        return true;
    }

    private static boolean b(ListIterator listIterator) {
        boolean bl;
        block3: {
            bl = false;
            EPCPattern ePCPattern = (EPCPattern)listIterator.next();
            while (true) {
                EPCPattern ePCPattern2;
                if (listIterator.hasNext()) {
                    ePCPattern2 = (EPCPattern)listIterator.next();
                    if (EPCPatternList.b(ePCPattern, ePCPattern2)) {
                        bl = true;
                        listIterator.remove();
                        continue;
                    }
                    listIterator.previous();
                }
                listIterator.previous();
                if (!listIterator.hasPrevious()) break block3;
                ePCPattern2 = (EPCPattern)listIterator.previous();
                if (!EPCPatternList.b(ePCPattern2, ePCPattern)) break;
                bl = true;
                listIterator.remove();
                listIterator.next();
            }
            listIterator.next();
        }
        return bl;
    }

    private static void b(EPCPattern ePCPattern, ListIterator listIterator) {
        ArrayList<EPCPattern> arrayList;
        block38: {
            if (!listIterator.hasNext()) {
                return;
            }
            EPCPattern ePCPattern2 = (EPCPattern)listIterator.next();
            try {
                ePCPattern = ePCPattern.intersectWith(ePCPattern2);
            }
            catch (NonEnumerablePatternException nonEnumerablePatternException) {
                throw new RuntimeException(nonEnumerablePatternException);
            }
            if (ePCPattern == null) {
                return;
            }
            listIterator.remove();
            if (ePCPattern.getEPCCount() == ePCPattern2.getEPCCount()) {
                return;
            }
            arrayList = new ArrayList<EPCPattern>();
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            if (ePCPattern2.hasFilter()) {
                l = ePCPattern2.getFilterMin();
            }
            if (ePCPattern2.hasDomainManager()) {
                l2 = ePCPattern2.getDomainManagerMin();
            }
            if (ePCPattern2.hasObjectClass()) {
                l3 = ePCPattern2.getObjectClassMin();
            }
            if (ePCPattern2.hasSerialNumber()) {
                l4 = ePCPattern2.getSerialNumberMin();
            }
            EPCPattern ePCPattern3 = (EPCPattern)ePCPattern2.clone();
            while (true) {
                EPCPatternList.b(l, l2, l3, l4, ePCPattern3);
                if (ePCPattern2.hasSerialNumber()) {
                    if (EPCPatternList.b(ePCPattern, l, l2, l3)) {
                        ePCPattern3.setSerialNumberRange(ePCPattern2.getSerialNumberMin(), ePCPattern2.getSerialNumberMax());
                        if (!(ePCPattern2.hasObjectClass() || ePCPattern2.hasDomainManager() || ePCPattern2.hasFilter())) {
                            arrayList.add(ePCPattern3);
                            break block38;
                        }
                    } else {
                        if (l4 == ePCPattern2.getSerialNumberMin()) {
                            if (ePCPattern2.getSerialNumberMin() < ePCPattern.getSerialNumberMin()) {
                                ePCPattern3.setSerialNumberRange(ePCPattern2.getSerialNumberMin(), ePCPattern.getSerialNumberMin() - 1L);
                                arrayList.add(ePCPattern3);
                                ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                            }
                            l4 = ePCPattern.getSerialNumberMax() + 1L;
                            continue;
                        }
                        if (l4 == ePCPattern.getSerialNumberMax() + 1L && ePCPattern.getSerialNumberMax() < ePCPattern2.getSerialNumberMax()) {
                            ePCPattern3.setSerialNumberRange(ePCPattern.getSerialNumberMax() + 1L, ePCPattern2.getSerialNumberMax());
                            arrayList.add(ePCPattern3);
                            ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                        }
                        l4 = ePCPattern2.getSerialNumberMin();
                        if (ePCPattern2.hasObjectClass()) {
                            if (++l3 <= ePCPattern2.getObjectClassMax()) continue;
                            l3 = ePCPattern2.getObjectClassMin();
                        }
                        if (ePCPattern2.hasDomainManager()) {
                            if (++l2 <= ePCPattern2.getDomainManagerMax()) continue;
                            l2 = ePCPattern2.getDomainManagerMin();
                        }
                        if (ePCPattern2.hasFilter() && ++l <= ePCPattern2.getFilterMax()) continue;
                        break block38;
                    }
                }
                if (ePCPattern2.hasObjectClass()) {
                    if (EPCPatternList.b(ePCPattern, l, l2)) {
                        ePCPattern3.setObjectClassRange(ePCPattern2.getObjectClassMin(), ePCPattern2.getObjectClassMax());
                        if (!ePCPattern2.hasDomainManager() && !ePCPattern2.hasFilter()) {
                            arrayList.add(ePCPattern3);
                            break block38;
                        }
                    } else {
                        if (l3 == ePCPattern2.getObjectClassMin()) {
                            if (ePCPattern2.getObjectClassMin() < ePCPattern.getObjectClassMin()) {
                                ePCPattern3.setObjectClassRange(ePCPattern2.getObjectClassMin(), ePCPattern.getObjectClassMin() - 1L);
                                arrayList.add(ePCPattern3);
                                ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                            }
                            l3 = ePCPattern.getObjectClassMin();
                            continue;
                        }
                        if (l3 == ePCPattern.getObjectClassMax() + 1L && ePCPattern.getObjectClassMax() < ePCPattern2.getObjectClassMax()) {
                            ePCPattern3.setObjectClassRange(ePCPattern.getObjectClassMax() + 1L, ePCPattern2.getObjectClassMax());
                            arrayList.add(ePCPattern3);
                            ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                        }
                        l3 = ePCPattern2.getObjectClassMin();
                        if (ePCPattern2.hasDomainManager()) {
                            if (++l2 <= ePCPattern2.getDomainManagerMax()) continue;
                            l2 = ePCPattern2.getDomainManagerMin();
                        }
                        if (ePCPattern2.hasFilter() && ++l <= ePCPattern2.getFilterMax()) continue;
                        break block38;
                    }
                }
                if (ePCPattern2.hasDomainManager()) {
                    if (EPCPatternList.c(ePCPattern, l)) {
                        ePCPattern3.setDomainManagerRange(ePCPattern2.getDomainManagerMin(), ePCPattern2.getDomainManagerMax());
                        if (!ePCPattern2.hasFilter()) {
                            arrayList.add(ePCPattern3);
                            break block38;
                        }
                    } else {
                        if (l2 == ePCPattern2.getDomainManagerMin()) {
                            if (ePCPattern2.getDomainManagerMin() < ePCPattern.getDomainManagerMin()) {
                                ePCPattern3.setDomainManagerRange(ePCPattern2.getDomainManagerMin(), ePCPattern.getDomainManagerMin() - 1L);
                                arrayList.add(ePCPattern3);
                                ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                            }
                            l2 = ePCPattern.getDomainManagerMin();
                            continue;
                        }
                        if (l2 == ePCPattern.getDomainManagerMax() + 1L && ePCPattern.getDomainManagerMax() < ePCPattern2.getDomainManagerMax()) {
                            ePCPattern3.setDomainManagerRange(ePCPattern.getDomainManagerMax() + 1L, ePCPattern2.getDomainManagerMax());
                            arrayList.add(ePCPattern3);
                            ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                        }
                        l2 = ePCPattern2.getDomainManagerMin();
                        if (ePCPattern2.hasFilter() && ++l <= ePCPattern2.getFilterMax()) continue;
                        break block38;
                    }
                }
                if (!ePCPattern2.hasFilter()) continue;
                if (l != ePCPattern2.getFilterMin()) break;
                if (ePCPattern2.getFilterMin() < ePCPattern.getFilterMin()) {
                    ePCPattern3.setFilterRange(ePCPattern2.getFilterMin(), ePCPattern.getFilterMin() - 1L);
                    arrayList.add(ePCPattern3);
                    ePCPattern3 = (EPCPattern)ePCPattern3.clone();
                }
                l = ePCPattern.getFilterMin();
            }
            if (l == ePCPattern.getFilterMax() + 1L && ePCPattern.getFilterMax() < ePCPattern2.getFilterMax()) {
                ePCPattern3.setFilterRange(ePCPattern.getFilterMax() + 1L, ePCPattern2.getFilterMax());
                arrayList.add(ePCPattern3);
                ePCPattern3 = (EPCPattern)ePCPattern3.clone();
            }
        }
        ListIterator listIterator2 = arrayList.listIterator();
        while (listIterator2.hasNext()) {
            EPCPatternList.b(listIterator2);
            listIterator2.next();
        }
        listIterator2 = arrayList.listIterator();
        while (listIterator2.hasNext()) {
            EPCPattern ePCPattern4 = (EPCPattern)listIterator2.next();
            listIterator.add(ePCPattern4);
        }
    }

    private static void b(long l, long l2, long l3, long l4, EPCPattern ePCPattern) {
        if (ePCPattern.hasFilter()) {
            ePCPattern.setFilterRange(l, l);
        }
        if (ePCPattern.hasDomainManager()) {
            ePCPattern.setDomainManagerRange(l2, l2);
        }
        if (ePCPattern.hasObjectClass()) {
            ePCPattern.setObjectClassRange(l3, l3);
        }
        if (ePCPattern.hasSerialNumber()) {
            ePCPattern.setSerialNumberRange(l4, l4);
        }
    }

    private static boolean b(EPCPattern ePCPattern, long l, long l2, long l3) {
        if (ePCPattern.hasFilter() && (l < ePCPattern.getFilterMin() || l > ePCPattern.getFilterMax())) {
            return true;
        }
        if (ePCPattern.hasDomainManager() && (l2 < ePCPattern.getDomainManagerMin() || l2 > ePCPattern.getDomainManagerMax())) {
            return true;
        }
        return ePCPattern.hasObjectClass() && (l3 < ePCPattern.getObjectClassMin() || l3 > ePCPattern.getObjectClassMax());
    }

    private static boolean b(EPCPattern ePCPattern, long l, long l2) {
        if (ePCPattern.hasFilter() && (l < ePCPattern.getFilterMin() || l > ePCPattern.getFilterMax())) {
            return true;
        }
        return ePCPattern.hasDomainManager() && (l2 < ePCPattern.getDomainManagerMin() || l2 > ePCPattern.getDomainManagerMax());
    }

    private static boolean c(EPCPattern ePCPattern, long l) {
        return ePCPattern.hasFilter() && (l < ePCPattern.getFilterMin() || l > ePCPattern.getFilterMax());
    }

    static List b(EPCPattern ePCPattern, long l) {
        long l2;
        long l3;
        long l4;
        if (l <= 0L) {
            throw new IllegalArgumentException("Non-positive fragPoint: " + l);
        }
        if (l >= ePCPattern.getEPCCount()) {
            throw new IllegalArgumentException("Excessive fragPoint: " + l);
        }
        ArrayList<EPCPattern> arrayList = new ArrayList<EPCPattern>();
        long l5 = ePCPattern.getEPCCount() - l;
        EPCPattern ePCPattern2 = (EPCPattern)ePCPattern.clone();
        if (ePCPattern.hasFilter() && l > 0L) {
            l4 = ePCPattern2.getFilterMin();
            ePCPattern2.setFilterRange(l4, l4);
            l3 = ePCPattern2.getEPCCount();
            int n = (int)(l / l3);
            if (n > 0) {
                long l6 = l4 + (long)n - 1L;
                ePCPattern2.setFilterRange(l4, l6);
                arrayList.add(ePCPattern2);
                if ((l -= ePCPattern2.getEPCCount()) > 0L) {
                    ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                    ePCPattern2.setFilterRange(l6 + 1L, l6 + 1L);
                }
            }
        }
        if (ePCPattern.hasDomainManager() && l > 0L) {
            l4 = ePCPattern2.getDomainManagerMin();
            ePCPattern2.setDomainManagerRange(l4, l4);
            l3 = ePCPattern2.getEPCCount();
            long l7 = l / l3;
            if (l7 > 0L) {
                l2 = l4 + l7 - 1L;
                ePCPattern2.setDomainManagerRange(l4, l2);
                arrayList.add(ePCPattern2);
                if ((l -= ePCPattern2.getEPCCount()) > 0L) {
                    ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                    ePCPattern2.setDomainManagerRange(l2 + 1L, l2 + 1L);
                }
            }
        }
        if (ePCPattern.hasObjectClass() && l > 0L) {
            l4 = ePCPattern2.getObjectClassMin();
            ePCPattern2.setObjectClassRange(l4, l4);
            l3 = ePCPattern2.getEPCCount();
            long l8 = l / l3;
            if (l8 > 0L) {
                l2 = l4 + l8 - 1L;
                ePCPattern2.setObjectClassRange(l4, l2);
                arrayList.add(ePCPattern2);
                if ((l -= ePCPattern2.getEPCCount()) > 0L) {
                    ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                    ePCPattern2.setObjectClassRange(l2 + 1L, l2 + 1L);
                }
            }
        }
        if (ePCPattern.hasSerialNumber() && l > 0L) {
            l4 = ePCPattern2.getSerialNumberMin();
            ePCPattern2.setSerialNumberRange(l4, l4);
            l3 = ePCPattern2.getEPCCount();
            long l9 = l / l3;
            if (l9 > 0L) {
                l2 = l4 + l9 - 1L;
                ePCPattern2.setSerialNumberRange(l4, l2);
                arrayList.add(ePCPattern2);
                l -= ePCPattern2.getEPCCount();
            }
        }
        if (l != 0L) {
            throw new RuntimeException("Logic error: fragpoint=" + l);
        }
        ePCPattern2 = (EPCPattern)ePCPattern2.clone();
        if (ePCPattern.hasSerialNumber()) {
            l4 = ePCPattern2.getSerialNumberMax();
            if (l4 != ePCPattern.getSerialNumberMax()) {
                ePCPattern2.setSerialNumberRange(l4 + 1L, ePCPattern.getSerialNumberMax());
                arrayList.add(ePCPattern2);
                l5 -= ePCPattern2.getEPCCount();
            }
            if (l5 > 0L) {
                ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                ePCPattern2.setSerialNumberRange(ePCPattern.getSerialNumberMin(), ePCPattern.getSerialNumberMax());
            }
        }
        if (ePCPattern.hasObjectClass() && l5 > 0L) {
            l4 = ePCPattern2.getObjectClassMax();
            if (l4 != ePCPattern.getObjectClassMax()) {
                ePCPattern2.setObjectClassRange(l4 + 1L, ePCPattern.getObjectClassMax());
                arrayList.add(ePCPattern2);
                l5 -= ePCPattern2.getEPCCount();
            }
            if (l5 > 0L) {
                ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                ePCPattern2.setObjectClassRange(ePCPattern.getObjectClassMin(), ePCPattern.getObjectClassMax());
            }
        }
        if (ePCPattern.hasDomainManager() && l5 > 0L) {
            l4 = ePCPattern2.getDomainManagerMax();
            if (l4 != ePCPattern.getDomainManagerMax()) {
                ePCPattern2.setDomainManagerRange(l4 + 1L, ePCPattern.getDomainManagerMax());
                arrayList.add(ePCPattern2);
                l5 -= ePCPattern2.getEPCCount();
            }
            if (l5 > 0L) {
                ePCPattern2 = (EPCPattern)ePCPattern2.clone();
                ePCPattern2.setDomainManagerRange(ePCPattern.getDomainManagerMin(), ePCPattern.getDomainManagerMax());
            }
        }
        if (ePCPattern.hasFilter() && l5 > 0L && (l4 = ePCPattern2.getFilterMax()) != ePCPattern.getFilterMax()) {
            ePCPattern2.setFilterRange(l4 + 1L, ePCPattern.getFilterMax());
            arrayList.add(ePCPattern2);
            l5 -= ePCPattern2.getEPCCount();
        }
        if (l5 != 0L) {
            throw new RuntimeException("Logic error: epcsAfterFragPoint=" + l5);
        }
        return arrayList;
    }

    private boolean b(EPCPattern ePCPattern) {
        return this.b.size() == 0 || this.b().equals(ePCPattern.getTypeString());
    }

    private String b() {
        return this.b.size() == 0 ? null : ((EPCPattern)this.b.get(0)).getTypeString();
    }

    private void b(List list) throws NonEnumerablePatternException, MixedPatternTypeException {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            this.d((EPCPattern)listIterator.next());
        }
    }

    private void d(EPCPattern ePCPattern) throws NonEnumerablePatternException, MixedPatternTypeException {
        if (!ePCPattern.canEnumerateEPCs()) {
            throw new NonEnumerablePatternException(ePCPattern.toString());
        }
        this.c(ePCPattern);
    }

    private void c(EPCPattern ePCPattern) throws MixedPatternTypeException {
        if (!this.b(ePCPattern)) {
            throw new MixedPatternTypeException("Cannot add " + ePCPattern.getTypeString() + " pattern to " + this.b() + " pattern list");
        }
    }
}

