/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCEncodingException;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldDecodingException;
import com.connecterra.ale.epc.NumberUtil;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.UnknownScheme;
import com.connecterra.i18n.I18N;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;

public class EPCRawEncoder
extends EPCEncoder {
    private final int f;
    private static final String g = "00000000000000000000";

    public EPCRawEncoder(Scheme scheme, String string, String string2, int n) {
        super(scheme, string, string2, Collections.EMPTY_LIST);
        this.f = n;
    }

    public EPC decode(URI uRI) throws EPCException, EPCFieldDecodingException {
        EPC ePC = null;
        int n = 0;
        String string = uRI.toASCIIString().substring(this.getPrefix().length());
        int n2 = string.indexOf(this.getDelimiter());
        String string2 = string.substring(0, n2);
        int n3 = Integer.parseInt(string2);
        String string3 = string.substring(n2 + 1);
        if (string3.startsWith("X") || string3.startsWith("x")) {
            n = 16;
            string3 = string3.substring(1);
        } else {
            n = 10;
        }
        if (string3.startsWith("-")) {
            throw new EPCFieldDecodingException(I18N.get("negative raw encoding not allowed: {0}", string3));
        }
        BigInteger bigInteger = new BigInteger(string3, n);
        long[] lArray = new long[]{0L, 0L};
        switch (n3) {
            case 64: {
                if (bigInteger.compareTo(NumberUtil.MAX_64) > 0) {
                    throw new EPCFieldDecodingException(I18N.get("64 bit hex value too large: {0}", string3));
                }
                lArray[0] = 0L;
                lArray[1] = NumberUtil.MASK_64.and(bigInteger).longValue();
                break;
            }
            case 96: {
                if (bigInteger.compareTo(NumberUtil.MAX_96) > 0) {
                    throw new EPCFieldDecodingException(I18N.get("96 bit hex value is greater than allowed value: {0}  \nvalue: {1} +  \nmax:  {2}", (Object)string3, (Object)bigInteger.toString(16), (Object)NumberUtil.MAX_96.toString(16)));
                }
                lArray[0] = NumberUtil.MASK_64.shiftRight(32).and(bigInteger.shiftRight(64)).longValue();
                lArray[1] = NumberUtil.MASK_64.and(bigInteger).longValue();
                break;
            }
            case 128: {
                if (bigInteger.compareTo(NumberUtil.MAX_128) > 0) {
                    throw new EPCFieldDecodingException(I18N.get("128 bit hex value is greater than allowed value: {0}  \nvalue: {1} +  \nmax:  {2}", (Object)string3, (Object)bigInteger.toString(16), (Object)NumberUtil.MAX_128.toString(16)));
                }
                lArray[0] = NumberUtil.MASK_64.and(bigInteger.shiftRight(64)).longValue();
                lArray[1] = NumberUtil.MASK_64.and(bigInteger).longValue();
                break;
            }
            default: {
                throw new EPCFieldDecodingException(I18N.get("unsuported bit size: {0}", n3));
            }
        }
        EPCBinaryEncoder ePCBinaryEncoder = Scheme.getBinaryEncoderForLongArray(lArray);
        try {
            ePC = ePCBinaryEncoder.decode(lArray);
        }
        catch (EPCException ePCException) {
            ePC = UnknownScheme.decodeUnknownFromLongArray(n3, lArray);
        }
        ePC.setBigInteger(bigInteger);
        return ePC;
    }

    private String b(int n, long l) {
        String string = Long.toHexString(l).toUpperCase();
        int n2 = string.length();
        if (n2 < n) {
            string = g.substring(0, n - n2) + string;
        }
        return string;
    }

    public URI encode(EPC ePC) throws EPCException {
        StringBuffer stringBuffer;
        URI uRI;
        block11: {
            block10: {
                uRI = null;
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.getPrefix());
                stringBuffer.append(ePC.getBitSize());
                stringBuffer.append(this.getDelimiter());
                if (this.f == 16) {
                    stringBuffer.append("x");
                }
                long[] lArray = ePC.getLongArray();
                if (this.f != 16) break block10;
                switch (ePC.getBitSize()) {
                    case 64: {
                        stringBuffer.append(this.b(16, lArray[1]));
                        break block11;
                    }
                    case 96: {
                        long l = 0xFFFFFFFFL & lArray[0];
                        stringBuffer.append(this.b(8, l));
                        stringBuffer.append(this.b(16, lArray[1]));
                        break block11;
                    }
                    case 128: {
                        stringBuffer.append(this.b(16, lArray[0]));
                        stringBuffer.append(this.b(16, lArray[1]));
                        break block11;
                    }
                    default: {
                        throw new EPCException(I18N.get("unsupported EPC bit size: {0}", ePC.getBitSize()));
                    }
                }
            }
            if (this.f == 10) {
                stringBuffer.append(ePC.getBigInteger());
            } else {
                throw new EPCException(I18N.get("unsupported radix: {0}", this.f));
            }
        }
        try {
            uRI = new URI(stringBuffer.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new EPCEncodingException(uRISyntaxException);
        }
        return uRI;
    }

    public static interface BitSize {
        public static final int BITSIZE_64 = 64;
        public static final int BITSIZE_96 = 96;
        public static final int BITSIZE_128 = 128;
    }

    public static interface Mode {
        public static final int DECIMAL = 10;
        public static final int HEX = 16;
    }
}

