/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.GRAIPattern;

public class GRAIIDPattern
extends EPCIDPattern {
    GRAIIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "grai";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        GRAIPattern gRAIPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                gRAIPattern = EPCPatternFactory.getInstance().createGRAI64Pattern();
            } else if (n == 96) {
                gRAIPattern = EPCPatternFactory.getInstance().createGRAI96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (gRAIPattern != null) {
                gRAIPattern.assign(this.getEPCPattern());
                gRAIPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return gRAIPattern;
    }
}

