/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCField;
import com.connecterra.ale.epc.EPCFieldNumeric;
import com.connecterra.ale.epc.EPCFieldString;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCValidationException;
import com.connecterra.ale.epc.PartitionTable;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epchelpers.CompanyPrefixTable;

public abstract class GS1Scheme
extends Scheme {
    protected static final String COMPANY_PREFIX_REG_EX = "[0-9]+";

    protected GS1Scheme(String string) {
        super(string);
    }

    public int companyPrefix2CompanyPrefixIndex(String string) throws EPCException {
        CompanyPrefixTable.TableEntry tableEntry = CompanyPrefixTable.getCompanyPrefix(string);
        if (tableEntry == null) {
            throw new EPCValidationException("unable to resolve company prefix: " + string);
        }
        return tableEntry.getIndex();
    }

    public String companyPrefixIndex2CompanyPrefix(int n) throws EPCException {
        CompanyPrefixTable.TableEntry tableEntry = CompanyPrefixTable.getCompanyPrefix(n);
        if (tableEntry == null) {
            throw new EPCValidationException("unable to resolve company prefix index: " + n);
        }
        return tableEntry.getPrefixAsString();
    }

    protected void interFieldValidationWithPartitionTable(EPC ePC, PartitionTable partitionTable, int n, int n2) throws EPCException, EPCValidationException {
        this.interFieldValidationWithPartitionTable(ePC, partitionTable, n, n2, true);
    }

    protected void interFieldValidationWithPartitionTable(EPC ePC, PartitionTable partitionTable, int n, int n2, boolean bl) throws EPCException, EPCValidationException {
        EPCImpl ePCImpl = ePC.getEPCImpl();
        EPCField ePCField = ePCImpl.getField(n);
        String string = ((EPCFieldString)ePCField).getValue();
        long l = Long.parseLong(string);
        int n3 = partitionTable.getRowForCompanyPrefix(string);
        int n4 = partitionTable.getCompanyPrefixBits(n3);
        int n5 = partitionTable.getCompanyPrefixDigits(n3);
        int n6 = partitionTable.getComplimentDigits(n3);
        int n7 = partitionTable.getComplimentBits(n3);
        EPCFieldNumeric ePCFieldNumeric = (EPCFieldNumeric)ePCImpl.getField(n2);
        long l2 = ePCFieldNumeric.getValue();
        long l3 = (long)Math.pow(10.0, n6) - 1L;
        long l4 = (long)Math.pow(2.0, n7) - 1L;
        long l5 = (long)Math.pow(2.0, n4) - 1L;
        if (bl && l2 > l3) {
            throw new EPCValidationException(ePCFieldNumeric.getEPCFieldDescriptor().getName() + " " + l2 + " exceeds maximum decimal capacity of " + l3);
        }
        if (l2 > l4) {
            throw new EPCValidationException(ePCFieldNumeric.getEPCFieldDescriptor().getName() + " " + l2 + " exceeds maximum binary capacity of " + l4);
        }
        if (l > l5) {
            throw new EPCValidationException(ePCFieldNumeric.getEPCFieldDescriptor().getName() + " " + l2 + " exceeds maximum binary capacity of " + l4);
        }
    }

    protected void interFieldValidationForGS1_64(int n, String string, long l) throws EPCException {
        int n2 = string.length();
        int n3 = n - n2;
        if (n3 <= 0) {
            throw new EPCValidationException("Company prefix is too long " + string);
        }
        double d = Math.pow(10.0, n3) - 1.0;
        if (d < (double)l) {
            throw new EPCValidationException("compliment " + l + " is greater than maximum value " + d);
        }
    }
}

