/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCIDPattern;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternFactory;
import com.connecterra.ale.epc.SGLNPattern;

public class SGLNIDPattern
extends EPCIDPattern {
    SGLNIDPattern(EPCPattern ePCPattern) {
        super(ePCPattern);
    }

    public String getTypeString() {
        return "sgln";
    }

    public EPCPattern getEPCPattern(int n, int n2) {
        SGLNPattern sGLNPattern = null;
        if (n2 < 0 || n2 > 8) {
            throw new IllegalArgumentException("Incorrect Filter Value: " + n2);
        }
        try {
            if (n == 64) {
                sGLNPattern = EPCPatternFactory.getInstance().createSGLN64Pattern();
            } else if (n == 96) {
                sGLNPattern = EPCPatternFactory.getInstance().createSGLN96Pattern();
            } else {
                throw new IllegalArgumentException("Incorrect tag length: " + n);
            }
            if (sGLNPattern != null) {
                sGLNPattern.assign(this.getEPCPattern());
                sGLNPattern.getFilter().setValue(n2);
            }
        }
        catch (EPCException ePCException) {
            throw new IllegalStateException(ePCException.getMessage());
        }
        return sGLNPattern;
    }
}

