/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.BinaryConverterForCompanyPrefixIndex;
import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCException;
import com.connecterra.ale.epc.EPCFieldConstraintMinMax;
import com.connecterra.ale.epc.EPCFieldConstraintPoint;
import com.connecterra.ale.epc.EPCFieldConstraintRegEx;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCFieldEncoder;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefix;
import com.connecterra.ale.epc.EPCFieldEncoder64bitCompanyPrefixCompliment;
import com.connecterra.ale.epc.EPCFieldEncoderNumeric;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.SGTIN64;
import com.connecterra.ale.epc.SGTIN64Pattern;
import com.connecterra.ale.epc.SGTINScheme;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.List;

public class SGTIN64Scheme
extends SGTINScheme {
    private final int hg = 2;
    private static final int dg = 13;
    private final int bg = 2;
    private final int ig = 3;
    private final int kg = 14;
    private final int cg = 20;
    private final int lg = 25;
    private final int jg = 64;
    private final int fg = 66;
    private final int gg = 69;
    private final int ag = 83;
    private final int eg = 103;

    protected SGTIN64Scheme(String string) {
        super(string);
    }

    protected int getHeaderBitSize() {
        return 2;
    }

    protected EPC createEPC(EPCImpl ePCImpl) throws EPCException {
        return new SGTIN64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        try {
            return new SGTIN64Pattern(ePCPatternImpl);
        }
        catch (EPCException ePCException) {
            throw new EPCPatternException(ePCException.getMessage(), ePCException);
        }
    }

    public EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Serialized Global Trade Item Number (SGTIN-64)"), 2, Scheme.SGTIN_64, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(5);
        arrayList.add(new EPCFieldDescriptor(2, 2, I18N.get("Header"), I18N.get("SGTIN-64 bit Header"), 0, false, ePCDescriptor, new EPCFieldConstraintPoint(I18N.get("SGTIN-64 Header constraint"), 2L)));
        arrayList.add(new EPCFieldDescriptor(2, 3, I18N.get("Filter Value"), I18N.get("SGTIN-64 Filter Value"), 1, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-64 Filter Value constraint"), 0L, 7L)));
        arrayList.add(new EPCFieldDescriptor(1, 14, I18N.get("Company Prefix"), I18N.get("SGTIN-64 bit Company Prefix"), 2, false, ePCDescriptor, new EPCFieldConstraintRegEx(I18N.get("SGTIN-64 Company Prefix constraint"), "[0-9]*", 6, 12)));
        arrayList.add(new EPCFieldDescriptor(2, 20, I18N.get("Item Reference"), I18N.get("SGTIN-64 Item Reference"), 3, false, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-64 Item Reference constraint"), 0L, 1048575L)));
        arrayList.add(new EPCFieldDescriptor(2, 25, I18N.get("Serial Number"), I18N.get("SGTIN-64 Serial Number"), 4, true, ePCDescriptor, new EPCFieldConstraintMinMax(I18N.get("SGTIN-64 Serial Number constraint"), 0L, 0x1FFFFFFL)));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    public EPCEncoder createTagURIEncoder() {
        String string = "urn:epc:tag:sgtin-64:";
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoderNumeric(0, 1, 10));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 1, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 2, 2, 3, 13));
        arrayList.add(new EPCFieldEncoderNumeric(3, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCEncoder createPureIdentityURIEncoder() {
        String string = "urn:epc:id:sgtin:";
        Object var2_2 = null;
        ArrayList<EPCFieldEncoder> arrayList = new ArrayList<EPCFieldEncoder>();
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefix(this, 0, 2));
        arrayList.add(new EPCFieldEncoder64bitCompanyPrefixCompliment(this, 1, 2, 3, 13));
        arrayList.add(new EPCFieldEncoderNumeric(2, 4, 10));
        EPCEncoder ePCEncoder = new EPCEncoder(this, string, ".", arrayList);
        return ePCEncoder;
    }

    public EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:sgtin-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 2));
        arrayList.add(new EPCBinaryFieldEncoder(1, 66, 3));
        arrayList.add(new EPCBinaryFieldEncoder(2, 69, 14, new BinaryConverterForCompanyPrefixIndex(this)));
        arrayList.add(new EPCBinaryFieldEncoder(3, 83, 20));
        arrayList.add(new EPCBinaryFieldEncoder(4, 103, 25));
        return new EPCBinaryEncoder(this, 2, arrayList);
    }

    protected void interFieldValidation(EPC ePC) throws EPCException {
        SGTIN64 sGTIN64 = (SGTIN64)ePC;
        String string = sGTIN64.getCompanyPrefix();
        long l = sGTIN64.getItemReference();
        this.interFieldValidationForGS1_64(13, string, l);
    }
}

