/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.ale.epc;

import com.connecterra.ale.epc.EPC;
import com.connecterra.ale.epc.EPCBinaryEncoder;
import com.connecterra.ale.epc.EPCBinaryFieldEncoder;
import com.connecterra.ale.epc.EPCDescriptor;
import com.connecterra.ale.epc.EPCEncoder;
import com.connecterra.ale.epc.EPCFieldDescriptor;
import com.connecterra.ale.epc.EPCImpl;
import com.connecterra.ale.epc.EPCPattern;
import com.connecterra.ale.epc.EPCPatternEncoder;
import com.connecterra.ale.epc.EPCPatternException;
import com.connecterra.ale.epc.EPCPatternImpl;
import com.connecterra.ale.epc.Scheme;
import com.connecterra.ale.epc.TDSVersion;
import com.connecterra.ale.epc.Unknown64;
import com.connecterra.ale.epc.UnknownScheme;
import com.connecterra.i18n.I18N;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Unknown64Scheme
extends UnknownScheme {
    private final int pb = 64;
    private final int sb = 0;
    private final int rb = 64;
    private final int qb = 64;

    public Unknown64Scheme(String string) {
        super(string);
    }

    protected EPC createEPC(EPCImpl ePCImpl) {
        return new Unknown64(ePCImpl);
    }

    protected EPCPattern createEPCPattern(EPCPatternImpl ePCPatternImpl) throws EPCPatternException {
        throw new EPCPatternException("not supported");
    }

    protected EPCDescriptor createEPCDescriptor() {
        EPCDescriptor ePCDescriptor = new EPCDescriptor(64, I18N.get("Unknown 64"), 0, Scheme.Unknown64Scheme, TDSVersion.TDS_V_1_26);
        ArrayList<EPCFieldDescriptor> arrayList = new ArrayList<EPCFieldDescriptor>(1);
        arrayList.add(new EPCFieldDescriptor(2, 64, I18N.get("raw value"), I18N.get("64 bit raw value"), 0, false, ePCDescriptor, null));
        ePCDescriptor.setEPCFieldDescriptorList(arrayList);
        return ePCDescriptor;
    }

    protected EPCEncoder createTagURIEncoder() {
        EPCEncoder ePCEncoder = new EPCEncoder(this, "urn:epc:tag:unknown-64:", ".", Collections.EMPTY_LIST);
        return ePCEncoder;
    }

    protected EPCEncoder createPureIdentityURIEncoder() {
        EPCEncoder ePCEncoder = new EPCEncoder(this, "urn:epc:id:unknown:", ".", Collections.EMPTY_LIST);
        return ePCEncoder;
    }

    protected EPCPatternEncoder createPatternURIEncoder() {
        String string = "urn:epc:pat:unknown-64:";
        List list = this.getTagURIEncoder().getEncoderFieldList();
        EPCPatternEncoder ePCPatternEncoder = new EPCPatternEncoder(this, string, ".", list);
        return ePCPatternEncoder;
    }

    protected EPCBinaryEncoder createBinaryEncoder() {
        ArrayList<EPCBinaryFieldEncoder> arrayList = new ArrayList<EPCBinaryFieldEncoder>();
        arrayList.add(new EPCBinaryFieldEncoder(0, 64, 64));
        return new EPCBinaryEncoder(this, 0, arrayList);
    }
}

