/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.alepc.axis.adapters;

import com.connecterra.alepc.api.PCSpecValidationException;
import com.connecterra.alepc.axis.adapters.AccessSpecAdapter;
import com.connecterra.alepc.axis.schema.AccessSpec;
import com.connecterra.alepc.axis.schema.BoundarySpec;
import com.connecterra.alepc.axis.schema.LogicalReaders;
import com.connecterra.alepc.axis.schema.PCSpec;
import com.connecterra.alepc.axis.schema.ReaderParameter;
import com.connecterra.alepc.axis.schema.ReaderParameters;
import com.connecterra.i18n.I18N;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PCSpecAdapter
implements com.connecterra.alepc.api.PCSpec {
    private PCSpec b;

    public static PCSpec aleToAxis(com.connecterra.alepc.api.PCSpec pCSpec) {
        if (pCSpec == null) {
            return null;
        }
        if (pCSpec instanceof PCSpecAdapter) {
            return ((PCSpecAdapter)pCSpec).getAxisPCSpec();
        }
        return new PCSpecAdapter(pCSpec).getAxisPCSpec();
    }

    public static com.connecterra.alepc.api.PCSpec axisToALE(PCSpec pCSpec) throws URISyntaxException, PCSpecValidationException {
        return pCSpec == null ? null : new PCSpecAdapter(pCSpec);
    }

    PCSpecAdapter(com.connecterra.alepc.api.PCSpec pCSpec) {
        this.b = new PCSpec();
        this.setCacheName(pCSpec.getCacheName());
        this.setApplicationData(pCSpec.getApplicationData());
        this.setLogicalReaderNames(pCSpec.getLogicalReaderNames());
        this.setReaderParameters(pCSpec.getReaderParameters());
        this.setStartTrigger(pCSpec.getStartTrigger());
        this.setStopTrigger(pCSpec.getStopTrigger());
        this.setTrials(pCSpec.getTrials());
        this.setDuration(pCSpec.getDuration());
        this.setRestrictSingleTag(pCSpec.isRestrictSingleTag());
        List list = pCSpec.getAccessSpecs();
        if (list != null) {
            AccessSpec[] accessSpecArray = new AccessSpec[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                com.connecterra.alepc.api.AccessSpec accessSpec = (com.connecterra.alepc.api.AccessSpec)list.get(i);
                accessSpecArray[i] = AccessSpecAdapter.aleToAxis(accessSpec);
            }
            this.b.setAccessSpec(accessSpecArray);
        } else {
            this.b.setAccessSpec(new AccessSpec[0]);
        }
    }

    public PCSpecAdapter() {
        this.b = new PCSpec();
    }

    private PCSpecAdapter(PCSpec pCSpec) throws URISyntaxException, PCSpecValidationException {
        int n;
        Serializable[] serializableArray;
        this.b = pCSpec;
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec != null) {
            if (boundarySpec.getStartTrigger() != null) {
                new URI(boundarySpec.getStartTrigger());
            }
            if (boundarySpec.getStopTrigger() != null) {
                new URI(boundarySpec.getStopTrigger());
            }
        }
        HashSet<String> hashSet = new HashSet<String>();
        ReaderParameters readerParameters = this.b.getReaderParameters();
        if (readerParameters != null && (serializableArray = readerParameters.getReaderParameter()) != null) {
            for (n = 0; n < serializableArray.length; ++n) {
                Serializable serializable = serializableArray[n];
                if (hashSet.add(((ReaderParameter)serializable).getName())) continue;
                throw new PCSpecValidationException(I18N.get("Duplicate reader parameter: {0}", ((ReaderParameter)serializable).getName()));
            }
        }
        if ((serializableArray = pCSpec.getAccessSpec()) != null) {
            for (n = 0; n < serializableArray.length; ++n) {
                AccessSpecAdapter.axisToALE((AccessSpec)serializableArray[n]);
            }
        }
    }

    public PCSpec getAxisPCSpec() {
        return this.b;
    }

    public String getCacheName() {
        return this.b.getCacheName();
    }

    public void setCacheName(String string) {
        this.b.setCacheName(string);
    }

    public String getApplicationData() {
        return this.b.getApplicationData();
    }

    public void setApplicationData(String string) {
        this.b.setApplicationData(string);
    }

    public List getLogicalReaderNames() {
        LogicalReaders logicalReaders = this.b.getLogicalReaders();
        if (logicalReaders == null || logicalReaders.getLogicalReader() == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(Arrays.asList(logicalReaders.getLogicalReader()));
    }

    public void setLogicalReaderNames(List list) {
        if (list == null) {
            return;
        }
        LogicalReaders logicalReaders = new LogicalReaders();
        logicalReaders.setLogicalReader(list.toArray(new String[list.size()]));
        this.b.setLogicalReaders(logicalReaders);
    }

    public void addLogicalReaderName(String string) {
        List list = this.getLogicalReaderNames();
        if (list.contains(string)) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add(string);
        this.setLogicalReaderNames(arrayList);
    }

    public void addLogicalReaderNames(List list) {
        if (list == null) {
            return;
        }
        List list2 = this.getLogicalReaderNames();
        ArrayList<String> arrayList = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (list2.contains(string)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>(list2.size() + list.size());
                arrayList.addAll(list2);
            }
            arrayList.add(string);
        }
        if (arrayList != null) {
            this.setLogicalReaderNames(arrayList);
        }
    }

    public String getReaderParameter(String string) {
        ReaderParameters readerParameters = this.b.getReaderParameters();
        if (readerParameters == null) {
            return null;
        }
        ReaderParameter[] readerParameterArray = readerParameters.getReaderParameter();
        if (readerParameterArray == null) {
            return null;
        }
        for (int i = 0; i < readerParameterArray.length; ++i) {
            ReaderParameter readerParameter = readerParameterArray[i];
            if (!readerParameter.getName().equals(string)) continue;
            return readerParameter.get_value();
        }
        return null;
    }

    public void setReaderParameter(String string, String string2) {
        Map map = this.b();
        if (string2 != null) {
            map.put(string, string2);
        } else {
            map.remove(string);
        }
        this.setReaderParameters(map);
    }

    public Map getReaderParameters() {
        return Collections.unmodifiableMap(this.b());
    }

    private Map b() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ReaderParameters readerParameters = this.b.getReaderParameters();
        if (readerParameters == null) {
            return hashMap;
        }
        ReaderParameter[] readerParameterArray = readerParameters.getReaderParameter();
        if (readerParameterArray == null) {
            return hashMap;
        }
        for (int i = 0; i < readerParameterArray.length; ++i) {
            ReaderParameter readerParameter = readerParameterArray[i];
            if (readerParameter.get_value() == null) continue;
            hashMap.put(readerParameter.getName(), readerParameter.get_value());
        }
        return hashMap;
    }

    public void setReaderParameters(Map map) {
        Object object;
        if (map == null) {
            return;
        }
        ArrayList<ReaderParameter> arrayList = new ArrayList<ReaderParameter>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = (String)map.get(object);
            if (string == null) continue;
            ReaderParameter readerParameter = new ReaderParameter();
            readerParameter.setName((String)object);
            readerParameter.set_value(string);
            arrayList.add(readerParameter);
        }
        object = new ReaderParameters();
        ((ReaderParameters)object).setReaderParameter(arrayList.toArray(new ReaderParameter[arrayList.size()]));
        this.b.setReaderParameters((ReaderParameters)object);
    }

    public void addReaderParameters(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            this.setReaderParameter(string, string2);
        }
    }

    public URI getStartTrigger() {
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec == null || boundarySpec.getStartTrigger() == null) {
            return null;
        }
        try {
            return new URI(boundarySpec.getStartTrigger());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException();
        }
    }

    public void setStartTrigger(URI uRI) {
        BoundarySpec boundarySpec = this.c();
        if (uRI != null) {
            boundarySpec.setStartTrigger(uRI.toString());
        }
    }

    public URI getStopTrigger() {
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec == null || boundarySpec.getStopTrigger() == null) {
            return null;
        }
        try {
            return new URI(boundarySpec.getStopTrigger());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException();
        }
    }

    public void setStopTrigger(URI uRI) {
        BoundarySpec boundarySpec = this.c();
        if (uRI != null) {
            boundarySpec.setStopTrigger(uRI.toString());
        }
    }

    private BoundarySpec c() {
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec == null) {
            boundarySpec = new BoundarySpec();
            this.b.setBoundarySpec(boundarySpec);
        }
        return boundarySpec;
    }

    public int getTrials() {
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec == null) {
            return 0;
        }
        Integer n = boundarySpec.getTrials();
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void setTrials(int n) {
        this.c().setTrials(new Integer(n));
    }

    public long getDuration() {
        BoundarySpec boundarySpec = this.b.getBoundarySpec();
        if (boundarySpec == null) {
            return 0L;
        }
        Long l = boundarySpec.getDuration();
        if (l == null) {
            return 0L;
        }
        return l;
    }

    public void setDuration(long l) {
        this.c().setDuration(new Long(l));
    }

    public List getAccessSpecs() {
        AccessSpec[] accessSpecArray = this.b.getAccessSpec();
        if (accessSpecArray == null) {
            return null;
        }
        ArrayList<com.connecterra.alepc.api.AccessSpec> arrayList = new ArrayList<com.connecterra.alepc.api.AccessSpec>(accessSpecArray.length);
        for (int i = 0; i < accessSpecArray.length; ++i) {
            try {
                arrayList.add(AccessSpecAdapter.axisToALE(accessSpecArray[i]));
                continue;
            }
            catch (PCSpecValidationException pCSpecValidationException) {
                throw new RuntimeException("Unexpected PCSpecValidationException in PCSpecAdapter.getAccessSpecs", pCSpecValidationException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Unexpected URISyntaxException in PCSpecAdapter.getAccessSpecs", uRISyntaxException);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setAccessSpecs(List list) {
        AccessSpec[] accessSpecArray = new AccessSpec[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            accessSpecArray[i] = AccessSpecAdapter.aleToAxis((com.connecterra.alepc.api.AccessSpec)list.get(i));
        }
        this.b.setAccessSpec(accessSpecArray);
    }

    public void addAccessSpec(com.connecterra.alepc.api.AccessSpec accessSpec) {
        ArrayList<AccessSpec> arrayList = new ArrayList<AccessSpec>();
        if (this.b.getAccessSpec() != null) {
            arrayList.addAll(Arrays.asList(this.b.getAccessSpec()));
        }
        arrayList.add(AccessSpecAdapter.aleToAxis(accessSpec));
        this.b.setAccessSpec(arrayList.toArray(new AccessSpec[0]));
    }

    public boolean isRestrictSingleTag() {
        return this.b.isRestrictSingleTag();
    }

    public void setRestrictSingleTag(boolean bl) {
        this.b.setRestrictSingleTag(bl);
    }
}

