/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.httpMessage;

import com.connecterra.httpMessage.DecodeException;
import com.connecterra.httpMessage.HTTPConnection;
import com.connecterra.httpMessage.HTTPMessage;
import com.connecterra.httpMessage.HTTPMessageCodec;
import com.connecterra.httpMessage.ProtocolException;
import com.connecterra.httpMessage.TimeoutException;
import com.connecterra.i18n.I18N;
import java.io.IOException;
import java.util.logging.Logger;

public class HTTPServer
extends HTTPConnection {
    private static Logger g = Logger.getLogger("com.connecterra.httpMessage.HTTPServer");
    private boolean f = false;

    public HTTPServer(HTTPMessageCodec hTTPMessageCodec) {
        super(hTTPMessageCodec);
    }

    public HTTPMessage receiveHTTPRequest(int n) throws DecodeException, ProtocolException, IOException, TimeoutException, InterruptedException {
        HTTPMessage hTTPMessage = this.receiveHTTP(n);
        if (hTTPMessage == null) {
            return null;
        }
        if (hTTPMessage.getRequestMethod() == null) {
            throw new ProtocolException(I18N.get("Expected request, got: {0}", hTTPMessage.toString(0)));
        }
        g.fine("Received request: " + hTTPMessage.toString(32));
        this.f = this.isRequestingPersistent(hTTPMessage);
        return hTTPMessage;
    }

    public void sendHTTPResponse(HTTPMessage hTTPMessage, int n) throws IOException, TimeoutException, InterruptedException {
        if (hTTPMessage.getResponseCode() == -1) {
            throw new IllegalArgumentException(I18N.get("Not a response: {0}", hTTPMessage));
        }
        g.fine("Sending response: " + hTTPMessage.toString(32));
        this.sendHTTP(hTTPMessage, n);
        if (!this.f || !this.isRequestingPersistent(hTTPMessage)) {
            g.fine("Closing non-persistent");
            this.close();
        }
    }

    public void finishInterruptedSend(int n) throws IOException, TimeoutException, InterruptedException {
        this.finishInterrupted(n);
    }
}

