/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.i18n;

import com.connecterra.i18n.I18NDecorator;
import com.connecterra.i18n.I18NDefaultDecorator;
import com.connecterra.i18n.I18NPattern;
import com.connecterra.i18n.I18NTranslator;
import com.connecterra.i18n.KeyConverter;
import com.connecterra.i18n.ServiceResourceBundle;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class I18NDefaultTranslator
implements I18NTranslator {
    private Logger f = Logger.getLogger("com.connecterra.i18n.I18NDefaultTranslator");
    private Locale e;
    private List d;
    private ResourceBundle c = null;
    private I18NDecorator b = null;

    public I18NDefaultTranslator() {
        String string = System.getProperty("com.connecterra.i18n.locale");
        if (string != null && string.trim().length() > 0) {
            this.setLocale(string);
        } else {
            this.setLocale((Locale)null);
        }
    }

    public I18NDefaultTranslator(String string) {
        this.setLocale(string);
    }

    private void b() {
        try {
            this.c = new ServiceResourceBundle("com.connecterra.i18n.ResourceBaseName", this.e);
        }
        catch (IOException iOException) {
            this.f.warning("resource bundle for localization could not be created: " + iOException.getMessage());
        }
        this.b = new I18NDefaultDecorator();
    }

    public void setLocale(String string) {
        Locale locale = null;
        if (string == null || string.trim().length() == 0) {
            this.setLocale(locale);
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        int n = stringTokenizer.countTokens();
        switch (n) {
            case 1: {
                locale = new Locale(stringTokenizer.nextToken());
                break;
            }
            case 2: {
                locale = new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                break;
            }
            case 3: {
                locale = new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
                break;
            }
        }
        this.f.finest("About to set Locale: " + locale.toString());
        this.f.finest("language: " + locale.getLanguage());
        this.f.finest("country: " + locale.getCountry());
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.e = locale;
        this.d = new ArrayList();
        if (this.e != null) {
            if (this.e.getVariant().length() > 0) {
                this.d.add("_" + this.e.getLanguage() + "_" + this.e.getCountry() + "_" + this.e.getVariant());
            }
            if (this.e.getCountry().length() > 0) {
                this.d.add("_" + this.e.getLanguage() + "_" + this.e.getCountry());
            }
            if (this.e.getLanguage().length() > 0) {
                this.d.add("_" + this.e.getLanguage());
            }
        }
        Locale locale2 = Locale.getDefault();
        this.f.finest("Default Locale: " + locale2.toString());
        this.f.finest("language: " + locale2.getLanguage());
        this.f.finest("country: " + locale2.getCountry());
        if (locale2.getVariant().length() > 0) {
            this.d.add("_" + locale2.getLanguage() + "_" + locale2.getCountry() + "_" + locale2.getVariant());
        }
        if (locale2.getCountry().length() > 0) {
            this.d.add("_" + locale2.getLanguage() + "_" + locale2.getCountry());
        }
        if (locale2.getLanguage().length() > 0) {
            this.d.add("_" + locale2.getLanguage());
        }
        this.d.add("");
        this.f.finest("m_localeStrings: " + this.d);
        this.b();
    }

    public Locale getLocale() {
        return this.e;
    }

    private String c() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = this.getClass().getPackage().getName();
        String string2 = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            String string3 = stackTraceElementArray[i].getClassName();
            string2 = string3.substring(0, string3.lastIndexOf(46));
            if (string2.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public String getByPattern(I18NPattern i18NPattern, Object[] objectArray) {
        if (i18NPattern.getKey() != null) {
            return this.getByKey(i18NPattern.getKey(), i18NPattern.getPattern(), objectArray);
        }
        return this.get(i18NPattern.getPattern(), objectArray);
    }

    public String get(String string, Object[] objectArray) {
        return this.getByKey(KeyConverter.convertKey(string), string, objectArray);
    }

    public String getByKey(String string, String string2, Object[] objectArray) {
        boolean bl;
        String string3 = null;
        boolean bl2 = this.f.isLoggable(Level.FINER);
        if (this.c != null) {
            String string4 = this.c();
            if (string4 == null) {
                this.f.log(Level.WARNING, "Package name could not be determined", new Throwable());
                string = "<unknown package>." + string;
            } else {
                string = string4 + "." + string;
                try {
                    if (bl2) {
                        this.f.finer("I18N:englishPattern=" + string2);
                        this.f.finer("I18N:key=" + string);
                        this.f.finer("I18N:locale=" + this.e);
                    }
                    string3 = this.c.getString(string);
                    if (bl2) {
                        this.f.finer("I18N:msg=" + string3);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                if (string3 != null && string3.trim().length() == 0) {
                    string3 = null;
                }
            }
        }
        boolean bl3 = bl = string3 != null;
        if (!bl) {
            string3 = string2;
        }
        MessageFormat messageFormat = this.e == null ? new MessageFormat(string3) : new MessageFormat(string3, this.e);
        String string5 = messageFormat.format(objectArray);
        if (bl2) {
            this.f.finer("I18N:formatted=" + string5);
        }
        return this.b.decorate(string, string2, string5, bl, objectArray);
    }

    private URL b(String string, String string2) {
        URL uRL = null;
        String string3 = "";
        Class<?> clazz = null;
        Iterator iterator = this.d.iterator();
        while (iterator.hasNext()) {
            string3 = "/" + string + (String)iterator.next() + "/" + string2;
            clazz = this.getClass();
            uRL = clazz.getResource(string3);
            if (uRL == null) continue;
        }
        if (clazz != null) {
            this.f.finest(clazz.toString() + " looking for resource " + string3);
        }
        if (clazz != null && uRL == null) {
            this.f.fine(clazz.toString() + " failed to find resource " + string3);
        }
        return uRL;
    }

    public Image getImage(String string) {
        boolean bl;
        Image image;
        URL uRL = this.b("images", string);
        if (uRL == null) {
            this.f.fine("No localized image found for filename " + string);
            image = new ImageIcon().getImage();
            bl = false;
        } else {
            image = new ImageIcon(uRL).getImage();
            bl = true;
        }
        return this.b.decorate(string, image, bl);
    }
}

