/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.client;

import com.connecterra.modbus.client.MODBUSClientCallback;
import com.connecterra.modbus.client.MODBUSClientReceiver;
import com.connecterra.modbus.client.ModbusException;
import com.connecterra.modbus.client.TooManyTransactionsException;
import com.connecterra.modbus.client.TransactionTable;
import com.connecterra.modbus.protocol.ADU;
import com.connecterra.modbus.protocol.ExceptionPDU;
import com.connecterra.modbus.protocol.MODBUSPDU;
import com.connecterra.modbus.protocol.ProtocolException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MODBUSClient {
    private static final Logger k = Logger.getLogger("com.connecterra.modbus.client");
    private SocketAddress c;
    private Socket l;
    private OutputStream g;
    private MODBUSClientReceiver e;
    private TransactionTable f;
    private Thread b;
    private long i;
    private long m;
    private int j;
    private int d = 15000;
    private volatile boolean h = false;

    public MODBUSClient(String string, int n, int n2, int n3) throws UnknownHostException, IOException {
        this(string, n, n2, n3, -1, 0L);
    }

    public MODBUSClient(String string, int n, int n2, int n3, int n4, long l) throws UnknownHostException, IOException {
        this.d = n2;
        this.j = n3;
        this.i = l;
        this.m = -1L;
        this.c = new InetSocketAddress(string, n);
        this.f = new TransactionTable(n4);
        try {
            this.b();
        }
        catch (IOException iOException) {
            k.log(Level.WARNING, "Connection to PLC at " + this.c + " failed: " + iOException.getMessage(), iOException);
        }
    }

    private void b() throws IOException {
        if (this.l != null && this.l.isConnected()) {
            return;
        }
        this.l = new Socket();
        this.l.setTcpNoDelay(true);
        this.l.setSoTimeout(this.d);
        this.l.connect(this.c, this.d);
        this.g = this.l.getOutputStream();
        this.e = new MODBUSClientReceiver(this.l.getInputStream(), this.f);
        this.b = new ReceiverThread();
        this.b.setDaemon(true);
        this.b.start();
        k.info("Connected to Modbus PLC at " + this.c);
    }

    public synchronized void send(MODBUSPDU mODBUSPDU, MODBUSClientCallback mODBUSClientCallback) throws TooManyTransactionsException, IOException, InterruptedException {
        long l;
        if (this.h) {
            throw new IOException("Already closed.");
        }
        this.b();
        int n = this.f.register(mODBUSClientCallback);
        if (n < 0) {
            throw new TooManyTransactionsException();
        }
        ADU aDU = new ADU(this.j, n, mODBUSPDU);
        if (this.i > 0L && (l = this.m + this.i - System.currentTimeMillis()) > 0L) {
            if (k.isLoggable(Level.FINER)) {
                k.finer("Delaying ModBus transaction by " + l + "ms");
            }
            Thread.sleep(l);
        }
        aDU.write(this.g);
        this.g.flush();
        if (this.i > 0L) {
            this.m = System.currentTimeMillis();
        }
        if (k.isLoggable(Level.FINER)) {
            k.finer("wrote ModBus transactionID=" + n);
        }
        this.f.notifyReadyforRead();
    }

    public MODBUSPDU send(MODBUSPDU mODBUSPDU) throws TooManyTransactionsException, ModbusException, IOException {
        MODBUSPDU mODBUSPDU2;
        final PDUMailbox pDUMailbox = new PDUMailbox();
        k.finer("received request!");
        try {
            this.send(mODBUSPDU, new MODBUSClientCallback(){

                public void receive(MODBUSPDU mODBUSPDU) {
                    pDUMailbox.put(mODBUSPDU);
                }

                public void connectionError(IOException iOException) {
                    pDUMailbox.setConnectionError(iOException);
                }
            });
            mODBUSPDU2 = pDUMailbox.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("thread interrupted in modbus exchange");
        }
        if (mODBUSPDU2 instanceof ExceptionPDU) {
            throw new ModbusException("Exception code " + ((ExceptionPDU)mODBUSPDU2).getExceptionCode() + " received");
        }
        if (mODBUSPDU2.getFunctionCode() != mODBUSPDU.getFunctionCode()) {
            throw new ModbusException("Response PDU function code " + mODBUSPDU2.getFunctionCode() + " does not match request PDU function code" + mODBUSPDU.getFunctionCode());
        }
        return mODBUSPDU2;
    }

    public boolean isAlive() {
        return this.l.isConnected() && this.b.isAlive();
    }

    public void close() throws IOException {
        if (!this.h) {
            this.h = true;
            this.l.close();
        }
    }

    public void closeWhenFinished() {
        throw new UnsupportedOperationException("TBD");
    }

    private class ReceiverThread
    extends Thread {
        private ReceiverThread() {
        }

        public void run() {
            EOFException eOFException;
            Exception exception = null;
            try {
                MODBUSClient.this.e.run();
            }
            catch (ProtocolException protocolException) {
                exception = protocolException;
                if (!(protocolException.getCause() instanceof EOFException)) {
                    k.log(Level.WARNING, "Protocol exception: " + protocolException.getMessage(), protocolException);
                }
            }
            catch (RuntimeException runtimeException) {
                exception = runtimeException;
                k.log(Level.WARNING, "Internal error: " + runtimeException.getMessage(), runtimeException);
            }
            try {
                MODBUSClient.this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (exception != null) {
                eOFException = new EOFException(exception.getMessage());
                eOFException.initCause(exception);
            } else {
                eOFException = new EOFException("modbus/tcp connection closed");
            }
            MODBUSClient.this.f.abortAllTransactions(eOFException);
        }
    }

    private class PDUMailbox {
        private MODBUSPDU c;
        private IOException d;

        private PDUMailbox() {
        }

        public synchronized MODBUSPDU get() throws IOException, InterruptedException {
            while (this.c == null && this.d == null) {
                this.wait();
            }
            if (this.d != null) {
                throw this.d;
            }
            if (k.isLoggable(Level.FINER)) {
                k.finer("PDU received: " + System.identityHashCode(this.c));
            }
            return this.c;
        }

        public synchronized void put(MODBUSPDU mODBUSPDU) {
            this.c = mODBUSPDU;
            this.notifyAll();
        }

        public synchronized void setConnectionError(IOException iOException) {
            this.d = iOException;
            this.notifyAll();
        }
    }
}

