/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.modbus.protocol;

import com.connecterra.modbus.protocol.MODBUSConstants;
import com.connecterra.modbus.protocol.MODBUSPDU;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public class AbstractWriteSingleCoilPDU
extends MODBUSPDU
implements MODBUSConstants {
    private static Logger k = Logger.getLogger(AbstractWriteSingleCoilPDU.class.getName());
    private int i;
    private boolean j;

    public AbstractWriteSingleCoilPDU() {
    }

    public AbstractWriteSingleCoilPDU(int n, boolean bl) {
        this.setFunctionCode((byte)5);
        this.i = n;
        this.j = bl;
    }

    public int getAddress() {
        return this.i;
    }

    public boolean getValue() {
        return this.j;
    }

    void b(byte[] byArray) {
        if (byArray.length != 5) {
            this.setParseError();
        } else {
            this.i = (byArray[1] << 8) + byArray[2];
            int n = (byArray[3] << 8) + byArray[4];
            if (n == 0) {
                this.j = false;
            } else if (n == 65280) {
                this.j = true;
            } else {
                this.setParseError();
            }
        }
    }

    int b() {
        return 5;
    }

    void b(OutputStream outputStream) throws IOException {
        k.finer("about to write PDU: " + this.getFunctionCode() + " " + this.i + " " + this.j);
        int n = this.j ? 65280 : 0;
        outputStream.write(this.getFunctionCode());
        outputStream.write(this.i >> 8);
        outputStream.write(this.i);
        outputStream.write(n >> 8);
        outputStream.write(n);
    }
}

