/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.opc.opcTransaction;

import com.connecterra.connectionPool.Connection;
import com.connecterra.connectionPool.ConnectionCreateException;
import com.connecterra.connectionPool.ConnectionPool;
import com.connecterra.i18n.I18N;
import com.connecterra.opc.api.OPC;
import com.connecterra.opc.api.OPCException;
import com.connecterra.opc.api.TimeoutException;
import com.connecterra.opc.connectionPool.OPCConnection;
import com.connecterra.opc.opcTransaction.DuplicateTransactionException;
import com.connecterra.opc.opcTransaction.ItemPairTransactionObserver;
import com.connecterra.opc.opcTransaction.NoSuchTransactionException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ItemPairTransactionReceiver {
    private static final int b = 10000;
    private static Logger d = Logger.getLogger("com.connecterra.opc.opcTransaction.ItemPairTransactionReceiver");
    private ConnectionPool e;
    private Map c = new HashMap();
    private List i = new ArrayList();
    private boolean h = false;
    private boolean f = true;
    private int g;

    public ItemPairTransactionReceiver(ConnectionPool connectionPool, int n) {
        if (connectionPool == null) {
            throw new IllegalArgumentException("pool must be specified");
        }
        this.e = connectionPool;
        this.g = n;
        if (this.g <= 0) {
            this.g = 10000;
        }
    }

    public void addTransaction(String string, String string2, String string3) throws DuplicateTransactionException {
        if (string == null) {
            throw new IllegalArgumentException("name must be specified");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("counterItem must be specified");
        }
        if (this.c.containsKey(string)) {
            throw new DuplicateTransactionException(I18N.get("transaction {0} is already added", string));
        }
        TxnItems txnItems = new TxnItems();
        txnItems.m_counter = string2;
        txnItems.m_ack = string3;
        txnItems.m_initialValue = null;
        txnItems.m_observers = Collections.synchronizedSet(new HashSet());
        this.c.put(string, txnItems);
        this.i.add(string);
    }

    public void addObserver(String string, ItemPairTransactionObserver itemPairTransactionObserver) throws NoSuchTransactionException {
        TxnItems txnItems = (TxnItems)this.c.get(string);
        if (txnItems == null) {
            throw new NoSuchTransactionException(I18N.get("transaction {0} is not defined", string));
        }
        txnItems.m_observers.add(itemPairTransactionObserver);
    }

    public void removeObserver(String string, ItemPairTransactionObserver itemPairTransactionObserver) throws NoSuchTransactionException {
        TxnItems txnItems = (TxnItems)this.c.get(string);
        if (txnItems == null) {
            throw new NoSuchTransactionException(I18N.get("transaction {0} is not defined", string));
        }
        txnItems.m_observers.remove(itemPairTransactionObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws InterruptedException {
        TxnItems txnItems;
        String[] stringArray = new String[this.c.size()];
        String[] stringArray2 = new String[this.c.size()];
        Object[] objectArray = new Object[this.c.size()];
        int n = 0;
        Object[] objectArray2 = this.i.iterator();
        while (objectArray2.hasNext()) {
            stringArray[n] = (String)objectArray2.next();
            txnItems = (TxnItems)this.c.get(stringArray[n]);
            stringArray2[n] = txnItems.m_counter;
            ++n;
        }
        objectArray2 = this;
        synchronized (objectArray2) {
            this.h = false;
        }
        block7: while (!this.b()) {
            if (this.doSync()) {
                d.info(I18N.get("Syncing with initial PLC state"));
                this.c();
                for (n = 0; n < stringArray.length; ++n) {
                    objectArray[n] = ((TxnItems)this.c.get((Object)stringArray[n])).m_initialValue;
                }
                d.info(I18N.get("Initial PLC state synchronization complete, now polling."));
            }
            if ((objectArray2 = this.b(stringArray2, objectArray)) == null) continue;
            for (n = 0; n < objectArray2.length; ++n) {
                if (objectArray2[n] == null) continue;
                txnItems = (TxnItems)this.c.get(stringArray[n]);
                Set set = txnItems.m_observers;
                synchronized (set) {
                    d.fine("notify " + txnItems.m_observers.size() + " observers of transaction " + stringArray[n]);
                    Iterator iterator = txnItems.m_observers.iterator();
                    while (iterator.hasNext()) {
                        ItemPairTransactionObserver itemPairTransactionObserver = (ItemPairTransactionObserver)iterator.next();
                        itemPairTransactionObserver.valueChanged(stringArray[n], objectArray2[n]);
                    }
                }
                if (txnItems.m_ack != null) {
                    this.b(txnItems.m_ack, objectArray2[n]);
                }
                if (this.doSync()) continue block7;
                objectArray[n] = objectArray2[n];
                txnItems.m_initialValue = objectArray2[n];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() throws InterruptedException {
        Connection connection = null;
        while (connection == null && !this.b()) {
            try {
                connection = this.e.checkout();
            }
            catch (ConnectionCreateException connectionCreateException) {
                d.log(Level.WARNING, I18N.get("error getting OPC connection from pool"), connectionCreateException);
                Thread.currentThread();
                Thread.sleep(1000L);
            }
        }
        OPC oPC = ((OPCConnection)connection).getOPC();
        try {
            Object object = this.i.iterator();
            block12: while (object.hasNext()) {
                String string = (String)object.next();
                TxnItems txnItems = (TxnItems)this.c.get(string);
                if (txnItems.m_ack == null) {
                    txnItems.m_initialValue = null;
                    continue;
                }
                while (!this.b()) {
                    d.finer("syncing transaction " + string);
                    try {
                        Object object2 = oPC.read(txnItems.m_counter);
                        Object object3 = oPC.read(txnItems.m_ack);
                        if (Thread.interrupted()) {
                            throw new InterruptedException(I18N.get("resync read interrupted"));
                        }
                        if (!object2.equals(object3)) {
                            txnItems.m_initialValue = object3;
                            continue block12;
                        }
                        txnItems.m_initialValue = object2;
                        continue block12;
                    }
                    catch (RemoteException remoteException) {
                        d.log(Level.WARNING, remoteException.getMessage(), remoteException);
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (OPCException oPCException) {
                        d.log(Level.WARNING, oPCException.getMessage(), oPCException);
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                }
            }
            object = this;
            synchronized (object) {
                this.f = false;
                this.notifyAll();
            }
        }
        finally {
            if (connection != null) {
                this.e.checkin(connection);
            }
        }
    }

    protected void beforePoll() throws InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] b(String[] stringArray, Object[] objectArray) throws InterruptedException {
        Connection connection = null;
        this.beforePoll();
        try {
            connection = this.e.checkout();
            OPC oPC = ((OPCConnection)connection).getOPC();
            Object[] objectArray2 = oPC.poll(stringArray, objectArray, this.g);
            if (!this.doSync()) {
                Object[] objectArray3 = objectArray2;
                return objectArray3;
            }
        }
        catch (TimeoutException timeoutException) {
            d.finest("Poll timed out, continuing");
        }
        catch (ConnectionCreateException connectionCreateException) {
            d.log(Level.WARNING, connectionCreateException.getMessage(), connectionCreateException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        catch (RemoteException remoteException) {
            d.log(Level.WARNING, remoteException.getMessage(), remoteException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        catch (OPCException oPCException) {
            d.log(Level.WARNING, oPCException.getMessage(), oPCException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        finally {
            if (connection != null) {
                this.e.checkin(connection);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(String string, Object object) throws InterruptedException {
        Connection connection = null;
        try {
            connection = this.e.checkout();
            OPC oPC = ((OPCConnection)connection).getOPC();
            oPC.write(string, object);
        }
        catch (ConnectionCreateException connectionCreateException) {
            d.log(Level.WARNING, connectionCreateException.getMessage(), connectionCreateException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        catch (RemoteException remoteException) {
            d.log(Level.WARNING, remoteException.getMessage(), remoteException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        catch (OPCException oPCException) {
            d.log(Level.WARNING, oPCException.getMessage(), oPCException);
            Thread.currentThread();
            Thread.sleep(1000L);
            this.resync();
        }
        finally {
            if (connection != null) {
                this.e.checkin(connection);
            }
        }
    }

    public synchronized void resync() {
        this.f = true;
    }

    public synchronized void waitForResync() throws InterruptedException {
        while (this.f) {
            this.wait();
        }
    }

    public synchronized boolean doSync() {
        return this.f;
    }

    public synchronized void cancel() {
        this.h = true;
    }

    private synchronized boolean b() {
        return this.h;
    }

    private static class TxnItems {
        public String m_counter;
        public String m_ack;
        public Object m_initialValue;
        public Set m_observers;

        private TxnItems() {
        }
    }
}

