/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plc;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCMessageConvention;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigItemException;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.ValidatedConfig;
import com.connecterra.util.event.AlarmClock;
import com.connecterra.util.event.Scheduler;
import com.connecterra.util.event.ThreadPoolScheduler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class PLCFactory {
    private static Logger g = Logger.getLogger(PLCFactory.class.getName());
    private static Map f = new HashMap();
    private static Map i = new HashMap();
    private ThreadPoolScheduler c;
    private AlarmClock b;
    private Map d = new HashMap();
    private Map j = new HashMap();
    private Map h = new HashMap();
    private Map e = new HashMap();

    public PLCFactory(RawConfig rawConfig, ThreadPoolScheduler threadPoolScheduler, AlarmClock alarmClock) throws ConfigValidationException, PLCException, IOException {
        f.put("Simple", "com.connecterra.plctypes.SimpleMessageConvention");
        f.put("Multiple", "com.connecterra.plctypes.MultipleItemMessageConvention");
        f.put("CounterPair", "com.connecterra.plctypes.CounterPairMessageConvention");
        f.put("Latch", "com.connecterra.plctypes.LatchMessageConvention");
        i.put("OPC_XML", "com.connecterra.plctypes.OPCXMLTransport");
        i.put("StarThis", "com.connecterra.plctypes.StarThisTransport");
        i.put("ModBus", "com.connecterra.plctypes.ModBusTransport");
        i.put("GPIO_old", "com.connecterra.plctypes.GPIOTransport");
        i.put("GPIO", "com.connecterra.plctypes.ReaderTransport");
        i.put("Reader", "com.connecterra.plctypes.ReaderTransport");
        i.put("BEA1PLC", "com.bea.rfid.plctypes.BEA1PLC");
        i.put("BEA2PLC", "com.bea.rfid.plctypes.BEA2PLC");
        i.put("BEA3PLC", "com.bea.rfid.plctypes.BEA3PLC");
        this.c = threadPoolScheduler;
        this.b = alarmClock;
        this.c.setThreadCount(0);
        ConfigValidationException configValidationException = new ConfigValidationException();
        try {
            this.c(rawConfig);
        }
        catch (ConfigValidationException configValidationException2) {
            configValidationException.addAll(configValidationException2.getExceptions());
        }
        try {
            this.b(rawConfig);
        }
        catch (ConfigValidationException configValidationException3) {
            configValidationException.addAll(configValidationException3.getExceptions());
        }
        try {
            this.initializeMessages(rawConfig);
        }
        catch (ConfigValidationException configValidationException4) {
            configValidationException.addAll(configValidationException4.getExceptions());
        }
        configValidationException.maybeThrow();
    }

    public Scheduler getScheduler() {
        return this.c;
    }

    public AlarmClock getAlarmClock() {
        return this.b;
    }

    public PLCOutboundMessage getOutboundMessage(String string) throws PLCException {
        if (!this.h.containsKey(string)) {
            throw new PLCException(I18N.get("No outbound message {0} defined.", string));
        }
        return (PLCOutboundMessage)this.h.get(string);
    }

    public PLCInboundMessage getInboundMessage(String string) throws PLCException {
        if (!this.e.containsKey(string)) {
            throw new PLCException(I18N.get("No inbound message {0} defined.", string));
        }
        return (PLCInboundMessage)this.e.get(string);
    }

    public PLCTransport getTransport(String string) throws PLCException {
        if (!this.j.containsKey(string)) {
            throw new PLCException(I18N.get("No transport {0} defined.", string));
        }
        return (PLCTransport)this.j.get(string);
    }

    public void initializeMessages(RawConfig rawConfig) throws ConfigValidationException {
        PLCMessageConvention pLCMessageConvention;
        String string;
        RawConfig rawConfig2;
        String string2;
        ConfigValidationException configValidationException = new ConfigValidationException();
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("plcMessageConvention");
        Set set = rawConfig.getInstanceNames("inboundMessage");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                string2 = (String)iterator.next();
                rawConfig2 = rawConfig.getInstance("inboundMessage", string2);
                validatedConfig.reset();
                validatedConfig.readFrom(rawConfig2);
                string = validatedConfig.getStringValue("plcMessageConvention");
                if (!this.d.containsKey(string)) {
                    configValidationException.add(new ConfigItemException(I18N.get("Message convention {0} for message {1} is not defined.", (Object)string, (Object)string2)));
                    continue;
                }
                pLCMessageConvention = (PLCMessageConvention)this.d.get(string);
                this.e.put(string2, pLCMessageConvention.createInboundMessage(string2, rawConfig2));
            }
            catch (ConfigValidationException configValidationException2) {
                configValidationException.addAll(configValidationException2.getExceptions());
            }
        }
        set = rawConfig.getInstanceNames("outboundMessage");
        iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                string2 = (String)iterator.next();
                rawConfig2 = rawConfig.getInstance("outboundMessage", string2);
                validatedConfig.reset();
                validatedConfig.readFrom(rawConfig2);
                string = validatedConfig.getStringValue("plcMessageConvention");
                if (!this.d.containsKey(string)) {
                    configValidationException.add(new ConfigItemException(I18N.get("Message convention {0} for message {1} is not defined.", (Object)string, (Object)string2)));
                    continue;
                }
                pLCMessageConvention = (PLCMessageConvention)this.d.get(string);
                this.h.put(string2, pLCMessageConvention.createOutboundMessage(string, rawConfig2));
            }
            catch (ConfigValidationException configValidationException3) {
                configValidationException.addAll(configValidationException3.getExceptions());
            }
        }
        configValidationException.maybeThrow();
    }

    private void b(RawConfig rawConfig) throws ConfigValidationException, PLCException, IOException {
        ConfigValidationException configValidationException = new ConfigValidationException();
        Set set = rawConfig.getInstanceNames("plcMessageConvention");
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("metaName");
        validatedConfig.addStringItem("plcTransport");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                RawConfig rawConfig2 = rawConfig.getInstance("plcMessageConvention", string);
                validatedConfig.reset();
                validatedConfig.readFrom(rawConfig2);
                String string2 = validatedConfig.getStringValue("metaName");
                String string3 = validatedConfig.getStringValue("plcTransport");
                PLCTransport pLCTransport = (PLCTransport)this.j.get(string3);
                if (pLCTransport == null) {
                    configValidationException.add(new ConfigItemException(I18N.get("Transport {0} for message convention {1} is not defined", (Object)string3, (Object)string)));
                }
                PLCMessageConvention pLCMessageConvention = null;
                if (!f.containsKey(string2)) {
                    configValidationException.add(new ConfigItemException(I18N.get("Invalid metaName: {0}", string2)));
                } else {
                    pLCMessageConvention = (PLCMessageConvention)this.b((String)f.get(string2));
                }
                if (pLCTransport == null || pLCMessageConvention == null) continue;
                pLCMessageConvention.initialize(string, pLCTransport, rawConfig2);
                this.d.put(string, pLCMessageConvention);
            }
            catch (ConfigItemException configItemException) {
                configValidationException.add(configItemException);
            }
            catch (ConfigValidationException configValidationException2) {
                configValidationException.addAll(configValidationException2.getExceptions());
            }
        }
        configValidationException.maybeThrow();
    }

    private void c(RawConfig rawConfig) throws ConfigValidationException {
        ConfigValidationException configValidationException = new ConfigValidationException();
        Set set = rawConfig.getInstanceNames("plcTransport");
        ValidatedConfig validatedConfig = new ValidatedConfig();
        validatedConfig.addStringItem("metaName");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                String string = (String)iterator.next();
                RawConfig rawConfig2 = rawConfig.getInstance("plcTransport", string);
                validatedConfig.reset();
                validatedConfig.readFrom(rawConfig2);
                String string2 = validatedConfig.getStringValue("metaName");
                if (!i.containsKey(string2)) {
                    throw new ConfigItemException(I18N.get("Invalid meta name: {0}", string2), configValidationException);
                }
                PLCTransport pLCTransport = (PLCTransport)this.b((String)i.get(string2));
                pLCTransport.initialize(this, string, rawConfig2);
                this.j.put(string, pLCTransport);
            }
            catch (ConfigItemException configItemException) {
                configValidationException.add(configItemException);
            }
            catch (ConfigValidationException configValidationException2) {
                configValidationException.addAll(configValidationException2.getExceptions());
            }
        }
        configValidationException.maybeThrow();
    }

    private Object b(String string) throws ConfigItemException {
        try {
            return Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigItemException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigItemException(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigItemException(instantiationException.getMessage(), instantiationException);
        }
    }
}

