/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plc.cli;

import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCInboundMessage;
import com.connecterra.plc.PLCInboundMessageListener;
import com.connecterra.plc.PLCOutboundMessage;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.ListOfOne;
import com.connecterra.util.PropsRawConfig;
import com.connecterra.util.event.AlarmClock;
import com.connecterra.util.event.ThreadPoolScheduler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PLCCLI {
    private ThreadPoolScheduler c;
    private AlarmClock b;
    private PLCFactory d;

    public static void main(String[] stringArray) throws Exception {
        new PLCCLI(stringArray[0]).start();
    }

    public PLCCLI(String string) throws ConfigValidationException, PLCException, IOException {
        PropsRawConfig propsRawConfig = new PropsRawConfig(string, "");
        this.c = new ThreadPoolScheduler("PLC");
        this.b = new AlarmClock();
        this.b.start();
        this.d = new PLCFactory(propsRawConfig, this.c, this.b);
    }

    public void start() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Type commands now.  C-d to exit.");
        while (true) {
            System.out.print("> ");
            System.out.flush();
            try {
                String[] stringArray;
                String string = bufferedReader.readLine();
                if (string != null && !this.b(stringArray = string.split("[ \t]+"))) continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Error: Too few arguments");
                continue;
            }
            catch (PLCException pLCException) {
                System.out.println(pLCException.getMessage());
                continue;
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                continue;
            }
            break;
        }
        System.out.println("Shutting down...\n");
        this.c.shutdown();
        this.b.shutdown();
        try {
            this.c.waitForShutdown(2000L);
            this.b.waitForShutdown(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.c.terminate();
        this.b.terminate();
    }

    private boolean b(String[] stringArray) throws IOException, PLCException {
        if (stringArray[0].equals("quit")) {
            return true;
        }
        if (stringArray[0].equals("read")) {
            PLCTransport pLCTransport = this.d.getTransport(stringArray[1]);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 2; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            List list = pLCTransport.read(arrayList);
            Iterator iterator = arrayList.iterator();
            Iterator iterator2 = list.iterator();
            while (iterator.hasNext()) {
                System.out.println("Read item \"" + iterator.next() + "\" = " + iterator2.next());
            }
        } else if (stringArray[0].equals("write")) {
            PLCTransport pLCTransport = this.d.getTransport(stringArray[1]);
            String string = stringArray[2];
            String string2 = stringArray[3];
            String string3 = stringArray[4];
            pLCTransport.write(new ListOfOne(string), new ListOfOne(PLCCLI.b(string2, string3)));
            System.out.println("Write complete");
        } else if (stringArray[0].equals("invoke")) {
            PLCOutboundMessage pLCOutboundMessage = this.d.getOutboundMessage(stringArray[1]);
            pLCOutboundMessage.invoke(PLCCLI.b(stringArray, 2, stringArray.length));
            System.out.println("invoke complete");
        } else if (stringArray[0].equals("listen")) {
            PLCInboundMessage pLCInboundMessage = this.d.getInboundMessage(stringArray[1]);
            String string = stringArray[1];
            pLCInboundMessage.addListener(new PLCInboundMessageListener(){

                public void receiveMessage(String string, List list) {
                    System.out.print("received message " + string);
                    if (list != null) {
                        System.out.print(" with data " + list);
                    }
                    System.out.println();
                }
            });
        } else if (stringArray[0].equals("nolisten")) {
            PLCInboundMessage pLCInboundMessage = this.d.getInboundMessage(stringArray[1]);
            pLCInboundMessage.removeAllListeners();
        } else if (stringArray[0].equals("outtimetest")) {
            int n = Integer.parseInt(stringArray[1]);
            PLCOutboundMessage pLCOutboundMessage = this.d.getOutboundMessage(stringArray[2]);
            List list = PLCCLI.b(stringArray, 3, stringArray.length);
            long l = 0L;
            for (int i = 0; i < n; ++i) {
                long l2 = System.currentTimeMillis();
                pLCOutboundMessage.invoke(list);
                l += System.currentTimeMillis() - l2;
            }
            System.out.println("Average message time = " + (double)l / (double)n);
        } else if (!stringArray[0].equals("")) {
            System.out.println("Unknown command " + stringArray[0]);
        }
        return false;
    }

    private static List b(String[] stringArray, int n, int n2) throws PLCException {
        int n3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n3 = n; n3 < n2; n3 += 2) {
            arrayList.add(PLCCLI.b(stringArray[n3], stringArray[n3 + 1]));
        }
        if (n3 < n2) {
            throw new IndexOutOfBoundsException();
        }
        return arrayList;
    }

    private static Object b(String string, String string2) throws PLCException {
        ArrayList<Object> arrayList;
        if (string.endsWith("[]")) {
            String string3 = string.substring(0, string.length() - 2);
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList2.add(PLCCLI.b(string3, stringArray[i]));
            }
            arrayList = arrayList2;
        } else if (string.equals("Short")) {
            arrayList = new Short(string2);
        } else if (string.equals("Integer")) {
            arrayList = new Integer(string2);
        } else if (string.equals("String")) {
            arrayList = string2;
        } else if (string.equals("Boolean")) {
            arrayList = new Boolean(string2);
        } else {
            throw new PLCException("java class " + string + " is not supported.  Use one of Short, Integer, String, Boolean");
        }
        return arrayList;
    }
}

