/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.event.AbstractEventProcessor;
import com.connecterra.util.event.Event;
import com.connecterra.util.event.EventReceiver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPLCTransport
extends AbstractEventProcessor
implements PLCTransport {
    Map k = new HashMap();
    boolean j = true;
    protected static Logger s_log = null;

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        super.initialize(string, pLCFactory.getScheduler(), 100, pLCFactory.getAlarmClock());
        this.initFromRC(rawConfig);
        s_log = Logger.getLogger("com.connecterra.plctypes.PLCPollTransport");
    }

    public void initialize(PLCFactory pLCFactory, EventReceiver eventReceiver, RawConfig rawConfig) throws ConfigValidationException {
        super.initialize(eventReceiver, pLCFactory.getAlarmClock());
        this.initFromRC(rawConfig);
        s_log = Logger.getLogger("com.connecterra.plctypes.PLCPollTransport");
    }

    protected abstract void initFromRC(RawConfig var1) throws ConfigValidationException;

    protected abstract void addIVListener(String var1, PLCListener var2, ItemValue var3) throws IOException, PLCException;

    public void removeListener(final String string, final PLCListener pLCListener) {
        this.doASAP(new Event(){

            public void handle() {
                WatchedItem watchedItem = (WatchedItem)AbstractPLCTransport.this.k.get(string);
                if (watchedItem == null) {
                    return;
                }
                if (s_log.isLoggable(Level.FINER)) {
                    s_log.finer("removing listener " + pLCListener + " from " + string);
                }
                watchedItem.removeListener(pLCListener);
                if (watchedItem.listenerCount() == 0) {
                    AbstractPLCTransport.this.k.remove(string);
                }
            }
        });
    }

    public void removeAllListeners(final String string) {
        this.doASAP(new Event(){

            public void handle() {
                WatchedItem watchedItem = (WatchedItem)AbstractPLCTransport.this.k.get(string);
                if (watchedItem == null) {
                    return;
                }
                if (s_log.isLoggable(Level.FINER)) {
                    s_log.finer("removing all listeners from " + string);
                }
                watchedItem.removeAllListeners();
                AbstractPLCTransport.this.k.remove(string);
            }
        });
    }

    protected void connect() throws IOException, PLCException {
    }

    protected List getReadings(List list) throws IOException, PLCException {
        int n = list.size();
        s_log.finest("Reading itemName count=" + n);
        List list2 = this.read(list);
        ArrayList<DefaultItemValue> arrayList = new ArrayList<DefaultItemValue>(list2.size());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new DefaultItemValue(iterator.next()));
        }
        return arrayList;
    }

    public void addListener(String string, PLCListener pLCListener, Object object) throws IOException, PLCException {
        this.connect();
        DefaultItemValue defaultItemValue = null;
        if (object != null) {
            defaultItemValue = new DefaultItemValue(object);
        }
        this.addIVListener(string, pLCListener, defaultItemValue);
    }

    protected static class WatchedItem {
        private String e;
        private Set d = new HashSet();
        private Set b = new HashSet();
        private ItemValue c;

        public WatchedItem(String string) {
            this.e = string;
        }

        public void addListener(PLCListener pLCListener, ItemValue itemValue) {
            this.d.add(pLCListener);
            if (this.c == null || this.c.equals(itemValue) || pLCListener.getExtraItems() != null && !pLCListener.getExtraItems().isEmpty()) {
                this.b.add(pLCListener);
                return;
            }
            Object object = null;
            try {
                object = this.c.getValue();
            }
            catch (PLCException pLCException) {
                s_log.log(Level.WARNING, I18N.get("Updating tag {0}: {1}", (Object)this.e, (Object)pLCException.getMessage()), pLCException);
                return;
            }
            pLCListener.itemChanged(this.e, object, Collections.EMPTY_LIST);
        }

        public void removeListener(PLCListener pLCListener) {
            this.d.remove(pLCListener);
        }

        public void removeAllListeners() {
            this.d.clear();
        }

        public int listenerCount() {
            return this.d.size();
        }

        public void addExtraItemsTo(Collection collection) {
            Iterator iterator = this.d.iterator();
            while (iterator.hasNext()) {
                List list = ((PLCListener)iterator.next()).getExtraItems();
                if (list == null) continue;
                collection.addAll(list);
            }
        }

        public void update(ItemValue itemValue, Map map) {
            Object object;
            Iterator iterator;
            if (itemValue.equals(this.c)) {
                iterator = this.b.iterator();
                if (!iterator.hasNext()) {
                    return;
                }
            } else {
                iterator = this.d.iterator();
            }
            try {
                object = itemValue.getValue();
            }
            catch (PLCException pLCException) {
                s_log.log(Level.WARNING, I18N.get("Updating item name {0}: {1}", (Object)this.e, (Object)pLCException.getMessage()), pLCException);
                return;
            }
            while (iterator.hasNext()) {
                PLCListener pLCListener = (PLCListener)iterator.next();
                List list = pLCListener.getExtraItems();
                ArrayList arrayList = new ArrayList();
                if (list != null) {
                    Iterator iterator2 = list.iterator();
                    while (iterator2.hasNext()) {
                        arrayList.add(map.get(iterator2.next()));
                    }
                }
                pLCListener.itemChanged(this.e, object, arrayList);
            }
            this.b.clear();
            this.c = itemValue;
        }
    }

    protected static class DefaultItemValue
    extends ItemValue {
        public Object m_value;

        public DefaultItemValue(Object object) {
            this.m_value = object;
        }

        public Object getValue() throws PLCException {
            return this.m_value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof DefaultItemValue)) {
                return false;
            }
            if (this.m_value == null) {
                return ((DefaultItemValue)object).m_value == null;
            }
            return this.m_value.equals(((DefaultItemValue)object).m_value);
        }

        public int hashCode() {
            return this.m_value.hashCode() + 1228;
        }
    }

    protected static abstract class ItemValue {
        protected ItemValue() {
        }

        public abstract Object getValue() throws PLCException;
    }
}

