/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.plctypes;

import com.connecterra.i18n.I18N;
import com.connecterra.plc.PLCException;
import com.connecterra.plc.PLCFactory;
import com.connecterra.plc.PLCListener;
import com.connecterra.plc.PLCTransport;
import com.connecterra.plctypes.AbstractPLCTransport;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.RawConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GPIOTransport
implements PLCTransport,
Observer {
    public static final String GPIO_SOURCE = "GPIOSource";
    public static final String LISTENITEMS = "ListenItems";
    public static final String LEFTSTACKLIGHT = "LeftStackLight";
    public static final String RIGHTSTACKLIGHT = "RightStackLight";
    private Logger rb = Logger.getLogger("com.connecterra.plctypes.PLCGPIOTransport");
    private static final int nb = 8;
    private String pb = null;
    private int ob;
    private int tb;
    private Map sb = new HashMap();
    private PLCListener qb;

    public void initialize(PLCFactory pLCFactory, String string, RawConfig rawConfig) throws ConfigValidationException {
        this.pb = string;
        this.rb.fine(I18N.get("Initializing GPIOTransport {0}", this.pb));
    }

    public void addListener(String string, PLCListener pLCListener, Object object) throws IOException, PLCException {
        Object object2;
        int n;
        block9: {
            if (string == null || pLCListener == null) {
                throw new PLCException(I18N.get("PLC listener or Item name is empty."));
            }
            if (string.equals(GPIO_SOURCE)) {
                this.qb = pLCListener;
                return;
            }
            String string2 = string.toUpperCase();
            String string3 = null;
            n = -1;
            try {
                if (string2.startsWith("INPUT")) {
                    object2 = string.substring(5);
                    n = Integer.valueOf((String)object2);
                    string3 = "INPUT";
                    break block9;
                }
                if (string2.startsWith("OUTPUT")) {
                    object2 = string.substring(6);
                    n = Integer.getInteger((String)object2);
                    string3 = "OUTPUT";
                    break block9;
                }
                throw new PLCException(I18N.get("Incorrect item name:{0}", string));
            }
            catch (NumberFormatException numberFormatException) {
                throw new PLCException(I18N.get("Incorrect item name:{0}", string));
            }
        }
        if (n > 8) {
            throw new PLCException(I18N.get("Item index too large:{0}", string));
        }
        object2 = (AbstractPLCTransport.WatchedItem)this.sb.get(string);
        if (object2 == null) {
            object2 = new AbstractPLCTransport.WatchedItem(string);
            this.sb.put(string, object2);
        }
        GPIOItemValue gPIOItemValue = null;
        if (object != null) {
            gPIOItemValue = new GPIOItemValue(object);
        }
        ((AbstractPLCTransport.WatchedItem)object2).addListener(pLCListener, gPIOItemValue);
        this.f();
    }

    public void removeAllListeners(String string) throws IOException, PLCException {
        AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)this.sb.get(string);
        if (watchedItem == null) {
            return;
        }
        if (this.rb.isLoggable(Level.FINER)) {
            this.rb.finer(I18N.get("removing all listeners from {0}", string));
        }
        watchedItem.removeAllListeners();
        this.sb.remove(string);
        this.f();
    }

    public void removeListener(String string, PLCListener pLCListener) throws IOException, PLCException {
        AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)this.sb.get(string);
        if (watchedItem == null) {
            return;
        }
        if (this.rb.isLoggable(Level.FINER)) {
            this.rb.finer(I18N.get("removing listener {0} from {1}", (Object)pLCListener, (Object)string));
        }
        watchedItem.removeListener(pLCListener);
        if (watchedItem.listenerCount() == 0) {
            this.sb.remove(string);
        }
        this.f();
    }

    void f() {
        Object object;
        int n = this.sb.size();
        int n2 = 0;
        if (n != 0) {
            object = this.sb.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)this.sb.get(string);
                n2 += watchedItem.listenerCount();
            }
        }
        if (n2 != 0 && n2 != 1) {
            return;
        }
        object = new Integer(n2);
        if (this.qb != null) {
            this.qb.itemChanged(LISTENITEMS, object, null);
        }
    }

    public boolean isAlive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List read(List list) throws IOException, PLCException {
        List list2;
        GPIOTransport gPIOTransport = this;
        synchronized (gPIOTransport) {
            list2 = this.b(list);
        }
        return list2;
    }

    public void write(List list, List list2) throws IOException, PLCException {
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException(I18N.get("itemNames and values must have same size"));
        }
        if (list.size() == 0) {
            return;
        }
        if (list.size() > 1) {
            throw new PLCException(I18N.get("only one item at a time may be written"));
        }
        String string = (String)list.get(0);
        if (this.qb == null) {
            throw new PLCException(I18N.get("Writing target not recognized: {0}", string));
        }
        if (list2.get(0) != null) {
            this.qb.itemChanged(string, list2.get(0), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable observable, Object object) {
        List list;
        ArrayList arrayList;
        this.rb.finer("Received GPIO status!");
        GPIOStatus gPIOStatus = (GPIOStatus)object;
        Object object2 = this;
        synchronized (object2) {
            this.ob = gPIOStatus.getInPortStatus();
            this.tb = gPIOStatus.getOutPortStatus();
            this.rb.finer("Input=0X" + Integer.toHexString(this.ob) + " Output=0x" + Integer.toHexString(this.tb));
            ArrayList arrayList2 = new ArrayList(this.sb.keySet());
            arrayList = new ArrayList(this.sb.values());
            list = this.b(arrayList2);
        }
        object2 = arrayList.iterator();
        Iterator iterator = list.iterator();
        while (object2.hasNext() && iterator.hasNext()) {
            AbstractPLCTransport.WatchedItem watchedItem = (AbstractPLCTransport.WatchedItem)object2.next();
            GPIOItemValue gPIOItemValue = (GPIOItemValue)iterator.next();
            watchedItem.update(gPIOItemValue, null);
        }
    }

    private List b(List list) {
        ArrayList<GPIOItemValue> arrayList = new ArrayList<GPIOItemValue>();
        for (String string : list) {
            String string2;
            String string3 = string.toUpperCase();
            String string4 = null;
            int n = -1;
            if (string3.startsWith("INPUT")) {
                string2 = string3.substring(5);
                n = Integer.valueOf(string2);
                string4 = "INPUT";
            } else {
                string2 = string3.substring(6);
                n = Integer.valueOf(string2);
                string4 = "OUTPUT";
            }
            int n2 = 1 << n;
            boolean bl = false;
            bl = string4 == "INPUT" ? (this.ob & n2) != 0 : (this.tb & n2) != 0;
            this.rb.finer(string4 + "=" + Boolean.toString(bl));
            GPIOItemValue gPIOItemValue = new GPIOItemValue(new Boolean(bl));
            arrayList.add(gPIOItemValue);
        }
        return arrayList;
    }

    public static class GPIOStatus {
        private int c;
        private int b;

        public GPIOStatus(int n, int n2) {
            this.c = n;
            this.b = n2;
        }

        public int getInPortStatus() {
            return this.c;
        }

        public void setInPortStatus(int n) {
            this.c = n;
        }

        public int getOutPortStatus() {
            return this.b;
        }

        public void setOutPortStatus(int n) {
            this.b = n;
        }
    }

    private class GPIOItemValue
    extends AbstractPLCTransport.ItemValue {
        public Object m_value;

        public GPIOItemValue(Object object) {
            this.m_value = object;
        }

        public Object getValue() throws PLCException {
            return this.m_value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof GPIOItemValue)) {
                return false;
            }
            if (this.m_value == null) {
                return ((GPIOItemValue)object).m_value == null;
            }
            return this.m_value.equals(((GPIOItemValue)object).m_value);
        }

        public int hashCode() {
            return this.m_value.hashCode() + 1288;
        }
    }

    public static interface InOut {
        public static final String inputPort = "INPUT";
        public static final String outputPort = "OUTPUT";
    }
}

