/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.Queue;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CircularArrayList
extends AbstractList
implements List,
Collection,
Queue {
    private int c = 0;
    private int d = 0;
    private Object[] b;

    public CircularArrayList() {
        this(16);
    }

    public CircularArrayList(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.b = new Object[n];
    }

    public CircularArrayList(Collection collection) {
        this(Math.max(16, collection.size()));
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public Object get(int n) {
        if (n < 0 || n >= this.d) {
            throw new IndexOutOfBoundsException();
        }
        return this.b[(this.c + n) % this.b.length];
    }

    public Object set(int n, Object object) {
        if (n < 0 || n >= this.d) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = (this.c + n) % this.b.length;
        Object object2 = this.b[n2];
        this.b[n2] = object;
        return object2;
    }

    public void add(int n, Object object) {
        if (n < 0 || n > this.d) {
            throw new IndexOutOfBoundsException();
        }
        this.b(this.d + 1);
        for (int i = this.d - 1; i >= n; --i) {
            int n2 = (this.c + i) % this.b.length;
            int n3 = (this.c + i + 1) % this.b.length;
            this.b[n3] = this.b[n2];
        }
        this.b[(this.c + n) % this.b.length] = object;
        ++this.d;
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.d) {
            throw new IndexOutOfBoundsException();
        }
        if (n == 0) {
            return this.removeFirst();
        }
        Object object = this.b[(this.c + n) % this.b.length];
        for (int i = n + 1; i < this.d; ++i) {
            int n2 = (this.c + i) % this.b.length;
            int n3 = (this.c + i - 1) % this.b.length;
            this.b[n3] = this.b[n2];
        }
        this.b[(this.c + this.d - 1) % this.b.length] = null;
        --this.d;
        return object;
    }

    public void clear() {
        Arrays.fill(this.b, null);
        this.c = 0;
        this.d = 0;
    }

    protected void removeRange(int n, int n2) {
        if (n < 0 || n >= this.d || n2 < 0 || n2 >= this.d) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (n3 == 0) {
            return;
        }
        for (int i = n2 + 1; i < this.d; ++i) {
            int n4 = (this.c + i) % this.b.length;
            int n5 = (this.c + i - n3) % this.b.length;
            this.b[n5] = this.b[n4];
            this.b[n4] = null;
        }
        this.d -= n3;
    }

    public void addFirst(Object object) {
        this.b(this.d + 1);
        this.b[(this.c - 1 + this.b.length) % this.b.length] = object;
        --this.c;
        if (this.c < 0) {
            this.c += this.b.length;
        }
        ++this.d;
    }

    public void addLast(Object object) {
        this.add(object);
    }

    public Object getFirst() {
        if (this.d == 0) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    public Object getLast() {
        if (this.d == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this.d - 1);
    }

    public Object removeFirst() {
        if (this.d == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.b[this.c];
        this.b[this.c] = null;
        ++this.c;
        if (this.c >= this.b.length) {
            this.c -= this.b.length;
        }
        --this.d;
        return object;
    }

    public Object removeLast() {
        if (this.d == 0) {
            throw new NoSuchElementException();
        }
        int n = (this.c + this.d - 1) % this.b.length;
        Object object = this.b[n];
        this.b[n] = null;
        --this.d;
        return object;
    }

    public int size() {
        return this.d;
    }

    private void b(int n) {
        int n2 = this.b.length;
        if (n > n2) {
            Object[] objectArray = new Object[n2 * 2];
            int n3 = n2 - this.c;
            System.arraycopy(this.b, this.c, objectArray, 0, n3);
            System.arraycopy(this.b, 0, objectArray, n3, this.c);
            this.b = objectArray;
            this.c = 0;
        }
    }
}

