/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.Controllable;
import java.util.Collection;
import java.util.Iterator;

public class ControllableUtil {
    public static void shutdown(Collection collection) {
        for (Controllable controllable : collection) {
            if (controllable == null) continue;
            controllable.shutdown();
        }
    }

    public static void waitForShutdown(Collection collection, long l) throws InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l2 - System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && l3 > 0L) {
            Controllable controllable = (Controllable)iterator.next();
            if (controllable != null) {
                controllable.waitForShutdown(l3);
            }
            l3 = l2 - System.currentTimeMillis();
        }
    }

    public static void terminate(Collection collection) {
        for (Controllable controllable : collection) {
            if (controllable == null) continue;
            controllable.terminate();
        }
    }

    public static void waitForTermination(Collection collection, long l) throws InterruptedException {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l2 - System.currentTimeMillis();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && l3 > 0L) {
            Controllable controllable = (Controllable)iterator.next();
            if (controllable != null) {
                controllable.waitForTermination(l3);
            }
            l3 = l2 - System.currentTimeMillis();
        }
    }
}

