/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ByteOrder;
import com.connecterra.util.IntegerBytes;

public class ConvertEPC2ByteArray {
    public static byte[] convertEPC64(long l, ByteOrder byteOrder) {
        byte[] byArray = new byte[8];
        IntegerBytes.longToBytes(l, byArray, 0, byteOrder);
        return byArray;
    }

    public static byte[] convertEPC96(long l, long l2, ByteOrder byteOrder) {
        byte[] byArray = new byte[12];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        IntegerBytes.longToBytes(l2, byArray3, 0, byteOrder);
        IntegerBytes.longToBytes(l, byArray2, 0, byteOrder);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            System.arraycopy(byArray2, 4, byArray, 0, 4);
            System.arraycopy(byArray3, 0, byArray, 4, 8);
        } else {
            System.arraycopy(byArray3, 0, byArray, 0, 8);
            System.arraycopy(byArray2, 0, byArray, 8, 4);
        }
        return byArray;
    }

    public static byte[] convertEPC128(long l, long l2, ByteOrder byteOrder) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        IntegerBytes.longToBytes(l2, byArray3, 0, byteOrder);
        IntegerBytes.longToBytes(l, byArray2, 0, byteOrder);
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            System.arraycopy(byArray2, 0, byArray, 0, 8);
            System.arraycopy(byArray3, 0, byArray, 8, 8);
        } else {
            System.arraycopy(byArray3, 0, byArray, 0, 8);
            System.arraycopy(byArray2, 0, byArray, 8, 8);
        }
        return byArray;
    }

    public static long makeEPC64(byte[] byArray, ByteOrder byteOrder) throws NumberFormatException {
        if (byArray.length != 4 && byArray.length != 8) {
            throw new NumberFormatException("Byte array length is neither 4 nor 8 bytes!");
        }
        long l = byArray.length == 4 ? (long)IntegerBytes.bytesToInt(byArray, 0, byteOrder) : IntegerBytes.bytesToLong(byArray, 0, byteOrder);
        return l;
    }

    public static long[] makeEPC96(byte[] byArray, ByteOrder byteOrder) throws NumberFormatException {
        if (byArray.length != 12) {
            throw new NumberFormatException("Byte array length is not 96 bits!");
        }
        long[] lArray = new long[2];
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = 0;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            System.arraycopy(byArray, 0, byArray2, 4, 4);
            System.arraycopy(byArray, 4, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, 8);
            System.arraycopy(byArray, 8, byArray2, 0, 4);
        }
        lArray[0] = IntegerBytes.bytesToLong(byArray2, 0, byteOrder);
        lArray[1] = IntegerBytes.bytesToLong(byArray3, 0, byteOrder);
        return lArray;
    }

    public static long[] makeEPC128(byte[] byArray, ByteOrder byteOrder, long l, long l2) throws NumberFormatException {
        if (byArray.length != 16) {
            throw new NumberFormatException("Byte array length is not 128 bits!");
        }
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        long[] lArray = new long[2];
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            System.arraycopy(byArray, 0, byArray2, 8, 8);
            System.arraycopy(byArray, 8, byArray3, 0, 8);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, 8);
            System.arraycopy(byArray, 8, byArray2, 0, 8);
        }
        lArray[0] = IntegerBytes.bytesToLong(byArray2, 0, byteOrder);
        lArray[1] = IntegerBytes.bytesToLong(byArray3, 0, byteOrder);
        return lArray;
    }
}

