/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ByteOrder;

public class IntegerBytes {
    private IntegerBytes() {
    }

    public static short bytesToShort(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)(((byArray[0 + n] & 0xFF) << 8) + (byArray[1 + n] & 0xFF));
        }
        return (short)(((byArray[1 + n] & 0xFF) << 8) + (byArray[0 + n] & 0xFF));
    }

    public static short bytesToShort(byte[] byArray, int n) {
        return IntegerBytes.bytesToShort(byArray, n, ByteOrder.BIG_ENDIAN);
    }

    public static int bytesToInt(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return ((byArray[0 + n] & 0xFF) << 24) + ((byArray[1 + n] & 0xFF) << 16) + ((byArray[2 + n] & 0xFF) << 8) + (byArray[3 + n] & 0xFF);
        }
        return ((byArray[3 + n] & 0xFF) << 24) + ((byArray[2 + n] & 0xFF) << 16) + ((byArray[1 + n] & 0xFF) << 8) + (byArray[0 + n] & 0xFF);
    }

    public static int bytesToInt(byte[] byArray, int n) {
        return IntegerBytes.bytesToInt(byArray, n, ByteOrder.BIG_ENDIAN);
    }

    public static long bytesToLong(byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return (((long)byArray[0 + n] & 0xFFL) << 56) + (((long)byArray[1 + n] & 0xFFL) << 48) + (((long)byArray[2 + n] & 0xFFL) << 40) + (((long)byArray[3 + n] & 0xFFL) << 32) + (((long)byArray[4 + n] & 0xFFL) << 24) + (((long)byArray[5 + n] & 0xFFL) << 16) + (((long)byArray[6 + n] & 0xFFL) << 8) + ((long)byArray[7 + n] & 0xFFL);
        }
        return (((long)byArray[7 + n] & 0xFFL) << 56) + (((long)byArray[6 + n] & 0xFFL) << 48) + (((long)byArray[5 + n] & 0xFFL) << 40) + (((long)byArray[4 + n] & 0xFFL) << 32) + (((long)byArray[3 + n] & 0xFFL) << 24) + (((long)byArray[2 + n] & 0xFFL) << 16) + (((long)byArray[1 + n] & 0xFFL) << 8) + ((long)byArray[0 + n] & 0xFFL);
    }

    public static long bytesToLong(byte[] byArray, int n) {
        return IntegerBytes.bytesToLong(byArray, n, ByteOrder.BIG_ENDIAN);
    }

    public static void shortToBytes(short s, byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0 + n] = (byte)(s >>> 8);
            byArray[1 + n] = (byte)s;
        } else {
            byArray[1 + n] = (byte)(s >>> 8);
            byArray[0 + n] = (byte)s;
        }
    }

    public static void shortToBytes(short s, byte[] byArray, int n) {
        IntegerBytes.shortToBytes(s, byArray, n, ByteOrder.BIG_ENDIAN);
    }

    public static void intToBytes(int n, byte[] byArray, int n2, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0 + n2] = (byte)(n >>> 24);
            byArray[1 + n2] = (byte)(n >>> 16);
            byArray[2 + n2] = (byte)(n >>> 8);
            byArray[3 + n2] = (byte)n;
        } else {
            byArray[3 + n2] = (byte)(n >>> 24);
            byArray[2 + n2] = (byte)(n >>> 16);
            byArray[1 + n2] = (byte)(n >>> 8);
            byArray[0 + n2] = (byte)n;
        }
    }

    public static void intToBytes(int n, byte[] byArray, int n2) {
        IntegerBytes.intToBytes(n, byArray, n2, ByteOrder.BIG_ENDIAN);
    }

    public static void longToBytes(long l, byte[] byArray, int n, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            byArray[0 + n] = (byte)(l >>> 56);
            byArray[1 + n] = (byte)(l >>> 48);
            byArray[2 + n] = (byte)(l >>> 40);
            byArray[3 + n] = (byte)(l >>> 32);
            byArray[4 + n] = (byte)(l >>> 24);
            byArray[5 + n] = (byte)(l >>> 16);
            byArray[6 + n] = (byte)(l >>> 8);
            byArray[7 + n] = (byte)l;
        } else {
            byArray[7 + n] = (byte)(l >>> 56);
            byArray[6 + n] = (byte)(l >>> 48);
            byArray[5 + n] = (byte)(l >>> 40);
            byArray[4 + n] = (byte)(l >>> 32);
            byArray[3 + n] = (byte)(l >>> 24);
            byArray[2 + n] = (byte)(l >>> 16);
            byArray[1 + n] = (byte)(l >>> 8);
            byArray[0 + n] = (byte)l;
        }
    }

    public static void longToBytes(long l, byte[] byArray, int n) {
        IntegerBytes.longToBytes(l, byArray, n, ByteOrder.BIG_ENDIAN);
    }
}

