/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ConfigItemException;
import com.connecterra.util.InvalidItemException;
import com.connecterra.util.SimpleConfigItem;

public class IntegerConfigItem
extends SimpleConfigItem {
    private int h;
    private int g;
    private int f;

    public IntegerConfigItem() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerConfigItem(int n) {
        this(n, Integer.MAX_VALUE);
    }

    public IntegerConfigItem(int n, int n2) {
        this.h = n;
        this.g = n2;
    }

    public void setValue(String string) throws ConfigItemException {
        if (string == null) {
            throw new ConfigItemException("item value cannot be null");
        }
        try {
            this.f = Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigItemException("\"" + string + "\" is not a valid number", numberFormatException);
        }
        if (this.f < this.h || this.f > this.g) {
            throw new ConfigItemException("integer value " + this.f + " is not in the valid range " + this.h + "-" + this.g);
        }
        this.setValid();
    }

    public int intValue() throws InvalidItemException {
        this.checkValid();
        return this.f;
    }
}

