/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ConfigItemException;
import com.connecterra.util.InvalidItemException;
import com.connecterra.util.SimpleConfigItem;

public class LongConfigItem
extends SimpleConfigItem {
    private long l;
    private long k;
    private long j;

    public LongConfigItem() {
        this(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LongConfigItem(long l) {
        this(l, Long.MAX_VALUE);
    }

    public LongConfigItem(long l, long l2) {
        this.l = l;
        this.k = l2;
    }

    public void setValue(String string) throws ConfigItemException {
        if (string == null) {
            throw new ConfigItemException("item value cannot be null");
        }
        try {
            this.j = Long.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigItemException("\"" + string + "\" is not a valid number", numberFormatException);
        }
        if (this.j < this.l || this.j > this.k) {
            throw new ConfigItemException("long value " + this.j + " is not in the valid range " + this.l + "-" + this.k);
        }
        this.setValid();
    }

    public long longValue() throws InvalidItemException {
        this.checkValid();
        return this.j;
    }
}

