/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ConfigItemException;
import com.connecterra.util.InvalidItemException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.RelativeConfigItem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLConfigItem
extends RelativeConfigItem {
    private URL s = null;
    private RelativeConfigItem.Resolve t = RelativeConfigItem.Resolve.Soft;

    public URLConfigItem() {
    }

    public URLConfigItem(RelativeConfigItem.Resolve resolve) {
        this.t = resolve;
    }

    protected void setValid() {
        this.m_isValid = true;
    }

    protected void checkValid() throws InvalidItemException {
        if (!this.m_isValid) {
            throw new InvalidItemException("attempt to get unset or invalid item");
        }
    }

    public void setValue(String string, RawConfig rawConfig) throws ConfigItemException {
        if (string == null) {
            throw new ConfigItemException("item value cannot be null");
        }
        File file = rawConfig == null ? null : rawConfig.getRelativeRoot();
        try {
            if (URLConfigItem.c(string) || this.t == RelativeConfigItem.Resolve.DoNot) {
                this.s = new URL(string.trim());
            } else {
                if (this.t == RelativeConfigItem.Resolve.Hard && file == null) {
                    throw new ConfigItemException("Cannot resolve relative path - no root provided for " + string);
                }
                this.s = file == null ? new URL(string.trim()) : new URL(file.toURL(), string.trim());
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigItemException("Item " + string + " is not a valid URL", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ConfigItemException("Item " + string + " is not a valid URI", uRISyntaxException);
        }
        this.setValid();
    }

    public void checkDefault(String string) throws ConfigItemException {
        if (string == null) {
            throw new ConfigItemException("default value cannot be null");
        }
        try {
            this.s = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigItemException("invalid default value: " + string, malformedURLException);
        }
    }

    public URL urlValue() throws InvalidItemException {
        this.checkValid();
        return this.s;
    }

    static boolean c(String string) throws URISyntaxException, MalformedURLException {
        new URL(string);
        URI uRI = new URI(string).normalize();
        if (uRI.getScheme().equalsIgnoreCase("file")) {
            return new File(uRI.getSchemeSpecificPart()).isAbsolute();
        }
        return uRI.isAbsolute();
    }
}

