/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.ConfigItemException;
import com.connecterra.util.InvalidItemException;
import com.connecterra.util.RawConfig;
import com.connecterra.util.RelativeConfigItem;
import com.connecterra.util.URLConfigItem;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.StringTokenizer;

public class URLListConfigItem
extends RelativeConfigItem {
    private static final String n = " \n\r";
    protected URL[] m_value = null;
    protected boolean m_emptyPermitted;
    RelativeConfigItem.Resolve m = RelativeConfigItem.Resolve.Soft;

    public URLListConfigItem() {
        this(false);
    }

    public URLListConfigItem(boolean bl) {
        this(bl, RelativeConfigItem.Resolve.Soft);
    }

    public URLListConfigItem(boolean bl, RelativeConfigItem.Resolve resolve) {
        this.m_emptyPermitted = bl;
        this.m = resolve;
    }

    public void setValue(String string) throws ConfigItemException {
        this.setValue(string, null);
    }

    public void setValue(String string, RawConfig rawConfig) throws ConfigItemException {
        File file = rawConfig == null ? null : rawConfig.getRelativeRoot();
        this.splitValue(string, file, false);
        this.setValid();
    }

    public void checkDefault(String string) throws ConfigItemException {
        if (string.equals("")) {
            if (this.m_emptyPermitted) {
                return;
            }
        } else {
            throw new ConfigItemException("default value cannot be null");
        }
        this.splitValue(string, null, true);
    }

    protected void splitValue(String string, File file, boolean bl) throws ConfigItemException {
        if (string == null) {
            throw new ConfigItemException("item value cannot be null");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, n);
        int n = stringTokenizer.countTokens();
        if (n == 0 && !this.m_emptyPermitted) {
            throw new ConfigItemException("the list value must have at least one element");
        }
        this.m_value = new URL[n];
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            try {
                if (bl || URLConfigItem.c(string2) || this.m == RelativeConfigItem.Resolve.DoNot) {
                    this.m_value[i] = new URL(string2);
                    continue;
                }
                if (this.m == RelativeConfigItem.Resolve.Hard && file == null) {
                    throw new ConfigItemException("Cannot resolve relative URL '" + string2 + "' - no root provided");
                }
                if (file == null) {
                    this.m_value[i] = new URL(string2);
                    continue;
                }
                this.m_value[i] = new URL(file.toURL(), string2);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigItemException("item " + string2 + " is not a valid URL ", malformedURLException);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ConfigItemException("item " + string2 + " is not a valid URI ", uRISyntaxException);
            }
        }
    }

    public URL[] urlArrayValue() throws InvalidItemException {
        this.checkValid();
        return this.m_value;
    }
}

