/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util;

import com.connecterra.util.BooleanConfigItem;
import com.connecterra.util.ChoiceConfigItem;
import com.connecterra.util.ConfigItem;
import com.connecterra.util.ConfigItemException;
import com.connecterra.util.ConfigValidationException;
import com.connecterra.util.FileConfigItem;
import com.connecterra.util.IntegerConfigItem;
import com.connecterra.util.InvalidItemException;
import com.connecterra.util.ListConfigItem;
import com.connecterra.util.LongConfigItem;
import com.connecterra.util.RawConfig;
import com.connecterra.util.RelativeConfigItem;
import com.connecterra.util.StringConfigItem;
import com.connecterra.util.URLConfigItem;
import com.connecterra.util.URLListConfigItem;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ValidatedConfig {
    private Map d = new HashMap();
    private Map e = new HashMap();
    private Map c = new HashMap();
    private boolean b = false;

    public void addItem(String string, ConfigItem configItem) {
        this.addItem(new String[]{string}, configItem);
    }

    public void addItem(String string, ConfigItem configItem, String string2) {
        this.addItem(new String[]{string}, configItem, string2);
    }

    public void addItem(String[] stringArray, ConfigItem configItem) {
        if (stringArray == null || configItem == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        Item item = new Item(configItem);
        item.b = stringArray;
        this.d.put(stringArray[0], item);
    }

    public void addItem(String[] stringArray, ConfigItem configItem, String string) {
        if (stringArray == null || configItem == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        Item item = new Item(configItem, string);
        item.b = stringArray;
        this.d.put(stringArray[0], item);
    }

    public void setItemDefault(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        Item item = (Item)this.d.get(string);
        if (item == null) {
            throw new IllegalStateException("item " + string + " has not been added, so cannot set default");
        }
        this.d.put(string, new Item(item.f, string2));
    }

    public void addSubConfig(String string, ValidatedConfig validatedConfig) {
        if (string == null || validatedConfig == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        this.e.put(string, validatedConfig);
    }

    public void addConcept(String string, ValidatedConfig validatedConfig, boolean bl) {
        if (string == null || validatedConfig == null) {
            throw new IllegalArgumentException("Invalid null argument");
        }
        this.c.put(string, new Concept(validatedConfig, bl));
    }

    public void reset() {
        if (!this.b) {
            return;
        }
        for (Object object : this.d.values()) {
            ((Item)object).c();
        }
        for (Object object : this.e.values()) {
            ((ValidatedConfig)object).reset();
        }
        for (Object object : this.c.values()) {
            ((Concept)object).c.reset();
        }
        this.b = false;
    }

    public void readFrom(RawConfig rawConfig) throws ConfigValidationException {
        Object object;
        Object object2;
        Object object3;
        if (this.b) {
            throw new IllegalStateException("ValidatedConfig.readFrom() called twice without reset()");
        }
        ConfigValidationException configValidationException = new ConfigValidationException();
        for (Map.Entry entry : this.d.entrySet()) {
            object3 = (Item)entry.getValue();
            ((Item)object3).c();
            object2 = null;
            object = null;
            for (int i = 0; i < ((Item)object3).b.length && object == null; ++i) {
                object2 = ((Item)object3).b[i];
                object = rawConfig.getRawValue((String)object2);
            }
            try {
                if (object != null) {
                    ((Item)object3).b((String)object, rawConfig);
                    continue;
                }
                if (!((Item)object3).d) {
                    ((Item)object3).b(rawConfig);
                    continue;
                }
                configValidationException.add(new ConfigItemException(rawConfig.getLocation((String)object2) + " not found"));
            }
            catch (ConfigItemException configItemException) {
                configValidationException.add(new ConfigItemException(configItemException.getMessage() + " in " + rawConfig.getLocation((String)object2), configItemException.getCause()));
            }
        }
        for (Map.Entry entry : this.e.entrySet()) {
            object3 = (String)entry.getKey();
            object2 = (ValidatedConfig)entry.getValue();
            try {
                ((ValidatedConfig)object2).readFrom(rawConfig.getSubConfig((String)object3));
            }
            catch (ConfigValidationException configValidationException2) {
                configValidationException.addAll(configValidationException2.getExceptions());
            }
        }
        for (Map.Entry entry : this.c.entrySet()) {
            object3 = (String)entry.getKey();
            object2 = (Concept)entry.getValue();
            object = rawConfig.getInstanceNames((String)object3);
            if (object.size() == 0 && ((Concept)object2).b) {
                configValidationException.add(new ConfigItemException("no instances of the " + (String)object3 + " concept found"));
                continue;
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                try {
                    ((Concept)object2).c.reset();
                    ((Concept)object2).c.readFrom(rawConfig.getInstance((String)object3, string));
                }
                catch (ConfigValidationException configValidationException3) {
                    configValidationException.addAll(configValidationException3.getExceptions());
                }
            }
        }
        configValidationException.maybeThrow("Configuration validation failed:", true);
        this.b = true;
    }

    public boolean isSet(String string) {
        Item item = null;
        item = (Item)this.d.get(string);
        if (item == null) {
            throw new IllegalArgumentException("there is no item named " + string);
        }
        return item.b();
    }

    public boolean isValid(String string) {
        ConfigItem configItem = this.getItem(string);
        return configItem.isValid();
    }

    public ConfigItem getItem(String string) {
        Item item = null;
        item = (Item)this.d.get(string);
        if (item == null) {
            throw new IllegalArgumentException("there is no item named " + string);
        }
        return item.f;
    }

    public void addBooleanItem(String string) {
        this.addItem(string, (ConfigItem)new BooleanConfigItem());
    }

    public void addBooleanItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new BooleanConfigItem(), string2);
    }

    public void addIntegerItem(String string) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem());
    }

    public void addIntegerItem(String string, int n) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem(n));
    }

    public void addIntegerItem(String string, int n, int n2) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem(n, n2));
    }

    public void addIntegerItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem(), string2);
    }

    public void addIntegerItem(String string, int n, String string2) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem(n), string2);
    }

    public void addIntegerItem(String string, int n, int n2, String string2) {
        this.addItem(string, (ConfigItem)new IntegerConfigItem(n, n2), string2);
    }

    public void addLongItem(String string) {
        this.addItem(string, (ConfigItem)new LongConfigItem());
    }

    public void addLongItem(String string, long l) {
        this.addItem(string, (ConfigItem)new LongConfigItem(l));
    }

    public void addLongItem(String string, long l, long l2) {
        this.addItem(string, (ConfigItem)new LongConfigItem(l, l2));
    }

    public void addLongItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new LongConfigItem(), string2);
    }

    public void addLongItem(String string, long l, String string2) {
        this.addItem(string, (ConfigItem)new LongConfigItem(l), string2);
    }

    public void addLongItem(String string, long l, long l2, String string2) {
        this.addItem(string, (ConfigItem)new LongConfigItem(l, l2), string2);
    }

    public void addStringItem(String string) {
        this.addItem(string, (ConfigItem)new StringConfigItem());
    }

    public void addStringItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new StringConfigItem(), string2);
    }

    public void addFileItem(String string) {
        this.addItem(string, (ConfigItem)new FileConfigItem());
    }

    public void addFileItem(String string, boolean bl) {
        this.addItem(string, (ConfigItem)new FileConfigItem(bl));
    }

    public void addFileItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new FileConfigItem(), string2);
    }

    public void addFileItem(String string, boolean bl, String string2) {
        this.addItem(string, (ConfigItem)new FileConfigItem(bl), string2);
    }

    public void addFileItem(String string, boolean bl, String string2, RelativeConfigItem.Resolve resolve) {
        this.addItem(string, (ConfigItem)new FileConfigItem(bl, resolve), string2);
    }

    public void addChoiceItem(String string, String[] stringArray, boolean bl) {
        this.addItem(string, (ConfigItem)new ChoiceConfigItem(stringArray, bl));
    }

    public void addChoiceItem(String string, String[] stringArray, boolean bl, String string2) {
        this.addItem(string, (ConfigItem)new ChoiceConfigItem(stringArray, bl), string2);
    }

    public void addListItem(String string) {
        this.addItem(string, (ConfigItem)new ListConfigItem());
    }

    public void addListItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new ListConfigItem(), string2);
    }

    public void addURLItem(String string) {
        this.addItem(string, (ConfigItem)new URLConfigItem());
    }

    public void addURLItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new URLConfigItem(), string2);
    }

    public void addURLItem(String string, String string2, RelativeConfigItem.Resolve resolve) {
        this.addItem(string, (ConfigItem)new URLConfigItem(resolve), string2);
    }

    public void addURLListItem(String string) {
        this.addItem(string, (ConfigItem)new URLListConfigItem());
    }

    public void addURLListItem(String string, String string2) {
        this.addItem(string, (ConfigItem)new URLListConfigItem(), string2);
    }

    public void addURLListItem(String string, String string2, boolean bl) {
        this.addItem(string, (ConfigItem)new URLListConfigItem(bl), string2);
    }

    public void addURLListItem(String string, String string2, boolean bl, RelativeConfigItem.Resolve resolve) {
        this.addItem(string, (ConfigItem)new URLListConfigItem(bl, RelativeConfigItem.Resolve.Soft), string2);
    }

    public void readInstanceFrom(RawConfig rawConfig, String string, String string2) throws ConfigValidationException {
        this.reset();
        this.readFrom(rawConfig.getInstance(string, string2));
    }

    public boolean getBooleanValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof BooleanConfigItem)) {
            throw new IllegalArgumentException("Attempted to read boolean value from non-BooleanConfigItem");
        }
        return ((BooleanConfigItem)configItem).booleanValue();
    }

    public int getIntegerValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof IntegerConfigItem)) {
            throw new IllegalArgumentException("Attempted to read integer value from non-IntegerConfigItem");
        }
        return ((IntegerConfigItem)configItem).intValue();
    }

    public long getLongValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof LongConfigItem)) {
            throw new IllegalArgumentException("Attempted to read long value from non-LongConfigItem");
        }
        return ((LongConfigItem)configItem).longValue();
    }

    public String getStringValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof StringConfigItem)) {
            throw new IllegalArgumentException("Attempted to read String value from non-StringConfigItem");
        }
        return ((StringConfigItem)configItem).stringValue();
    }

    public File getFileValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof FileConfigItem)) {
            throw new IllegalArgumentException("Attempted to read File value from non-FileConfigItem");
        }
        return ((FileConfigItem)configItem).fileValue();
    }

    public String[] getListValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof ListConfigItem)) {
            throw new IllegalArgumentException("Attempted to read List value from non-ListConfigItem");
        }
        return ((ListConfigItem)configItem).stringArrayValue();
    }

    public String[] getChoiceValue(String string) throws IllegalArgumentException, InvalidItemException {
        return this.getListValue(string);
    }

    public URL getURLValue(String string) {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof URLConfigItem)) {
            throw new IllegalArgumentException("Attempted to read URL value from non-URLConfigItem");
        }
        return ((URLConfigItem)configItem).urlValue();
    }

    public URL[] getURLListValue(String string) throws IllegalArgumentException, InvalidItemException {
        ConfigItem configItem = this.getItem(string);
        if (!(configItem instanceof URLListConfigItem)) {
            throw new IllegalArgumentException("Attempted to read URLList value from non-URLListConfigItem");
        }
        return ((URLListConfigItem)configItem).urlArrayValue();
    }

    private static class Concept {
        ValidatedConfig c;
        boolean b;

        public Concept(ValidatedConfig validatedConfig, boolean bl) {
            this.c = validatedConfig;
            this.b = bl;
        }
    }

    private static class Item {
        ConfigItem f;
        boolean d;
        String e;
        boolean c;
        String[] b;

        public Item(ConfigItem configItem) {
            this.f = configItem;
            this.d = true;
            this.e = null;
            this.c = false;
            this.b = null;
        }

        public Item(ConfigItem configItem, String string) {
            this.f = configItem;
            this.d = false;
            this.e = string;
            this.b = null;
            if (this.e != null) {
                try {
                    this.f.checkDefault(this.e);
                }
                catch (ConfigItemException configItemException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid default value: " + this.e);
                    illegalArgumentException.initCause(configItemException);
                    throw illegalArgumentException;
                }
            }
        }

        void c() {
            this.f.resetValue();
            this.c = false;
        }

        void b(RawConfig rawConfig) throws ConfigItemException {
            if (this.e != null) {
                this.f.setValue(this.e, rawConfig);
            }
        }

        void b(String string, RawConfig rawConfig) throws ConfigItemException {
            this.f.setValue(string, rawConfig);
            this.c = true;
        }

        boolean b() {
            return this.c;
        }

        void b(String[] stringArray) {
            this.b = stringArray;
        }

        boolean d() {
            return this.b != null && this.b.length > 1;
        }
    }
}

