/*
 * Decompiled with CFR 0.152.
 */
package com.connecterra.util.event;

import com.connecterra.util.event.AlarmClock;
import com.connecterra.util.event.Event;
import com.connecterra.util.event.EventProcessor;
import com.connecterra.util.event.EventReceiver;
import com.connecterra.util.event.PeriodicEvent;
import com.connecterra.util.event.QueueFullException;
import com.connecterra.util.event.Scheduler;

public class AbstractEventProcessor
implements EventProcessor {
    private EventReceiver h;
    private AlarmClock i;

    protected AbstractEventProcessor() {
    }

    protected AbstractEventProcessor(String string, Scheduler scheduler, int n) {
        this(string, scheduler, n, null);
    }

    protected AbstractEventProcessor(String string, Scheduler scheduler, int n, AlarmClock alarmClock) {
        this.initialize(string, scheduler, n, alarmClock);
    }

    protected void initialize(EventReceiver eventReceiver, AlarmClock alarmClock) {
        this.h = eventReceiver;
        this.i = alarmClock;
    }

    protected void initialize(EventReceiver eventReceiver) {
        this.initialize(eventReceiver, null);
    }

    protected void initialize(String string, Scheduler scheduler, int n, AlarmClock alarmClock) {
        this.initialize(new EventReceiver(string, this, scheduler, n), alarmClock);
    }

    protected void initialize(String string, Scheduler scheduler, int n) {
        this.initialize(string, scheduler, n, null);
    }

    protected EventReceiver getEventReceiver() {
        return this.h;
    }

    public void handleEvent(Object object) {
        ((Event)object).handle();
    }

    protected void doASAP(Event event) {
        if (this.h == null) {
            throw new IllegalStateException("AbstractEventProcessor not initialized");
        }
        this.h.receiveEvent(event);
    }

    protected void doASAPOrBlock(Event event) throws InterruptedException {
        if (this.h == null) {
            throw new IllegalStateException("AbstractEventProcessor not initialized");
        }
        this.h.receiveEventOrBlock(event);
    }

    protected void doASAPOrDrop(Event event) {
        if (this.h == null) {
            throw new IllegalStateException("AbstractEventProcessor not initialized");
        }
        this.h.receiveEventOrDrop(event);
    }

    protected void doASAPOrThrow(Event event) throws QueueFullException {
        if (this.h == null) {
            throw new IllegalStateException("AbstractEventProcessor not initialized");
        }
        this.h.receiveEventOrThrow(event);
    }

    protected void doLater(long l, Event event) {
        if (this.h == null) {
            throw new IllegalStateException("AbstractEventProcessor not initialized");
        }
        if (this.i == null) {
            throw new IllegalStateException("doLater must be used with an AlarmClock");
        }
        this.i.add(l, this.h, event);
    }

    protected void doPeriodic(final PeriodicEventHandle periodicEventHandle, final long l, final PeriodicEvent periodicEvent) {
        periodicEventHandle.b++;
        final int n = periodicEventHandle.b;
        this.doASAP(new Event(){

            public void handle() {
                AbstractEventProcessor.this.b(n, periodicEventHandle, l, periodicEvent);
            }
        });
    }

    private void b(final int n, final PeriodicEventHandle periodicEventHandle, final long l, final PeriodicEvent periodicEvent) {
        if (n != periodicEventHandle.b || periodicEvent.stopped()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        periodicEvent.handle();
        if (n != periodicEventHandle.b || periodicEvent.stopped()) {
            return;
        }
        long l3 = l2 + l - System.currentTimeMillis();
        this.doLater(l3, new Event(){

            public void handle() {
                AbstractEventProcessor.this.b(n, periodicEventHandle, l, periodicEvent);
            }
        });
    }

    protected static class PeriodicEventHandle {
        private volatile int b;
    }
}

