package com.sato.BEA;
/*******************************************************************************
 * Immediate Program Sample
 * 
 * BEA WebLogic RFID Edge Server Sample Code
 *
 * This sample code is provided to illustrate the use of BEA Weblogic RFID
 * Edge Server and to provide a starting point for developers to create their 
 * own applications. BEA Systems does not claim any copyright in this file.  
 * Other files and software within BEA WebLogic RFID Edge Server may be covered 
 * under copyright and subject to license terms.
 *
 * THIS SAMPLE CODE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR BEA SYSTEMS, INC., BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SAMPLE CODE OR THE USE OR OTHER DEALINGS IN
 * THE SAMPLE CODE. 
 * 
 *******************************************************************************/

import com.connecterra.alepc.api.ALEPC;
import com.connecterra.alepc.api.PCWriteReport;
import com.connecterra.alepc.api.PCSpec;
import com.connecterra.alepc.client.AxisALEPCClient;
import com.connecterra.alepc.encoding.PCXMLDeserializer;
import com.connecterra.alepc.encoding.PCXMLDeserializerException;
import com.connecterra.alepc.encoding.PCXMLSerializationFactory;
import com.connecterra.alepc.encoding.PCXMLSerializer;
import com.connecterra.alepc.encoding.PCXMLSerializerException;

import java.io.*;

import java.net.URL;
import java.net.URI;


/**
 * ImmediateProgramSample shows a simple example of how to use the
 * ALEPC api to program an Electronic Product Code (EPC) value into a
 * tag using a specified logical reader.
 * <p>
 * The programming cycle specification is read from an XML file, and the
 * programming cycle reports are printed as XML.
 */
public class ImmediateProgramSample
{	
    String result = "";		
    public ImmediateProgramSample(String[] args)  
    {
        System.out.println( "Immediate Program Sample, XML-based" );
		
        try 
        {
            String aleServiceURL = args[0];
            String pcSpecFilename = args[1];
            String epcVal = args[2];
        
            // create a new ALE client instance...
            ALEPC aleClient = new AxisALEPCClient(new URL(aleServiceURL));
			
            // a PCSpec (Programming Cycle Specification) contains all the
            // information that defines a programming cycle.  This PCSpec can be
            // defined in XML and read in, or defined programatically.  Here we
            // read it in XML from a file.
            PCSpec pcSpec = readPCSpec(pcSpecFilename);
						
            // once an PCSpec is created, we can ask for one programming cycle
            // to be executed right now using the ALEPC.immediate() method.
            // immediate() blocks until one programming cycle is complete,
            // and then returns the resulting report.
            System.out.println( "  sending request to Edge Server...");
            PCWriteReport writeReport = aleClient.immediate(pcSpec, new URI(epcVal));
            System.out.println( "  ...received response.\n");

            result = printWriteReport(writeReport);
        }
        catch (Exception e)
        {
            e.printStackTrace();
            result = "Exception : "+e.toString();
        }
    }
    
    public String getResult() { return result; }
	
    /**
     * Helper method to read a programming cycle specification from an XML-formatted
     * file.
     */
    private static PCSpec readPCSpec(String pcSpecFilename) 
        throws IOException, 
               PCXMLDeserializerException 
    {
        // certain objects, such as PCSpec and PCWriteReport, can be converted
        // to and from an XML representation.  The PCXMLSerializationFactory
        // is a singleton from which an XML serializer or deserializer can
        // be obtained for performing such XML conversions.

        // Here, we obtain a XML deserializer, because we want to parse an
        // XML-formatted programming cycle specification into a corresponding
        // PCSpec instance.
        PCXMLSerializationFactory factory = PCXMLSerializationFactory.getInstance();
        PCXMLDeserializer deserializer = factory.createDeserializer();

        FileReader fileReader = new FileReader(pcSpecFilename);

        PCSpec pcSpec = deserializer.deserializePCSpec(fileReader);
        return pcSpec;
    }

    /**
     * Helper method to print to System.out an XML-formatted representation
     * of the supplied programming cycle write report.
     */
    private static String printWriteReport(PCWriteReport writeReport) 
        throws PCXMLSerializerException,
               IOException
    {
        String filename = "../webapps/satoBEA/temp/print.txt";
        // use an XML serializer to convert the PCWriteReport instance to an
        // XML-formatted representation of the report contents.
        PCXMLSerializationFactory factory = PCXMLSerializationFactory.getInstance();
        PCXMLSerializer serializer = factory.createSerializer();

        // the serializer has two overloaded serialize() methods.  One such
        // overload returns a java.lang.String which is the XML-formatted
        // representation of the write report.  The other overload, which we
        // use here, writes the XML representation to a java.io.Writer.
        Writer out = new OutputStreamWriter(new FileOutputStream(filename));
        serializer.serialize(writeReport, out, true); // the 'true' flag causes 
                                                    // the XML to be
                                                    // pretty-printed (indented)
        out.flush();
        return filename;
    }
}
