///////////////////////////////////////////////////////////////////////////////
//	Module		: CLoader.h		
//	Description	: Header of CLoader class 
//
//	Author		: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail		: matsuzawa.jei@nifty.com
//-----------------------------------------------------------------------------
//Maintenance:
//	Oct. 16, '18	1st release
////////////////////////////////////////////////////////////////////////////////
#ifndef CLoaderIncluded
#define CLoaderIncluded

class	CLoader{
	ifstream	fin;						// input file
	char*	pLM;							// pointer to Load module
	char*	pGet;							// pointer for reading
	uint	nSize;							// binary data size
	uint	nOffset;						// binary data size

	void	extractData();					// extract binary data		
	char	getByte(char* ptr);				// get byte 
	uint 	getLaddr(char* ptr,int cnt);	// get load address
	int		hex2bin(int n);					// convert HEX-ASCII to binary
public:
	CLoader(int size, int offset);			// Constructor
	~CLoader();								// Destructor
	int		loadSformat(char* fname);		// Load Motrola S-format
	char	getchar();						// get a binary data 
	int		getSize() {return nSize;} 		// get binary data size
};

#endif
