////////////////////////////////////////////////////////////////////////////////
//	Module		: xr16L2750.h
//	Description	: Definition of UART EXAR XR16L2750. 
//
//	Compiler		: gcc version 3.2.2 or higher 
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu.jei@nifty.com
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Maintenance:
//	<Date>		 <Version>	<Desc.>
//	Feb.17, 2006  0.0.1		 1st release for evaluation 
//- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Note: Please set TS(Tab Stop) to 4, to edit/view this file properly. 
///////////////////////////////////////////////////////////////////////////////	
#ifndef XR16L2750Included
#define XR16L2750Included

#define uart(n) ((n) > 0 ? (pUARTREG+8) : pUARTREG)
#define	READB(n) (uchar)(readl(n) & 0xff)

//	Registers	
//
//		16C550 Compatible Registers	__________________________________________
//
#define RHR(n)	(uart(n))		// Receive Holding		(R)

#define THR(n)	(uart(n))		// Transmit Holding		(W)

#define DLL(n)	(uart(n))		// Div Latch Low byte	(R/W)

#define IER(n)	(uart(n)+1)		// Interrupt Enable		(R/W)
	#define IER_RX		0x01		// RX data int.
	#define IER_TX		0x02		// TX data int.
	#define IER_LS		0x04		// Line Status int.
	#define IER_MS		0x08		// Modem Status int.
	#define	RX_ENABLE	IER_RX			// enable RX interrupt
	#define	RX_DISABLE	0				// disable both of TX/RX interrupts
	#define	TX_ENABLE	IER_RX|IER_TX	// enable both of TX/RX interrupts
	#define	TX_DISABLE	IER_RX			// enable both of TX/RX interrupts

#define DLM(n)	(uart(n)+1)		// Div Latch High byte	(R/W)

#define ISR(n)	(uart(n)+2)		// Interrupt Status		(R)
	#define ISR_NONE	0x01		// None
	#define ISR_TXRDY	0x02		// Transmit Ready
	#define ISR_RXRDY	0x04		// Receive Data Ready
	#define ISR_RXTO	0x0C		// Receive Data Timeout

#define FCR(n)	(uart(n)+2)		// FIFO Control			(W)
	#define FCR_FE  	0x01		// FIFOs Enable
	#define FCR_RFR 	0x02		// RX FIFO Reset
	#define FCR_TFR 	0x04		// TX FIFO Reset
	#define FCR_DME  	0x08		// DMA Mode Enable
	#define	RXFTL_8		0x80		// RX FIFO Triger Level 8 bytes
	#define	RXFTL_14	0xC0		// RX FIFO Triger Level 14 bytes
	#define	FIFO_RESET	(FCR_RFR|FCR_TFR)			// RX/TX FIFO Reset
	#define	FCR_DEFAULT	(FCR_FE|FCR_DME|RXFTL_8)	 

#define LCR(n)	(uart(n)+3)		// Line Control			(R/W)
	#define LCR_DEFAULT	0x03		// 8bits data, 1stop, no parity 
	#define LCR_DE 		0x80		// Divisor Enable
	#define LCR_EER 	0xBF		// Enable Enhanced Register

#define MCR(n)	(uart(n)+4)		// Modem Control		(R/W)
	#define MCR_DTR		0x01		// DTR				(O)
	#define MCR_RTS		0x02		// RTS				(O)
	#define MCR_IOE		0x08		// Int Output Enable 
	#define MCR_CPS		0x80		// Clock Prescaler Select
	#define MCR_DEFAULT	(MCR_IOE)

#define LSR(n)	(uart(n)+5)		// Line Status			(R)
	#define LSR_RDR		0x01		// RX Data Ready
	#define LSR_OE		0x02		// Overrun Error
	#define LSR_PE		0x04		// Parity Error
	#define LSR_FE		0x08		// Framing Error
	#define LSR_THRE	0x20  		// Transmitter Holding Register Empty
	#define LSR_TTE		0x40		// THR & TSR Empty
	#define LSR_FIE		0x80		// FIFO Error
	#define LSR_ERR		(LSR_FIE|LSR_FE|LSR_PE|LSR_OE)

#define MSR(n)	(uart(n)+6)		// Modem Status			(R)
	#define MSR_DCTS	0x01		// Delta Clear To Send  (I)
	#define MSR_DDSR	0x02  		// Delta Data Set Ready	(I)
	#define MSR_CTS		0x10  		// Clear To Send		(I)
	#define MSR_DSR		0x20  		// Data Set Ready		(I)
	#define MSR_DCD		0x80  		// Data Carrier Detect	(I)

//		Enhanced Registers ___________________________________________________
//
#define FC(n) 	(uart(n))		// FIFO Level Counter	(R)

#define TRG(n)	(uart(n))		// FIFO Trigger level	(W)

#define EFR(n)	(uart(n)+2)		// Enhanced Function	(R/W)
	#define	EFR_FLOW	0x02		// receiver compares XON/XOFF
	#define	EFR_EN		0x10		// enable IER,ISR,FCR,MCR (shadows)

#define XON1(n)	(uart(n)+4)		// XON Character 1		(R/W)

#define XOFF1(n)(uart(n)+6)		// XOFF Character 1		(R/W)

#define	XON_CHAR	0x11		// XON = ^Q
#define	XOFF_CHAR	0x13		// XON = ^S

//	Misc.	__________________________________________________________________

//	Special characters
//
#define	PAGEEND			0x0c			// page end status from EIF 

//	data structure for UART RX/TX Buffer
//
#define	BUFSZ			64

typedef struct	tagBUFFER {
	uchar	data[BUFSZ];				// data buffer
	int		writeP;						// write position
	int		readP;						// read position
} BUFFER;

//	struction of Device Control Blcok

typedef struct  tagDCB {
	int		port;				// port #
	int		trigger;			// trigger level 
	int		baud;				// baud rate table #
	int		xon;				// 1 : xon/xoff flow control enable
    wait_queue_head_t   rxq;    // queue for rx
	wait_queue_head_t   txq;    // queue for tx
    BUFFER  rxBuf;              // RX buffer
	BUFFER  txBuf;              // TX buffer
} DCB;

//	macros for interrupt counters

#define	EIF_TXRDY_CNT	(iIntCount[5])
#define	EIF_RXTO_CNT	(iIntCount[6])
#define	EIF_RXRDY_CNT	(iIntCount[7])
#define	OP_TXRDY_CNT	(iIntCount[8])
#define	OP_RXTO_CNT		(iIntCount[9])
#define	OP_RXRDY_CNT	(iIntCount[10])
#define	PAGEND_CNT		(iIntCount[11])

#endif
