////////////////////////////////////////////////////////////////////////////////
//	Module		: CSformat.h		
//	Description	: Definition of CSformat class 
//
//	Author		: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail		: tmatsu@po.mcci.or.jp
//------------------------------------------------------------------------------
//Maintenance:
//	Apr. 14, '03	1st release
//------------------------------------------------------------------------------
// Copyright (C) 2003 Japan Electronics Ind.,Inc.  All Rights Reserved.
////////////////////////////////////////////////////////////////////////////////
#ifndef CSformatIncluded
#define CSformatIncluded

#include	<iostream>
#include	<fstream>
using namespace std;
		
#define		REC_MARK_S	'S'	
#define		REC_MARK_H	':'	
#define		END_RECORD	1

#define		tmpfile	"fwup.tmp"

class	CSformat{
	ifstream	fin;						// input file
	fstream		tmp;						// temporary file
	int			nStatus;					// status
	int			nSize;						// size of binary data
	int			nS1start;					// start address of S1
	int			nS2start;					// start address of S2

	void	extractData();					// extract binary data		
	int		getByte(char* ptr);				// get byte 
	int		getLaddr(char* ptr, int cnt);	// get load address
	int		hex2bin(int n);					// convert HEX-ASCII to binary
public:
	CSformat(char* fname);					// Constructor
	~CSformat();							// Destructor
	char	getchar();						// get a binary data 
	int		gets(char*buf, int n);			// get binary string 
	int		getSize() {return nSize;}		// get binary data size
	int		getStart() {return nS1start;}	// get start address
	int		getStatus() {return nStatus;}	// get status
};


#endif
