//////////////////////////////////////////////////////////////////////////////
//	Module			: eif_api.h
//	Description		: API for CEif class 
//
//	Compiler		: gcc version 3.2.2 or higher 
//	Author			: T.Matsuzawa of JEI Matsumoto Lab.
//	E-mail			: tmatsu.jei@nifty.com
//-----------------------------------------------------------------------------
//	Maintenance:
//		May 17,'05		Defined newly	
//		Apr.19,'07		Added support of programming descriptor, font and error
///////////////////////////////////////////////////////////////////////////////
// High-level API for libPIF	-	CEif class 

#include	"code.h"
#include	"eifcmd.h"

#define	EIF_TX_ERROR		-1
#define	EIF_RX_TIMEOUT		-2
#define	EIF_RX_ILLEGAL		-3

//	Macros for methods of CEif instance

#define EI_GetIntCnt(lib,index) 		lib->pEif->getIntCnt(index)
#define	EI_GetRegister(lib,reg)			lib->pEif->getRegister(reg)
#define	EI_GetMcuStatus(lib,reg)		lib->pEif->getMcuStatus(reg)
#define EI_PutMcuSetup(lib,cmd,par)		lib->pEif->putMcuSetup(cmd,par)
#define EI_PutRegister(lib,reg,val)		lib->pEif->putRegister(reg,val)

#define EI_GetCTS(lib) 					lib->pEif->getCTS()
#define EI_GetConfig(lib) 				lib->pEif->getConfig()
#define EI_GetPageEnd(lib) 				lib->pEif->getPageEnd()
#define EI_GetTotalPageEnd(lib) 		lib->pEif->getTotalPageEnd()
#define EI_PutOperation(lib,cmd,par) 	lib->pEif->putOperation(cmd,par)
#define EI_PutRequest(lib,cmd,cnf,flag) lib->pEif->putRequest(cmd,cnf,flag)
#define EI_PutSetup(lib,cmd,par,cnf) 	lib->pEif->putSetup(cmd,par,cnf)
#define EI_ResetPageEnd(lib) 			lib->pEif->resetPageEnd()
#define EI_PutConfig(lib) 				lib->pEif->setConfig()
#define	EI_Puts(lib, ptr)				lib->pEif->puts(ptr)

//	Macros for EIF commands
//		Operation Commands
#define	EI_ResetPrinter(lib)		lib->pEif->putOperation(O_INIT,ON)
#define	EI_MoveSGFront(lib)			lib->pEif->putOperation(O_SWINGF,ON)
#define	EI_MoveSGRear(lib)			lib->pEif->putOperation(O_SWINGR,ON)
#define	EI_MoveSGHome(lib)			lib->pEif->putOperation(O_SWINGH,ON)
#define	EI_MoveSGTurnout(lib)		lib->pEif->putOperation(O_SWINGT,ON)
#define	EI_StartPrint(lib)			lib->pEif->putOperation(O_PRINT,ON)
#define	EI_StopPrint(lib)			lib->pEif->putOperation(O_PRINT,OFF)
#define	EI_AdjustTOF(lib)			lib->pEif->putOperation(O_TOF,ON)
#define	EI_Skip(lib)				lib->pEif->putOperation(O_SKIP,ON)
#define	EI_Feed(lib)				lib->pEif->putOperation(O_FEED,ON)
#define	EI_Cut(lib)					lib->pEif->putOperation(O_CUT,ON)
#define	EI_Update(lib,cmd)			lib->pEif->putOperation(O_EIFPROG+cmd,ON)

//		Setup commands
#define	EI_PutTotalCounter(lib,par)	lib->pEif->putSetup(SR_TC,par,-1)
#define	EI_PutImageDensity(lib,par)	lib->pEif->putSetup(SR_ID,par,CNF_ID)
#define	EI_PutFormHeight(lib,par)	lib->pEif->putSetup(SR_FH,par,CNF_FH)
#define	EI_PutFormWidth(lib,par)	lib->pEif->putSetup(SR_FW,par,CNF_FW)
#define	EI_PutSuctionFan(lib,par)	lib->pEif->putSetup(SR_SFD,par,CNF_SFD)
#define	EI_PutTransferCrnt(lib,par)	lib->pEif->putSetup(SR_TRC,par,CNF_TRC)
#define	EI_PutSCHMode(lib,par)		lib->pEif->putSetup(SR_SCC,par,CNF_SCC)
#define	EI_PutResolution(lib,par)	lib->pEif->putSetup(SR_RES,par,CNF_RES)
#define	EI_PutCBCounter(lib,par)	lib->pEif->putSetup(S_RCC,par,-1)
#define	EI_PutVFAdjust(lib,par)		lib->pEif->putSetup(SR_VFA,par,CNF_VFA)
#define	EI_PutHFAdjust(lib,par)		lib->pEif->putSetup(SR_HFA,par,CNF_HFA)
#define	EI_PutTopMargin(lib,par)	lib->pEif->putSetup(SR_TM,par,CNF_TM)
#define	EI_PutBottomMargin(lib,par)	lib->pEif->putSetup(SR_BM,par,CNF_BM)
#define	EI_PutLeftMargin(lib,par)	lib->pEif->putSetup(SR_LM,par,CNF_LM)
#define	EI_PutLC(lib,par,idx)		lib->pEif->putSetup(SR_LC+idx,par,-1)
#define	EI_PutPMC(lib,par,idx)		lib->pEif->putSetup(SR_PMC+idx,par,-1)
#define	EI_PutOffline(par)			lib->pEif->putSetup(S_OFM,par,-1)
	
//		Status Request Commands
#define	EI_GetTotalCounter(lib)		lib->pEif->putRequest(SR_TC,-1,0)
#define	EI_GetImageDensity(lib,flg)	lib->pEif->putRequest(SR_ID,CNF_ID,flg)
#define	EI_GetFormHeight(lib,flg)	lib->pEif->putRequest(SR_FH,CNF_FH,flg)
#define	EI_GetFormWidth(lib,flg)	lib->pEif->putRequest(SR_FW,CNF_FW,flg)
#define	EI_GetSuctionFan(lib,flg)	lib->pEif->putRequest(SR_SFD,CNF_SFD,flg)
#define	EI_GetTransferCrnt(lib,flg)	lib->pEif->putRequest(SR_TRC,CNF_TRC,flg)
#define	EI_GetSCHMode(lib,flg)		lib->pEif->putRequest(SR_SCC,CNF_SCC,flg)
#define	EI_GetResolution(lib,flg)	lib->pEif->putRequest(SR_RES,CNF_RES,flg)
#define	EI_GetCBCounter(lib)		lib->pEif->putRequest(R_CBC,-1,0)
#define	EI_GetDevUnitCounter(lib)	lib->pEif->putRequest(R_DUC,-1,0)
#define	EI_GetDevPowderCounter(lib)	lib->pEif->putRequest(R_DPC,-1,0)
#define	EI_GetPCCCounter(lib)		lib->pEif->putRequest(R_PCC,-1,0)
#define	EI_GetVFAdjust(lib,flg)		lib->pEif->putRequest(SR_VFA,CNF_VFA,flg)
#define	EI_GetHFAdjust(lib,flg)		lib->pEif->putRequest(SR_HFA,CNF_HFA,flg)
#define	EI_GetTopMargin(lib,flg)	lib->pEif->putRequest(SR_TM,CNF_TM,flg)
#define	EI_GetBottomMargin(lib,flg)	lib->pEif->putRequest(SR_BM,CNF_BM,flg)
#define	EI_GetLeftMargin(lib,flg)	lib->pEif->putRequest(SR_LM,CNF_LM,flg)
#define	EI_GetLifeCounter(lib,idx)	lib->pEif->putRequest(SR_LC+idx,-1,0)
#define	EI_GetSuctionFanSt(lib)		lib->pEif->putRequest(SR_LC+idx,-1,0)
#define	EI_GetPMCounter(lib,idx)	lib->pEif->putRequest(SR_PMC+idx,-1,0)
#define	EI_GetEST(lib)				lib->pEif->putRequest(R_EST,-1,0)
#define	EI_GetLCStatus(lib)			lib->pEif->putRequest(R_LCS,-1,0)
#define	EI_GetWarning(lib)			lib->pEif->putRequest(R_WRN,-1,0)
#define	EI_GetRError(lib)			lib->pEif->putRequest(R_RER,-1,0)
#define	EI_GetFError(lib)			lib->pEif->putRequest(R_FER,-1,0)
#define	EI_GetPCStatus(lib)			lib->pEif->putRequest(R_PCS,-1,0)
#define	EI_GetPrinterInfo(lib)		lib->pEif->putRequest(R_PRI,-1,0)
#define	EI_GetMCStatus(lib)			lib->pEif->putRequest(R_MCS,-1,0)
	
#define	EI_GetVOrigin(lib)			lib->pEif->putRequest(R_VOR,-1,0)
#define	EI_GetHOrigin(lib)			lib->pEif->putRequest(R_HOR,-1,0)
#define	EI_GetTMVposition(lib)		lib->pEif->putRequest(R_TMV,-1,0)
#define	EI_GetTMHposition(lib)		lib->pEif->putRequest(R_TMH,-1,0)
#define	EI_GetDrumIdling(lib)		lib->pEif->putRequest(R_DIT,-1,0)
#define	EI_GetEnergyForFusion(lib)	lib->pEif->putRequest(R_EFF,-1,0)
#define	EI_GetAIDC07(lib)			lib->pEif->putRequest(R_A07,-1,0)
#define	EI_GetAIDC08(lib)			lib->pEif->putRequest(R_A08,-1,0)
#define	EI_GetAIDC09(lib)			lib->pEif->putRequest(R_A09,-1,0)
#define	EI_GetAIDC10(lib)			lib->pEif->putRequest(R_A10,-1,0)
#define	EI_GetAIDC11(lib)			lib->pEif->putRequest(R_A11,-1,0)
#define	EI_GetAIDC12(lib)			lib->pEif->putRequest(R_A12,-1,0)
#define	EI_GetBursterAdjust(lib)	lib->pEif->putRequest(R_BUA,-1,0)
#define	EI_GetEIFMajorVersion(lib)	lib->pEif->putRequest(R_EVER,-1,0)
#define	EI_GetMCMajorVersion(lib)	lib->pEif->putRequest(R_MVER,-1,0)
#define	EI_GetSCMajorVersion(lib)	lib->pEif->putRequest(R_SVER,-1,0)
#define	EI_GetEIFMinorVersion(lib)	lib->pEif->putRequest(R_EMV,-1,0)
#define	EI_GetMC1MinorVersion(lib)	lib->pEif->putRequest(R_MMV1,-1,0)
#define	EI_GetMC2MinorVersion(lib)	lib->pEif->putRequest(R_MMV2,-1,0)
#define	EI_GetSCMinorVersion(lib)	lib->pEif->putRequest(R_SMV,-1,0)
#define	EI_GetMC2MajorVersion(lib)	lib->pEif->putRequest(R_MVR2,-1,0)
#define	EI_GetSwingGuidePos(lib)	lib->pEif->putRequest(R_SGP,-1,0)
