/*	This file is part of Jenux.

    Jenux is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Jenux is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Jenux.  If not, see <http://www.gnu.org/licenses/>.

	Module			: pifc_api.h
	Description		: Header file for pifc2 device driver API 
	Compiler		: gcc 4.8.5++
	Email			: matsuzawa.jei@nifty.com
	Maintenance		:
		May 25.'17	Released as GPL software officially
*/
#ifndef PIFAPI_INCLUDED
#define PIFAPI_INCLUDED

#include	"pif_ioctl.h"
	
//	Definition of PCI9054 Local Registers

#define	R_PCI_INTCSR	(0x0068/4)  // Interrupt Control/Status Register
#define R_PCI_CNTRL		(0x006C/4)	// Control Register

//	Definition of PIFC registes #

#define	R_PIF_CTRL		0+64		// Resource Control Register	
#define	R_PIF_ISR		1+64		// Interrupt/Status Register
#define R_PIF_TEST		2+64		// Test Register
#define R_VIDEO_SIZER   3+64		// Video Size Register(R)
#define R_VIDEO_DIM  	4+64		// Video Dimension Register
#define R_VIDEO_SIZE    5+64		// Video Size Register(RW)
#define R_VIDEO_TEST    6+64		// Video Test Register 1 

#define	R_UART_RHRA		16+64		// UART RHR channel A
#define	R_UART_THRA		16+64		// UART THR channel A
#define	R_UART_IERA		17+64		// UART IER channel A
#define	R_UART_FCRA		18+64		// UART FCR channel A
#define	R_UART_ISRA		18+64		// UART ISR channel A
#define	R_UART_LCRA		19+64		// UART LCR channel A
#define	R_UART_MCRA		20+64		// UART MCR channel A
#define	R_UART_LSRA		21+64		// UART LSR channel A
#define	R_UART_MSRA		22+64		// UART MSR channel A
#define	R_UART_RHRB		24+64		// UART RHR channel B
#define	R_UART_THRB		24+64		// UART THR channel B
#define	R_UART_IERB		25+64		// UART IER channel B
#define	R_UART_FCRB		26+64		// UART FCR channel B
#define	R_UART_ISRB		26+64		// UART ISR channel B
#define	R_UART_LCRB		27+64		// UART LCR channel B
#define	R_UART_MCRB		28+64		// UART MCR channel B
#define	R_UART_LSRB		29+64		// UART LSR channel B
#define	R_UART_MSRB		30+64		// UART MSR channel B

//	Baud Rate
#define BAUD_9600		0	
#define BAUD_19200		1	
#define BAUD_38400		2

//	RX FIFO Trigger Level
#define TRIGGER_1		0
#define TRIGGER_4		1
#define TRIGGER_8		2
#define TRIGGER_14		3

#endif
